/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;

public class GeneralOptionPane
extends AbstractOptionPane {
    public static final int checkFileStatus_none = 0;
    public static final int checkFileStatus_focus = 1;
    public static final int checkFileStatus_focusBuffer = 2;
    public static final int checkFileStatus_all = 3;
    private JComboBox checkModStatus;
    private JComboBox checkModStatusUpon;
    private JSpinner recentFiles;
    private JSpinner hypersearchResultsWarning;
    private JCheckBox saveCaret;
    private JCheckBox sortRecent;
    private JCheckBox persistentMarkers;
    private JCheckBox restore;
    private JCheckBox restoreRemote;
    private JCheckBox restoreCLI;
    private JCheckBox restoreSplits;
    private JCheckBox useDefaultLocale;
    private JComboBox lang;

    public GeneralOptionPane() {
        super("general");
    }

    @Override
    protected void _init() {
        String[] modCheckOptions = new String[]{jEdit.getProperty("options.general.checkModStatus.nothing"), jEdit.getProperty("options.general.checkModStatus.prompt"), jEdit.getProperty("options.general.checkModStatus.reload"), jEdit.getProperty("options.general.checkModStatus.silentReload")};
        this.checkModStatus = new JComboBox<String>(modCheckOptions);
        if (jEdit.getBooleanProperty("autoReload")) {
            if (jEdit.getBooleanProperty("autoReloadDialog")) {
                this.checkModStatus.setSelectedIndex(2);
            } else {
                this.checkModStatus.setSelectedIndex(3);
            }
        } else if (jEdit.getBooleanProperty("autoReloadDialog")) {
            this.checkModStatus.setSelectedIndex(1);
        } else {
            this.checkModStatus.setSelectedIndex(0);
        }
        this.addComponent(jEdit.getProperty("options.general.checkModStatus"), (Component)this.checkModStatus);
        String[] modCheckUponOptions = new String[]{jEdit.getProperty("options.general.checkModStatusUpon.none"), jEdit.getProperty("options.general.checkModStatusUpon.focus"), jEdit.getProperty("options.general.checkModStatusUpon.visitBuffer"), jEdit.getProperty("options.general.checkModStatusUpon.all")};
        this.checkModStatusUpon = new JComboBox<String>(modCheckUponOptions);
        this.checkModStatusUpon.setSelectedIndex(jEdit.getIntegerProperty("checkFileStatus"));
        this.addComponent(jEdit.getProperty("options.general.checkModStatusUpon"), (Component)this.checkModStatusUpon);
        String recentFilesLabel = jEdit.getProperty("options.general.recentFiles");
        int recentFilesValue = jEdit.getIntegerProperty("recentFiles");
        SpinnerNumberModel model = new SpinnerNumberModel(recentFilesValue, 0, Integer.MAX_VALUE, 1);
        this.recentFiles = new JSpinner(model);
        this.addComponent(recentFilesLabel, (Component)this.recentFiles);
        this.sortRecent = new JCheckBox(jEdit.getProperty("options.general.sortRecent"));
        this.sortRecent.setSelected(jEdit.getBooleanProperty("sortRecent"));
        this.addComponent(this.sortRecent);
        this.saveCaret = new JCheckBox(jEdit.getProperty("options.general.saveCaret"));
        this.saveCaret.setSelected(jEdit.getBooleanProperty("saveCaret"));
        this.addComponent(this.saveCaret);
        this.persistentMarkers = new JCheckBox(jEdit.getProperty("options.general.persistentMarkers"));
        this.persistentMarkers.setSelected(jEdit.getBooleanProperty("persistentMarkers"));
        this.addComponent(this.persistentMarkers);
        this.restore = new JCheckBox(jEdit.getProperty("options.general.restore"));
        this.restore.setSelected(jEdit.getBooleanProperty("restore"));
        this.restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralOptionPane.this.restoreCLI.setEnabled(GeneralOptionPane.this.restore.isSelected());
                GeneralOptionPane.this.restoreRemote.setEnabled(GeneralOptionPane.this.restore.isSelected());
            }
        });
        this.addComponent(this.restore);
        this.restoreRemote = new JCheckBox(jEdit.getProperty("options.general.restore.remote"));
        this.restoreRemote.setSelected(jEdit.getBooleanProperty("restore.remote", false));
        this.restoreRemote.setEnabled(this.restore.isSelected());
        this.addComponent(this.restoreRemote);
        this.restoreCLI = new JCheckBox(jEdit.getProperty("options.general.restore.cli"));
        this.restoreCLI.setSelected(jEdit.getBooleanProperty("restore.cli"));
        this.restoreCLI.setEnabled(this.restore.isSelected());
        this.addComponent(this.restoreCLI);
        this.restoreSplits = new JCheckBox(jEdit.getProperty("options.general.restore.splits", "Restore split configuration"));
        this.restoreSplits.setSelected(jEdit.getBooleanProperty("restore.splits", true));
        this.addComponent(this.restoreSplits);
        String maxWarnLabel = jEdit.getProperty("options.general.hypersearch.maxWarningResults");
        int maxWarnValue = jEdit.getIntegerProperty("hypersearch.maxWarningResults");
        model = new SpinnerNumberModel(maxWarnValue, 0, Integer.MAX_VALUE, 1);
        this.hypersearchResultsWarning = new JSpinner(model);
        this.addComponent(maxWarnLabel, (Component)this.hypersearchResultsWarning);
        String language = jEdit.getCurrentLanguage();
        String availableLanguages = jEdit.getProperty("available.lang", "en");
        String[] languages = availableLanguages.split(" ");
        this.useDefaultLocale = new JCheckBox(jEdit.getProperty("options.appearance.usedefaultlocale.label"));
        this.useDefaultLocale.setSelected(jEdit.getBooleanProperty("lang.usedefaultlocale"));
        this.useDefaultLocale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GeneralOptionPane.this.lang.setEnabled(!GeneralOptionPane.this.useDefaultLocale.isSelected());
            }
        });
        this.lang = new JComboBox<String>(languages);
        this.lang.setEnabled(!this.useDefaultLocale.isSelected());
        this.lang.setSelectedItem(language);
        this.lang.setRenderer(new LangCellRenderer());
        this.addSeparator("options.appearance.localization.section.label");
        this.addComponent(this.useDefaultLocale);
        this.addComponent(jEdit.getProperty("options.appearance.lang.label"), (Component)this.lang);
    }

    @Override
    protected void _save() {
        switch (this.checkModStatus.getSelectedIndex()) {
            case 0: {
                jEdit.setBooleanProperty("autoReloadDialog", false);
                jEdit.setBooleanProperty("autoReload", false);
                break;
            }
            case 1: {
                jEdit.setBooleanProperty("autoReloadDialog", true);
                jEdit.setBooleanProperty("autoReload", false);
                break;
            }
            case 2: {
                jEdit.setBooleanProperty("autoReloadDialog", true);
                jEdit.setBooleanProperty("autoReload", true);
                break;
            }
            case 3: {
                jEdit.setBooleanProperty("autoReloadDialog", false);
                jEdit.setBooleanProperty("autoReload", true);
            }
        }
        jEdit.setIntegerProperty("checkFileStatus", this.checkModStatusUpon.getSelectedIndex());
        jEdit.setIntegerProperty("recentFiles", (Integer)this.recentFiles.getModel().getValue());
        jEdit.setBooleanProperty("sortRecent", this.sortRecent.isSelected());
        jEdit.setBooleanProperty("saveCaret", this.saveCaret.isSelected());
        jEdit.setBooleanProperty("persistentMarkers", this.persistentMarkers.isSelected());
        jEdit.setBooleanProperty("restore", this.restore.isSelected());
        jEdit.setBooleanProperty("restore.cli", this.restoreCLI.isSelected());
        jEdit.setBooleanProperty("restore.remote", this.restoreRemote.isSelected());
        jEdit.setBooleanProperty("restore.splits", this.restoreSplits.isSelected());
        int maxWarnResults = (Integer)this.hypersearchResultsWarning.getModel().getValue();
        jEdit.setIntegerProperty("hypersearch.maxWarningResults", maxWarnResults);
        jEdit.setBooleanProperty("lang.usedefaultlocale", this.useDefaultLocale.isSelected());
        jEdit.setProperty("lang.current", String.valueOf(this.lang.getSelectedItem()));
    }

    private static class LangCellRenderer
    extends DefaultListCellRenderer {
        private LangCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String label = jEdit.getProperty("options.appearance.lang." + value);
            if (label != null) {
                this.setText(label);
            }
            return this;
        }
    }
}

