/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.NumericTextField;
import org.gjt.sp.jedit.jEdit;

public class SaveBackupOptionPane
extends AbstractOptionPane {
    private JCheckBox saveAsUsesFSB;
    private JCheckBox twoStageSave;
    private JCheckBox confirmSaveAll;
    private JTextField autosave;
    private JCheckBox autosaveUntitled;
    private JCheckBox suppressNotSavedConfirmUntitled;
    private JCheckBox useMD5forDirtyCalculation;
    private JTextField backups;
    private JTextField backupDirectory;
    private JTextField backupPrefix;
    private JTextField backupSuffix;
    private JCheckBox backupEverySave;

    public SaveBackupOptionPane() {
        super("save-back");
    }

    @Override
    protected void _init() {
        this.saveAsUsesFSB = new JCheckBox(jEdit.getProperty("options.save-back.saveAsUsesFSB"));
        this.saveAsUsesFSB.setSelected(jEdit.getBooleanProperty("saveAsUsesFSB"));
        this.saveAsUsesFSB.setToolTipText(jEdit.getProperty("options.save-back.saveAsUsesFSB.tooltip"));
        this.addComponent(this.saveAsUsesFSB);
        this.twoStageSave = new JCheckBox(jEdit.getProperty("options.save-back.twoStageSave"));
        this.twoStageSave.setSelected(jEdit.getBooleanProperty("twoStageSave"));
        this.twoStageSave.setToolTipText(jEdit.getProperty("options.save-back.twoStageSave.tooltip"));
        this.addComponent(this.twoStageSave);
        this.confirmSaveAll = new JCheckBox(jEdit.getProperty("options.save-back.confirmSaveAll"));
        this.confirmSaveAll.setSelected(jEdit.getBooleanProperty("confirmSaveAll"));
        this.addComponent(this.confirmSaveAll);
        this.autosave = new NumericTextField(jEdit.getProperty("autosave"), true);
        this.addComponent(jEdit.getProperty("options.save-back.autosave"), (Component)this.autosave);
        this.autosaveUntitled = new JCheckBox(jEdit.getProperty("options.save-back.autosaveUntitled"));
        this.autosaveUntitled.setSelected(jEdit.getBooleanProperty("autosaveUntitled"));
        this.addComponent(this.autosaveUntitled);
        this.suppressNotSavedConfirmUntitled = new JCheckBox(jEdit.getProperty("options.save-back.suppressNotSavedConfirmUntitled"));
        this.suppressNotSavedConfirmUntitled.setToolTipText(jEdit.getProperty("options.save-back.suppressNotSavedConfirmUntitled.tooltip"));
        this.suppressNotSavedConfirmUntitled.setSelected(jEdit.getBooleanProperty("suppressNotSavedConfirmUntitled"));
        this.addComponent(this.suppressNotSavedConfirmUntitled);
        this.useMD5forDirtyCalculation = new JCheckBox(jEdit.getProperty("options.save-back.useMD5forDirtyCalculation"));
        this.useMD5forDirtyCalculation.setToolTipText(jEdit.getProperty("options.save-back.useMD5forDirtyCalculation.tooltip"));
        this.useMD5forDirtyCalculation.setSelected(jEdit.getBooleanProperty("useMD5forDirtyCalculation"));
        this.addComponent(this.useMD5forDirtyCalculation);
        this.backups = new NumericTextField(jEdit.getProperty("backups"), true);
        this.addComponent(jEdit.getProperty("options.save-back.backups"), (Component)this.backups);
        this.backupDirectory = new JTextField(jEdit.getProperty("backup.directory"));
        JButton browseBackupDirectory = new JButton("...");
        browseBackupDirectory.addActionListener(new MyActionListener());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.backupDirectory);
        panel.add((Component)browseBackupDirectory, "East");
        this.addComponent(jEdit.getProperty("options.save-back.backupDirectory"), (Component)panel);
        this.backupPrefix = new JTextField(jEdit.getProperty("backup.prefix"));
        this.addComponent(jEdit.getProperty("options.save-back.backupPrefix"), (Component)this.backupPrefix);
        this.backupSuffix = new JTextField(jEdit.getProperty("backup.suffix"));
        this.addComponent(jEdit.getProperty("options.save-back.backupSuffix"), (Component)this.backupSuffix);
        this.backupEverySave = new JCheckBox(jEdit.getProperty("options.save-back.backupEverySave"));
        this.backupEverySave.setSelected(jEdit.getBooleanProperty("backupEverySave"));
        this.addComponent(this.backupEverySave);
    }

    @Override
    protected void _save() {
        jEdit.setBooleanProperty("saveAsUsesFSB", this.saveAsUsesFSB.isSelected());
        jEdit.setBooleanProperty("twoStageSave", this.twoStageSave.isSelected());
        jEdit.setBooleanProperty("confirmSaveAll", this.confirmSaveAll.isSelected());
        jEdit.setProperty("autosave", this.autosave.getText());
        jEdit.setProperty("backups", this.backups.getText());
        jEdit.setProperty("backup.directory", this.backupDirectory.getText());
        jEdit.setProperty("backup.prefix", this.backupPrefix.getText());
        jEdit.setProperty("backup.suffix", this.backupSuffix.getText());
        jEdit.setBooleanProperty("backupEverySave", this.backupEverySave.isSelected());
        boolean newAutosave = this.autosaveUntitled.isSelected();
        boolean oldAutosave = jEdit.getBooleanProperty("autosaveUntitled");
        jEdit.setBooleanProperty("autosaveUntitled", newAutosave);
        jEdit.setBooleanProperty("suppressNotSavedConfirmUntitled", this.suppressNotSavedConfirmUntitled.isSelected());
        jEdit.setBooleanProperty("useMD5forDirtyCalculation", this.useMD5forDirtyCalculation.isSelected());
        if ((!newAutosave || jEdit.getIntegerProperty("autosave", 0) == 0) && oldAutosave) {
            Buffer[] buffers;
            for (Buffer buffer : buffers = jEdit.getBuffers()) {
                if (!buffer.isUntitled()) continue;
                buffer.removeAutosaveFile();
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] choosenFolder = GUIUtilities.showVFSFileDialog(null, SaveBackupOptionPane.this.backupDirectory.getText(), 3, false);
            if (choosenFolder != null) {
                SaveBackupOptionPane.this.backupDirectory.setText(choosenFolder[0]);
            }
        }
    }
}

