/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.font.TextLayout;
import java.util.Vector;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.textarea.ColumnBlock;
import org.gjt.sp.jedit.textarea.ColumnBlockLine;
import org.gjt.sp.jedit.textarea.TextArea;

public class ElasticTabstopsTabExpander
implements TabExpander {
    TextArea textArea;

    public ElasticTabstopsTabExpander(TextArea textArea) {
        this.textArea = textArea;
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        float _tabSize = 0.0f;
        if (this.textArea.buffer.getBooleanProperty("elasticTabstops") && this.textArea.buffer.getColumnBlock() != null) {
            int line = this.textArea.buffer.getLineOfOffset(tabOffset);
            _tabSize = this.getTabSize(this.textArea.buffer.getColumnBlock().getColumnBlock(line, tabOffset), line);
            if (_tabSize < 0.0f) {
                throw new IllegalArgumentException("Unaccounted tab at line " + this.textArea.buffer.getLineOfOffset(tabOffset) + " at index " + tabOffset);
            }
        }
        return x + (_tabSize += this.textArea.tabSize);
    }

    private float getTabSize(ColumnBlock columnBlock, int line) {
        float ret = -5.0f;
        if (columnBlock != null) {
            Vector<ColumnBlockLine> lines = columnBlock.getLines();
            if (columnBlock.areTabSizesDirty()) {
                float colBlockWidth = -1.0f;
                for (int i = 0; i < lines.size(); ++i) {
                    ColumnBlockLine colBlockLine = lines.elementAt(i);
                    int startOffset = colBlockLine.getColumnStartIndex() + this.textArea.buffer.getLineStartOffset(colBlockLine.getLine());
                    String str = this.textArea.buffer.getText(startOffset, colBlockLine.getColumnEndIndex() - colBlockLine.getColumnStartIndex());
                    float width = 0.0f;
                    if (str.length() != 0) {
                        TextLayout layout = new TextLayout(str, this.textArea.painter.getFont(), this.textArea.painter.getFontRenderContext());
                        width = layout.getAdvance();
                    }
                    colBlockLine.lineLength = width;
                    if (!(colBlockWidth < 0.0f) && !(colBlockLine.lineLength > colBlockWidth)) continue;
                    colBlockWidth = colBlockLine.lineLength;
                }
                columnBlock.columnBlockWidth = colBlockWidth;
                columnBlock.setTabSizeDirtyStatus(false, false);
            }
            ret = columnBlock.columnBlockWidth - lines.get((int)(line - columnBlock.startLine)).lineLength;
        }
        return ret;
    }
}

