/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.JNPadTabbedViewer;
import jnpad.config.Config;
import jnpad.text.Buffer;
import jnpad.text.BufferSet;
import jnpad.text.Viewer;
import jnpad.ui.icon.CompositeIcon;
import jnpad.ui.plaf.JNPadTabbedPaneUI;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.tab.AbstractTabbedPane;
import jnpad.ui.tab.CloseButtonTabComponent;

public class JNPadTabbedPane
extends AbstractTabbedPane
implements BufferSet {
    private JNPadTabbedViewer viewer;
    private JNPadFrame jNPad;
    private static final long serialVersionUID = 1451948349230027573L;

    public JNPadTabbedPane(JNPadTabbedViewer viewer) {
        this.viewer = viewer;
        this.jNPad = viewer.getJNPad();
        if (LAFUtils.isJNPadLAF() && Config.TAB_ROUNDED.getValue().booleanValue()) {
            this.setUI(new JNPadTabbedPaneUI());
        }
        this.setFocusable(false);
        this.setAutoRequestFocus(false);
        this.setAutoFocusOnTabHideClose(false);
        this.setTabLayoutPolicy(Config.TAB_LAYOUT_POLICY.getValue());
        this.setTabPlacement(Config.TAB_PLACEMENT.getValue());
    }

    @Override
    public Viewer getViewer() {
        return this.viewer;
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        try {
            int i;
            if (this.getTabCount() > 0 && this.getTabLayoutPolicy() == 0 && this.isCloseEnabled(e) && (i = this.getUI().tabForCoordinate(this, e.getX(), e.getY())) > -1 && i < this.getTabCount()) {
                this.doClose(i);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void handleMouseClicked(MouseEvent e) {
        int i = this.getSelectedIndex();
        if (i > -1 && this.getTabCount() > i) {
            Rectangle bounds = this.getUI().getTabBounds(this, i);
            if (bounds.contains(e.getPoint())) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    this.expand();
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    this.showPopupMenu(e);
                }
            } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                this.jNPad.newFile();
            }
        } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            this.jNPad.newFile();
        }
    }

    @Override
    protected void close(int i) {
        if (i > -1 && i < this.getTabCount()) {
            this.doClose(i);
        }
    }

    private void doClose(int i) {
        String path = ((Buffer)this.getComponentAt(i)).getFilePath();
        this.jNPad.closeFile(path, true);
    }

    @Override
    protected void expand() {
    }

    @Override
    protected void showPopupMenu(MouseEvent e) {
        JPopupMenu popupMenu = this.jNPad.createTabbedPopupMenu();
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String str = super.getToolTipText(e);
        if (this.getTabLayoutPolicy() == 0) {
            if (str != null && this.isReadOnlyCloseIcon(e.getPoint())) {
                str = JNPadBundle.getString("JNPadTabbedPane.close2", str);
            } else if (str != null && this.isCloseIcon(e.getPoint())) {
                str = JNPadBundle.getString("JNPadTabbedPane.close1", str);
            }
        }
        return str;
    }

    private boolean isCloseEnabled(MouseEvent e) {
        return e.getID() == 501 && !SwingUtilities.isRightMouseButton(e) && this.isCloseIcon(e.getPoint()) && !e.isShiftDown() && !e.isAltDown() && !e.isControlDown();
    }

    private CompositeIcon getCompositeIcon(Point p) {
        Icon icon;
        int i;
        if (this.getUI() != null && (i = this.getUI().tabForCoordinate(this, p.x, p.y)) > -1 && this.getTabCount() > i && (icon = this.getIconAt(i)) instanceof CompositeIcon) {
            return (CompositeIcon)icon;
        }
        return null;
    }

    private Icon getIcon(Point p) {
        CompositeIcon compositeIcon = this.getCompositeIcon(p);
        if (compositeIcon != null) {
            return compositeIcon.findHit(p);
        }
        return null;
    }

    private boolean isReadOnlyCloseIcon(Point p) {
        Icon icon = this.getIcon(p);
        return icon == JNPadTabbedViewer.iiTabReadOnlyClose;
    }

    private boolean isCloseIcon(Point p) {
        Icon icon = this.getIcon(p);
        return icon == JNPadTabbedViewer.iiTabGenericClose || icon == JNPadTabbedViewer.iiTabModifiedClose || icon == JNPadTabbedViewer.iiTabModifiedReadOnlyClose || icon == JNPadTabbedViewer.iiTabReadOnlyClose;
    }

    @Override
    public Buffer getSelectedBuffer() {
        return (Buffer)this.getSelectedComponent();
    }

    @Override
    public Buffer getBufferAt(int index) {
        return (Buffer)this.getComponentAt(index);
    }

    @Override
    public int getBufferCount() {
        return this.getTabCount();
    }

    @Override
    public void setActiveLineVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setActiveLineVisible(b);
            ++i;
        }
    }

    @Override
    public void setLineNumbersVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setLineNumbersVisible(b);
            ++i;
        }
    }

    @Override
    public void setLineWrap(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setLineWrap(b);
            ++i;
        }
    }

    @Override
    public void setRightMarginLineVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setRightMarginLineVisible(b);
            ++i;
        }
    }

    @Override
    public void setMarkStripVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setMarkStripVisible(b);
            ++i;
        }
    }

    @Override
    public void setOccurrencesHighlighterVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setOccurrencesHighlighterVisible(b);
            ++i;
        }
    }

    @Override
    public void setBracketHighlighterVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setBracketHighlighterVisible(b);
            ++i;
        }
    }

    @Override
    public void insertTab(String title, Icon icon, Component c, String tip, int index) {
        super.insertTab(title, icon, c, tip, index);
        if (Config.TAB_CLOSE_BUTTON.getValue().booleanValue() && this.getTabLayoutPolicy() == 1) {
            this.setTabComponentAt(index, new CloseButtonTabComponent(this));
        }
    }

    @Override
    public Iterator<Buffer> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<Buffer> {
        int pos = 0;
        int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < JNPadTabbedPane.this.getTabCount();
        }

        @Override
        public Buffer next() {
            try {
                Buffer next = JNPadTabbedPane.this.getBufferAt(this.pos);
                this.lastRet = this.pos++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                JNPadTabbedPane.this.removeTabAt(this.lastRet);
                if (this.lastRet < this.pos) {
                    --this.pos;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

