/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;
import jnpad.util.Utilities;

public final class InsertFileExtensionAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(InsertFileExtensionAction.class.getName());
    private static final long serialVersionUID = 511263975561465855L;

    public InsertFileExtensionAction(JNPadFrame jNPad) {
        super(jNPad, "insert-file-extension", JNPadActions.Group.EDIT, Accelerators.INSERT_FILE_EXTENSION, null);
    }

    @Override
    public void performAction() {
        EditPane editPane = this.jNPad.getActiveEditPane();
        if (editPane != null) {
            File file = new File(editPane.getFilePath());
            if (!file.exists()) {
                return;
            }
            try {
                String extension = Utilities.getFileExtension(file.getName());
                if (Utilities.isEmptyString(extension)) {
                    return;
                }
                extension = ".".concat(extension);
                JNPadTextArea target = editPane.getTextArea();
                Document doc = target.getDocument();
                int caretPosition = target.getCaretPosition();
                doc.insertString(caretPosition, extension, null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

