/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Config;
import jnpad.ui.MnemonicHelper;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.Utilities;

public final class SelectColorSchemeAction
extends JNPadAction {
    private File file;
    static final String NAME = "select-colorscheme";
    private static Map<String, JNPadAction> map = new HashMap<String, JNPadAction>();
    private static final Logger LOGGER = Logger.getLogger(SelectColorSchemeAction.class.getName());
    private static final long serialVersionUID = 8898007470567691942L;

    public SelectColorSchemeAction(JNPadFrame jNPad, File file, boolean selected, MnemonicHelper mnemonicHelper) {
        super(jNPad, NAME, JNPadActions.Group.CONFIGURE);
        char mnemonic;
        this.file = file;
        String label = Utilities.getFileBaseName(file.getPath());
        String name = "select-colorscheme " + label;
        this.setLabel(label);
        this.setName(name);
        if (mnemonicHelper != null && (mnemonic = mnemonicHelper.getMnemonic(label)) != '\u0000') {
            this.setMnemonic(mnemonic);
        }
        this.setDescription(ActionBundle.getString(NAME.concat(".description"), label));
        this.setSelected(selected);
        this.setStateAction(true);
        map.put(name, this);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            String colorscheme = this.getLabel();
            Properties prop = new Properties();
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
                    prop.load(in);
                }
                catch (IOException ex) {
                    String msg = ActionBundle.getString(NAME.concat(".error"), colorscheme);
                    LOGGER.log(Level.WARNING, msg, ex);
                    this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, msg);
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex2) {
                        LOGGER.log(Level.WARNING, ex2.getMessage(), ex2);
                    }
                    return;
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            Config.putAll(prop);
            this.jNPad.configure(3);
            this.jNPad.setStatus(ActionBundle.getString(NAME.concat(".message"), colorscheme, Config.JNPAD_COLORSCHEME.getValue()), 10);
            Config.JNPAD_COLORSCHEME.setValue(colorscheme);
        }
    }

    static List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            JNPadAction action = map.get(key);
            if (!key.startsWith(prefix) || !action.isEnabled()) continue;
            list.add(key);
        }
        Collections.sort(list);
        return list;
    }

    static boolean performAction(String name) {
        JNPadAction action = map.get(name);
        if (action != null && action.isEnabled()) {
            action.setSelected(!action.isSelected());
            return true;
        }
        return false;
    }
}

