/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.Buffer;
import jnpad.text.EditPane;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;
import jnpad.ui.status.StatusDisplayable;

public final class ToUpperCaseAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(ToUpperCaseAction.class.getName());
    private static final long serialVersionUID = 4468324781993194158L;

    public ToUpperCaseAction(JNPadFrame jNPad) {
        super(jNPad, "to-upper-case", JNPadActions.Group.FORMAT, Accelerators.TO_UPPER, "to-upper-case.png");
    }

    @Override
    public void performAction() {
        Buffer buffer = this.jNPad.getActiveBuffer();
        if (buffer != null) {
            try {
                try {
                    EditPane editPane;
                    Action action;
                    buffer.beginCompoundEdit();
                    JNPadTextArea textArea = buffer.getSelectedTextArea();
                    int pos = textArea.getCaretPosition();
                    if (!textArea.hasSelection() && (action = (editPane = buffer.getSelectedEditPane()).getActions().get("select-word")) != null) {
                        action.actionPerformed(new ActionEvent(editPane.getTextArea(), 1001, (String)action.getValue("Name"), EventQueue.getMostRecentEventTime(), ToUpperCaseAction.getCurrentEventModifiers()));
                    }
                    textArea.toUpperCase();
                    textArea.setCaretPosition(pos);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getLabel()));
                    buffer.endCompoundEdit();
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }
}

