/*
 * Decompiled with CFR 0.152.
 */
package jnpad.config;

import java.awt.Color;
import java.util.StringTokenizer;
import jnpad.config.Config;
import jnpad.config.IntProp;
import jnpad.config.Prop;

public class ColorProp
extends Prop<Color> {
    private static final long serialVersionUID = -6182268127019767746L;

    public ColorProp(String name, Color def) {
        super(name, def);
    }

    @Override
    public String getDefaultString() {
        return ColorProp.format((Color)this.defaultValue);
    }

    public static Color parse(String value) throws IllegalArgumentException {
        int a;
        int b;
        int g;
        int r;
        if ((value = value.trim()).charAt(0) == '#') {
            try {
                return Color.decode(value);
            }
            catch (NumberFormatException nf) {
                throw new IllegalArgumentException("Color inv\u00e1lido: " + value);
            }
        }
        if ("red".equals(value)) {
            return Color.RED;
        }
        if ("green".equals(value)) {
            return Color.GREEN;
        }
        if ("blue".equals(value)) {
            return Color.BLUE;
        }
        if ("yellow".equals(value)) {
            return Color.YELLOW;
        }
        if ("orange".equals(value)) {
            return Color.ORANGE;
        }
        if ("white".equals(value)) {
            return Color.WHITE;
        }
        if ("lightGray".equals(value)) {
            return Color.LIGHT_GRAY;
        }
        if ("gray".equals(value)) {
            return Color.GRAY;
        }
        if ("darkGray".equals(value)) {
            return Color.DARK_GRAY;
        }
        if ("black".equals(value)) {
            return Color.BLACK;
        }
        if ("cyan".equals(value)) {
            return Color.CYAN;
        }
        if ("magenta".equals(value)) {
            return Color.MAGENTA;
        }
        if ("pink".equals(value)) {
            return Color.PINK;
        }
        try {
            StringTokenizer st = new StringTokenizer(value, ",");
            r = IntProp.parse(st.nextToken().trim());
            g = IntProp.parse(st.nextToken().trim());
            b = IntProp.parse(st.nextToken().trim());
            a = st.hasMoreTokens() ? IntProp.parse(st.nextToken().trim()) : 255;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Color inv\u00e1lido: " + value);
        }
        return new Color(r, g, b, a);
    }

    public static String format(Color value) {
        StringBuilder sb = new StringBuilder();
        sb.append(value.getRed()).append(",").append(value.getGreen()).append(",").append(value.getBlue()).append(",").append(value.getAlpha());
        return sb.toString();
    }

    @Override
    public Color getValue() {
        return Config.getColorProp(this);
    }

    @Override
    protected void doSetValue(Color value) {
        Config.setColorProp(this, value);
    }
}

