/*
 * Decompiled with CFR 0.152.
 */
package jnpad.config;

import jnpad.config.Config;
import jnpad.config.Prop;

public class FloatProp
extends Prop<Float> {
    private static final long serialVersionUID = -2845155650100465556L;

    public FloatProp(String name, float def) {
        super(name, Float.valueOf(def));
    }

    @Override
    public String getDefaultString() {
        return FloatProp.format(((Float)this.defaultValue).floatValue());
    }

    public static float parse(String value) throws NumberFormatException {
        return Float.parseFloat(value);
    }

    public static String format(float value) {
        return Float.toString(value);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(Config.getFloatProp(this));
    }

    @Override
    protected void doSetValue(Float value) {
        Config.setFloatProp(this, value.floatValue());
    }
}

