/*
 * Decompiled with CFR 0.152.
 */
package jnpad.filebrowser;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import jnpad.filebrowser.FileBrowserObject;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Utilities;

public class FileListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final long serialVersionUID = -7716429178046246911L;

    public FileListCellRenderer() {
        this.setOpaque(true);
        this.setBorder(DEFAULT_NO_FOCUS_BORDER);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (value instanceof FileBrowserObject) {
            this.setText(((FileBrowserObject)value).getLine());
            this.setFont(((FileBrowserObject)value).getFont());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(((FileBrowserObject)value).getForeground());
            }
        } else {
            this.setText(Utilities.toString(value));
            this.setFont(FileBrowserObject.font_bold);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(FileBrowserObject.fg_dir);
            }
        }
        this.setEnabled(list.isEnabled());
        this.setBorder(cellHasFocus && !LAFUtils.isFullRowSelectionLAF() ? LAFUtils.getListFocusCellHighlightBorder() : DEFAULT_NO_FOCUS_BORDER);
        return this;
    }
}

