/*
 * Decompiled with CFR 0.152.
 */
package jnpad.search;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import jnpad.GUIUtilities;
import jnpad.config.Config;
import jnpad.search.Text;
import jnpad.ui.JNPadTreeCellRenderer;
import jnpad.ui.plaf.LAFUtils;

public class FindResultsTreeCellRenderer
extends JLabel
implements JNPadTreeCellRenderer {
    private Color selectionForeground;
    private Color textForeground;
    private Color selectionBackground;
    private Color textBackground;
    private static ImageIcon iiRoot;
    private static ImageIcon iiElem;
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    private static final long serialVersionUID = 1322228929869523533L;

    static {
        try {
            iiRoot = GUIUtilities.getIcon("find.png");
            iiElem = GUIUtilities.getIcon("find-elem.png");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    }

    public FindResultsTreeCellRenderer() {
        this.configure(1);
        this.setOpaque(true);
        this.setBorder(DEFAULT_NO_FOCUS_BORDER);
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.selectionForeground = Config.TEXT_SELECTION_FOREGROUND.getValue();
            this.textForeground = Config.TEXT_FOREGROUND.getValue();
            this.textBackground = Config.TEXT_BACKGROUND.getValue();
            this.selectionBackground = Config.TEXT_SELECTION_BACKGROUND.getValue();
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        this.setComponentOrientation(tree.getComponentOrientation());
        this.setForeground(isSelected ? this.selectionForeground : this.textForeground);
        if (LAFUtils.isNimbusLAF()) {
            if (isSelected) {
                this.setOpaque(true);
                this.setBackground(this.selectionBackground);
            } else {
                this.setOpaque(false);
            }
        } else {
            this.setOpaque(true);
            this.setBackground(isSelected ? this.selectionBackground : this.textBackground);
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object obj = node.getUserObject();
        this.setIcon(obj instanceof Text ? iiElem : iiRoot);
        this.setText(value.toString());
        this.setEnabled(tree.isEnabled());
        this.setFont(tree.getFont());
        this.setBorder(hasFocus && !LAFUtils.isFullRowSelectionLAF() ? LAFUtils.getListFocusCellHighlightBorder() : DEFAULT_NO_FOCUS_BORDER);
        return this;
    }
}

