/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.highlighter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jnpad.config.Config;
import jnpad.text.highlighter.IHighlightPainter;

public class OccurrenceHighlightPainter
implements IHighlightPainter {
    private Color _color;
    private Color _borderColor;

    public OccurrenceHighlightPainter() {
        this.configure(1);
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.setColor(Config.OCCURRENCES_HIGHLIGHTER_COLOR.getValue());
            this.setBorderColor(Config.OCCURRENCES_HIGHLIGHTER_BORDER_COLOR.getValue());
        }
    }

    public void setColor(Color color) {
        if (color != null) {
            this._color = color;
        }
    }

    public Color getColor() {
        return this._color;
    }

    public Color getBorderColor() {
        return this._borderColor;
    }

    public void setBorderColor(Color color) {
        if (color != null) {
            this._borderColor = color;
        }
    }

    @Override
    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        Rectangle alloc = bounds.getBounds();
        try {
            TextUI mapper = c.getUI();
            Rectangle r0 = mapper.modelToView(c, offs0);
            Rectangle r1 = mapper.modelToView(c, offs1);
            g.setColor(this.getColor());
            if (r0.y == r1.y) {
                Graphics2D g2D = (Graphics2D)g;
                Object oldRendering = g2D.getRenderingHint(RenderingHints.KEY_RENDERING);
                Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle r = r0.union(r1);
                g.fillRoundRect(r.x, r.y, r.width, r.height, 4, 4);
                g.setColor(this.getBorderColor());
                g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, 4, 4);
                g2D.setRenderingHint(RenderingHints.KEY_RENDERING, oldRendering);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
            } else {
                int p0ToMarginWidth = alloc.x + alloc.width - r0.x;
                g.fillRect(r0.x, r0.y, p0ToMarginWidth, r0.height);
                if (r0.y + r0.height != r1.y) {
                    g.fillRect(alloc.x, r0.y + r0.height, alloc.width, r1.y - (r0.y + r0.height));
                }
                g.fillRect(alloc.x, r1.y, r1.x - alloc.x, r1.height);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

