/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;
import jnpad.config.Config;
import jnpad.text.Scheme;

public class PlainScheme
extends Scheme {
    Font textFont;
    Color textColor;
    Color selectedTextColor;
    private static final long serialVersionUID = 6403432643578009476L;

    public PlainScheme(boolean mini) {
        super(mini);
        this.doUpdateColors();
        this.doUpdateFonts();
    }

    private void doUpdateColors() {
        this.textColor = Config.TEXT_FOREGROUND.getValue();
        this.selectedTextColor = Config.TEXT_SELECTION_FOREGROUND.getValue();
    }

    private void doUpdateFonts() {
        this.textFont = !this.mini ? Config.TEXT_FONT.getValue() : Config.TEXT_FONT.getValue().deriveFont(Config.MINIMAP_FONT_SIZE.getValue().floatValue());
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.doUpdateColors();
        }
        if ((cfg & 2) != 0) {
            this.doUpdateFonts();
        }
    }

    @Override
    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    @Override
    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(Color c) {
        this.textColor = c;
    }

    @Override
    public Font getTextFont() {
        return this.textFont;
    }

    @Override
    public void setTextFont(Font f) {
        this.textFont = f;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public String[] getStartComment() {
        return null;
    }

    @Override
    public String[] getEndComment() {
        return null;
    }

    @Override
    public String[] getStartMultilineComment() {
        return null;
    }

    @Override
    public String[] getEndMultilineComment() {
        return null;
    }
}

