/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import jnpad.ui.plaf.LAFUtils;

public class EdgeBorder
implements Border {
    private Insets _insets = new Insets(2, 2, 2, 2);
    public static final int EDGE_TOP = 1;
    public static final int EDGE_LEFT = 2;
    public static final int EDGE_BOTTOM = 4;
    public static final int EDGE_RIGHT = 8;
    public static final int EDGE_ALL = 15;
    private int _edge = 15;

    public EdgeBorder() {
    }

    public EdgeBorder(int edge) {
        this._edge = edge;
        this.recalcInsets();
    }

    protected void recalcInsets() {
        this._insets.top = (this._edge & 1) != 0 ? 2 : 0;
        this._insets.left = (this._edge & 2) != 0 ? 2 : 0;
        this._insets.bottom = (this._edge & 4) != 0 ? 2 : 0;
        this._insets.right = (this._edge & 8) != 0 ? 2 : 0;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this._insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color shadow = LAFUtils.getSeparatorShadow();
        Color highlight = LAFUtils.getSeparatorHighlight();
        Color color = g.getColor();
        if ((this._edge & 1) != 0) {
            g.setColor(shadow);
            g.drawLine(x, y, x + width - 1, y);
            g.setColor(highlight);
            g.drawLine(x, y + 1, x + width - 1, y + 1);
        }
        if ((this._edge & 2) != 0) {
            g.setColor(shadow);
            g.drawLine(x, y, x, y + height - 1);
            g.setColor(highlight);
            g.drawLine(x + 1, y, x + 1, y + height - 1);
        }
        if ((this._edge & 4) != 0) {
            g.setColor(shadow);
            g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
            g.setColor(highlight);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        }
        if ((this._edge & 8) != 0) {
            g.setColor(shadow);
            g.drawLine(x + width - 2, y, x + width - 2, y + height - 1);
            g.setColor(highlight);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        }
        g.setColor(color);
    }
}

