/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.Serializable;
import jnpad.JNPadBundle;
import jnpad.ui.FontChooserDialog;

public class FontChooser
implements Serializable {
    private Window window;
    private String title;
    private boolean modal;
    private Font selectedFont;
    private boolean okPressed;
    private static final long serialVersionUID = -753829544574261203L;

    public FontChooser(Frame frame, String title) {
        this(frame, title, true);
    }

    public FontChooser(Frame frame, String title, boolean modal) {
        this.modal = modal;
        this.okPressed = false;
        this.window = frame;
        this.setTitle(title);
    }

    public FontChooser(Dialog dialog, String title) {
        this(dialog, title, true);
    }

    public FontChooser(Dialog dialog, String title, boolean modal) {
        this.modal = modal;
        this.okPressed = false;
        this.window = dialog;
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setSelectedFont(Font selectedFont) {
        this.selectedFont = selectedFont;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void show() {
        this.showDialog();
    }

    public boolean showDialog() {
        FontChooserDialog dlg = new FontChooserDialog(this.window, this.title != null ? this.title : JNPadBundle.getString("FontChooserDialog.title", new Object[0]), this.modal, this.selectedFont);
        dlg.pack();
        dlg.setLocationRelativeTo(this.window);
        dlg.setVisible(true);
        if (dlg.isOKPressed()) {
            this.selectedFont = dlg.getSelectedFont();
            this.okPressed = true;
        }
        dlg.dispose();
        return this.okPressed;
    }
}

