/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.ui.EscapableDialog;
import jnpad.ui.JNPadLabel;
import jnpad.ui.layout.VerticalFlowLayout;

public class FontChooserDialog
extends EscapableDialog {
    JPanel contentPane;
    JPanel pnLists = new JPanel();
    JPanel pnPreview = new JPanel();
    JPanel pnButtons = new JPanel();
    JTextField tfFonts = new JTextField();
    JTextField tfSizes = new JTextField();
    JTextField tfStyles = new JTextField();
    JButton btOk = GUIUtilities.createOkButton();
    JButton btCancel = GUIUtilities.createCancelButton();
    JLabel lbExample = new JNPadLabel();
    JList lsFonts;
    JList lsSizes;
    JList lsStyles;
    private boolean okPressed;
    private Font _font;
    private static final Logger LOGGER = Logger.getLogger(FontChooserDialog.class.getName());
    private static final long serialVersionUID = 2179003477367992324L;

    public FontChooserDialog(Window window, String title, boolean modal, Font font) throws HeadlessException {
        super(window, title);
        this.setDefaultCloseOperation(2);
        this._font = font;
        try {
            try {
                window.setCursor(Cursor.getPredefinedCursor(3));
                this.jbInit();
                this.setModal(modal);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                window.setCursor(Cursor.getDefaultCursor());
            }
        }
        finally {
            window.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)super.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.lsFonts = new JList<String>(GUIUtilities.getAvailableFontFamilyNames());
        JPanel panel_1 = this.createTextFieldAndListPanel(JNPadBundle.getString("FontChooserDialog.font", new Object[0]), this.tfFonts, this.lsFonts);
        this.tfFonts.setColumns(15);
        this.tfFonts.setText(this._font.getName());
        this.tfFonts.setEnabled(false);
        this.lsFonts.setCellRenderer(new FontNameCellRenderer());
        this.lsSizes = new JList<String>(GUIUtilities.getStandardFontSizes());
        JPanel panel_2 = this.createTextFieldAndListPanel(JNPadBundle.getString("FontChooserDialog.size", new Object[0]), this.tfSizes, this.lsSizes);
        this.lsSizes.setSelectedValue(String.valueOf(this._font.getSize()), true);
        this.tfSizes.setColumns(15);
        this.tfSizes.setText(String.valueOf(this._font.getSize()));
        this.lsStyles = new JList<String>(GUIUtilities.getFontStyles());
        JPanel panel_3 = this.createTextFieldAndListPanel(JNPadBundle.getString("FontChooserDialog.style", new Object[0]), this.tfStyles, this.lsStyles);
        this.lsStyles.setSelectedIndex(this._font.getStyle());
        this.tfStyles.setColumns(15);
        this.tfStyles.setText((String)this.lsStyles.getSelectedValue());
        this.tfStyles.setEnabled(false);
        this.lsStyles.setCellRenderer(new FontStylesCellRenderer());
        Font font = this.lsStyles.getFont();
        font = font.deriveFont(0);
        this.lsFonts.setFont(font);
        this.lsSizes.setFont(font);
        this.lsStyles.setFont(font);
        ListSelectionHandler listSelectionHandler = new ListSelectionHandler();
        this.lsFonts.addListSelectionListener(listSelectionHandler);
        this.lsSizes.addListSelectionListener(listSelectionHandler);
        this.lsStyles.addListSelectionListener(listSelectionHandler);
        this.pnLists.setLayout(new GridLayout(0, 3, 6, 6));
        this.pnLists.add(panel_1);
        this.pnLists.add(panel_2);
        this.pnLists.add(panel_3);
        this.lbExample.setText("aAbBcCdDeE 12345 +-*\\ =<> :,. \"?' ()[]{}");
        this.pnPreview.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(JNPadBundle.getString("FontChooserDialog.preview", new Object[0])), GUIUtilities.createEmptyBorder(2)));
        this.pnPreview.add(this.lbExample);
        this.btOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooserDialog.this.okPressed = true;
                FontChooserDialog.this.dispose();
            }
        });
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooserDialog.this.dispose();
            }
        });
        this.pnButtons.setLayout(new FlowLayout(2));
        this.pnButtons.add(this.btOk);
        this.pnButtons.add(this.btCancel);
        this.preview();
        this.pnLists.setBorder(GUIUtilities.createEmptyBorder(5, 0));
        this.contentPane.add((Component)this.pnLists, "North");
        this.contentPane.add((Component)this.pnPreview, "Center");
        this.contentPane.add((Component)this.pnButtons, "South");
        Dimension prefSize = this.lbExample.getPreferredSize();
        prefSize.height = 50;
        this.lbExample.setPreferredSize(prefSize);
        this.getRootPane().setDefaultButton(this.btOk);
        this.lsFonts.setSelectedValue(this._font.getName(), true);
        this.setResizable(false);
    }

    @Override
    protected void escapePressed() {
        this.dispose();
    }

    private void preview() {
        this.lbExample.setFont(this.buildFont());
    }

    private JPanel createTextFieldAndListPanel(String label, JTextField textField, JList list) {
        JPanel p = new JPanel(new VerticalFlowLayout(0, 0, 5, true, false));
        p.add(new JNPadLabel(label));
        p.add(textField);
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add((Component)p, "North");
        panel.add((Component)new JScrollPane(list), "Center");
        return panel;
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }

    public Font getSelectedFont() {
        return !this.okPressed ? null : this.buildFont();
    }

    private Font buildFont() {
        int fontSize;
        try {
            fontSize = Integer.parseInt(this.tfSizes.getText());
        }
        catch (Exception e) {
            fontSize = 12;
        }
        return new Font(this.tfFonts.getText(), this.lsStyles.getSelectedIndex(), fontSize);
    }

    private static class FontNameCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 5496187409487166560L;

        private FontNameCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font font1;
            String str;
            Font font2;
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String && (font2 = new Font(str = (String)value, (font1 = list.getFont()).getStyle(), font1.getSize())).canDisplayUpTo(str) == -1) {
                comp.setFont(font2);
            }
            return comp;
        }
    }

    private static class FontStylesCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4979127865961986980L;

        private FontStylesCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String && index >= 0 && index <= 3) {
                String str = (String)value;
                Font font1 = list.getFont();
                Font font2 = new Font(font1.getName(), index, font1.getSize());
                if (font2.canDisplayUpTo(str) == -1) {
                    comp.setFont(font2);
                }
            }
            return comp;
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String style;
            Object obj = e.getSource();
            if (obj == FontChooserDialog.this.lsFonts) {
                String family = (String)FontChooserDialog.this.lsFonts.getSelectedValue();
                if (family != null) {
                    FontChooserDialog.this.tfFonts.setText(family);
                }
            } else if (obj == FontChooserDialog.this.lsSizes) {
                String size = (String)FontChooserDialog.this.lsSizes.getSelectedValue();
                if (size != null) {
                    FontChooserDialog.this.tfSizes.setText(size);
                }
            } else if (obj == FontChooserDialog.this.lsStyles && (style = (String)FontChooserDialog.this.lsStyles.getSelectedValue()) != null) {
                FontChooserDialog.this.tfStyles.setText(style);
            }
            FontChooserDialog.this.preview();
        }
    }
}

