/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import jnpad.GUIUtilities;
import jnpad.action.JNPadAction;
import jnpad.ui.JNPadMenuItem;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.Platform;

public class JNPadCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private String _description;
    private boolean _descriptionSet;
    private StatusDisplayable _displayable;
    private String _keyBinding;
    private static final long serialVersionUID = 3741136444194429275L;

    public JNPadCheckBoxMenuItem() {
    }

    public JNPadCheckBoxMenuItem(String text) {
        super(text);
    }

    public JNPadCheckBoxMenuItem(String text, boolean b) {
        super(text, b);
    }

    public JNPadCheckBoxMenuItem(Icon icon) {
        super(icon);
    }

    public JNPadCheckBoxMenuItem(String text, Icon icon) {
        super(text, icon);
    }

    public JNPadCheckBoxMenuItem(String text, Icon icon, boolean b) {
        super(text, icon, b);
    }

    public JNPadCheckBoxMenuItem(Action a) {
        this(a, null);
    }

    public JNPadCheckBoxMenuItem(Action a, ButtonGroup group) {
        super(a);
        if (a instanceof JNPadAction) {
            this.setText(((JNPadAction)a).getLabel());
            this.setDescription(((JNPadAction)a).getDescription());
            this.setKeyBinding(((JNPadAction)a).getKeyBinding());
            this.addItemListener((JNPadAction)a);
        }
        if (group != null) {
            group.add(this);
        }
    }

    public void setKeyBinding(String keyBinding) {
        this._keyBinding = keyBinding;
    }

    public String getKeyBinding() {
        return this._keyBinding;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this._keyBinding != null) {
            d.width += this.getFontMetrics(JNPadMenuItem.acceleratorFont).stringWidth(this._keyBinding) + 30;
        }
        return d;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setStatusDisplayable(StatusDisplayable displayable) {
        this._displayable = displayable;
    }

    public StatusDisplayable getStatusDisplayable() {
        return this._displayable;
    }

    private StatusDisplayable getStatusDisplayable(MouseEvent e) {
        if (this._displayable == null) {
            this._displayable = GUIUtilities.getJNPadFrame(e);
        }
        return this._displayable;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this._description != null) {
            switch (e.getID()) {
                case 504: {
                    this.getStatusDisplayable(e).setStatus(this._description);
                    this._descriptionSet = true;
                    break;
                }
                case 502: 
                case 505: {
                    if (!this._descriptionSet) break;
                    this.getStatusDisplayable(e).clearStatus();
                    this._descriptionSet = false;
                    break;
                }
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void paintComponent(Graphics g) {
        GUIUtilities.setRenderingHints(g);
        super.paintComponent(g);
        if (this._keyBinding != null) {
            g.setFont(JNPadMenuItem.acceleratorFont);
            g.setColor(this.isEnabled() ? (this.getModel().isArmed() ? JNPadMenuItem.acceleratorSelectionForeground : JNPadMenuItem.acceleratorForeground) : JNPadMenuItem.acceleratorDisabledForeground);
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            g.drawString(this._keyBinding, this.getWidth() - (fm.stringWidth(this._keyBinding) + insets.right + insets.left + 5), this.getFont().getSize() + (insets.top - (Platform.isMac ? 0 : 1)));
        }
    }
}

