/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;

public class SideBorder
implements Border,
Serializable {
    private Color _leftColor;
    private Color _rightColor;
    private Color _topColor;
    private Color _bottomColor;
    private int _thickness;
    private static final long serialVersionUID = 4069574159289528841L;

    public SideBorder(Color color, int thickness) {
        this(color, color, color, color, thickness);
    }

    public SideBorder(Color topBottomColor, Color leftRightColor, int thickness) {
        this(topBottomColor, leftRightColor, topBottomColor, leftRightColor, thickness);
    }

    public SideBorder(Color topColor, Color leftColor, Color bottomColor, Color rightColor, int thickness) {
        this._topColor = topColor;
        this._leftColor = leftColor;
        this._rightColor = rightColor;
        this._bottomColor = bottomColor;
        this._thickness = thickness;
    }

    public int getThickness() {
        return this._thickness;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this._topColor != null ? this.getThickness() : 0, this._leftColor != null ? this.getThickness() : 0, this._bottomColor != null ? this.getThickness() : 0, this._rightColor != null ? this.getThickness() : 0);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = this._topColor != null ? this.getThickness() : 0;
        insets.left = this._leftColor != null ? this.getThickness() : 0;
        insets.bottom = this._bottomColor != null ? this.getThickness() : 0;
        insets.right = this._rightColor != null ? this.getThickness() : 0;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        int i = 0;
        while (i < this.getThickness()) {
            if (this._leftColor != null) {
                g.setColor(this._leftColor);
                g.drawLine(x + i, y, x + i, height - 1);
            }
            if (this._topColor != null) {
                g.setColor(this._topColor);
                g.drawLine(x, y + i, width - 1, y + i);
            }
            if (this._rightColor != null) {
                g.setColor(this._rightColor);
                g.drawLine(width - i - 1, y, width - i - 1, height - 1);
            }
            if (this._bottomColor != null) {
                g.setColor(this._bottomColor);
                g.drawLine(x, height - i - 1, width - 1, height - i - 1);
            }
            ++i;
        }
        g.setColor(oldColor);
    }
}

