/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import jnpad.ui.icon.IconClickTarget;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Platform;

public class CompositeIcon
implements Icon {
    private static final int RAISED = 0;
    private static final int EMPTY = 1;
    private static final int LOWERED = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int _iconHeight;
    private int _iconWidth;
    private int[] _borders;
    private int _orientation;
    private Icon[] _icons;
    private Icon _mainIcon;
    private int _gap;

    public CompositeIcon(Icon[] icons, int gap, int orientation) {
        this(icons);
        if (icons.length <= 1 || gap <= 0) {
            return;
        }
        this._gap = gap;
        this._orientation = orientation;
        int i = 0;
        while (i < icons.length) {
            switch (orientation) {
                case 0: {
                    if (i == 0) {
                        this._iconWidth = 0;
                    }
                    this._iconWidth += icons[i].getIconWidth();
                    if (icons.length - 1 <= i) break;
                    this._iconWidth += gap;
                    break;
                }
                case 1: {
                    if (i == 0) {
                        this._iconHeight = 0;
                    }
                    this._iconHeight += icons[i].getIconHeight();
                    if (icons.length - 1 <= i) break;
                    this._iconHeight += gap;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++i;
        }
    }

    public CompositeIcon(Icon[] icons) {
        this._icons = icons;
        this._orientation = -1;
        this._borders = new int[icons.length];
        int k = 0;
        while (k < icons.length) {
            this._iconWidth = Math.max(this._iconWidth, icons[k].getIconWidth());
            this._iconHeight = Math.max(this._iconHeight, icons[k].getIconHeight());
            this._borders[k] = icons[k] instanceof IconClickTarget && !Platform.isMac ? 0 : 1;
            ++k;
        }
    }

    public void setMainIcon(Icon icon) {
        this._mainIcon = icon;
    }

    public Icon getMainIcon() {
        return this._mainIcon;
    }

    public boolean hasMainIcon() {
        return this._mainIcon != null;
    }

    @Override
    public int getIconHeight() {
        return this._iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this._iconWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int dx = 0;
        int dy = 0;
        int i = 0;
        while (i < this._icons.length) {
            Icon icon = this._icons[i];
            int iw = icon.getIconWidth();
            int ih = icon.getIconHeight();
            int ix = x + (this._iconWidth - iw) / 2;
            int iy = y + (this._iconHeight - ih) / 2;
            switch (this._orientation) {
                case 0: {
                    ix = x + dx;
                    dx += iw + this._gap;
                    break;
                }
                case 1: {
                    iy = y + dy;
                    dy += ih + this._gap;
                    break;
                }
            }
            switch (this._borders[i]) {
                case 0: {
                    icon.paintIcon(c, g, ix, iy);
                    Rectangle rect = new Rectangle(ix, iy, iw, ih);
                    this.paintBorder(g, rect, true);
                    break;
                }
                case 1: {
                    icon.paintIcon(c, g, ix, iy);
                    break;
                }
                case 2: {
                    Rectangle rect = new Rectangle(++ix, ++iy, iw, ih);
                    icon.paintIcon(c, g, ix, iy);
                    this.paintBorder(g, rect, false);
                }
            }
            ++i;
        }
    }

    private void paintBorder(Graphics g, Rectangle r, boolean raised) {
        Color color2;
        Color color1;
        Color color = LAFUtils.getPanelBackground();
        if (raised) {
            color1 = color.brighter();
            color2 = color.darker();
        } else {
            color1 = color.darker();
            color2 = color.brighter();
        }
        g.setColor(color1);
        g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
        g.drawLine(r.x, r.y, r.x + r.width - 1, r.y);
        g.setColor(color2);
        g.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.y + r.height - 1);
        g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
    }

    public Icon findHit(Point p) {
        Icon[] iconArray = this._icons;
        int n = this._icons.length;
        int n2 = 0;
        while (n2 < n) {
            IconClickTarget iconClickTarget;
            Icon icon = iconArray[n2];
            if (icon instanceof IconClickTarget && (iconClickTarget = (IconClickTarget)icon).isHit(p)) {
                return iconClickTarget.getTarget();
            }
            ++n2;
        }
        return null;
    }
}

