/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.DefaultMetalTheme;
import jnpad.GUIUtilities;
import jnpad.ui.plaf.DarkIconFilter;
import jnpad.ui.plaf.JNPadButtonUI;
import jnpad.ui.plaf.JNPadLabelUI;
import jnpad.ui.plaf.JNPadLightMetalTheme;
import jnpad.ui.plaf.JNPadMenuUI;
import jnpad.ui.plaf.JNPadScrollBarUI;
import jnpad.ui.plaf.JNPadToggleButtonUI;
import jnpad.ui.plaf.JNPadToolBarUI;
import jnpad.ui.plaf.JNPadToolbarSeparatorUI;
import jnpad.util.Platform;

public class JNPadDarkMetalTheme
extends DefaultMetalTheme {
    private static final ColorUIResource PRIMARY1;
    private static final ColorUIResource PRIMARY2;
    private static final ColorUIResource PRIMARY3;
    private static final ColorUIResource SECUNDARY1;
    private static final ColorUIResource SECUNDARY2;
    private static final ColorUIResource SECUNDARY3;
    static final ColorUIResource BLACK;
    static final ColorUIResource WHITE;
    private static final FontUIResource PLAIN_FONT;
    private static final FontUIResource BOLD_FONT;
    private static final Logger LOGGER;

    static {
        Font font;
        PRIMARY1 = new ColorUIResource(121, 121, 125);
        PRIMARY2 = new ColorUIResource(71, 71, 75);
        PRIMARY3 = new ColorUIResource(99, 99, 99);
        SECUNDARY1 = new ColorUIResource(113, 113, 113);
        SECUNDARY2 = new ColorUIResource(91, 91, 95);
        SECUNDARY3 = new ColorUIResource(51, 51, 55);
        BLACK = new ColorUIResource(222, 222, 222);
        WHITE = new ColorUIResource(18, 30, 49);
        if (Platform.isWindows && (font = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            PLAIN_FONT = new FontUIResource(font.getName(), 0, font.getSize());
            BOLD_FONT = new FontUIResource(font.getName(), 1, font.getSize());
        } else {
            PLAIN_FONT = new FontUIResource("Dialog", 0, 12);
            BOLD_FONT = new FontUIResource("Dialog", 1, 12);
        }
        LOGGER = Logger.getLogger(JNPadDarkMetalTheme.class.getName());
    }

    @Override
    public String getName() {
        return "jNPad (Dark)";
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return PRIMARY1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return PRIMARY2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return PRIMARY3;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return SECUNDARY1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return SECUNDARY2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return SECUNDARY3;
    }

    @Override
    protected ColorUIResource getWhite() {
        return WHITE;
    }

    @Override
    protected ColorUIResource getBlack() {
        return BLACK;
    }

    @Override
    public FontUIResource getControlTextFont() {
        return PLAIN_FONT;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return PLAIN_FONT;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return PLAIN_FONT;
    }

    @Override
    public FontUIResource getUserTextFont() {
        return PLAIN_FONT;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return BOLD_FONT;
    }

    @Override
    public void addCustomEntriesToTable(UIDefaults table) {
        try {
            Object[] defaults = new Object[]{"jnpad.dark.theme", Boolean.TRUE, "jnpad.imageicon.filter", new DarkIconFilter(), "FileChooser.upFolderIcon", GUIUtilities.getIcon("plaf/upFolder.png"), "FileChooser.newFolderIcon", GUIUtilities.getIcon("plaf/newFolder.png"), "FileChooser.homeFolderIcon", GUIUtilities.getIcon("plaf/homeFolder.png"), "FileChooser.listViewIcon", GUIUtilities.getIcon("plaf/listView.png"), "FileChooser.detailsViewIcon", GUIUtilities.getIcon("plaf/detailsView.png"), "OptionPane.errorIcon", GUIUtilities.getIcon("plaf/errorDialog.png"), "OptionPane.informationIcon", GUIUtilities.getIcon("plaf/informationDialog.png"), "OptionPane.warningIcon", GUIUtilities.getIcon("plaf/warningDialog.png"), "OptionPane.questionIcon", GUIUtilities.getIcon("plaf/questionDialog.png"), "LabelUI", JNPadLabelUI.class.getName(), "ButtonUI", JNPadButtonUI.class.getName(), "ToggleButtonUI", JNPadToggleButtonUI.class.getName(), "ToolBarUI", JNPadToolBarUI.class.getName(), "ToolBarSeparatorUI", JNPadToolbarSeparatorUI.class.getName(), "SplitPaneUI", BasicSplitPaneUI.class.getName(), "ScrollBarUI", JNPadScrollBarUI.class.getName(), "ScrollBar.track", this.getControlShadow(), "ScrollBar.trackHighlight", this.getControl(), "TabbedPane.selected", WHITE, "MenuUI", JNPadMenuUI.class.getName(), "TitledBorder.titleColor", PRIMARY1, "ToolTip.background", WHITE, "MenuItem.acceleratorForeground", JNPadLightMetalTheme.LIGHT_GRAY_0, "CheckBoxMenuItem.acceleratorForeground", JNPadLightMetalTheme.LIGHT_GRAY_0, "RadioButtonMenuItem.acceleratorForeground", JNPadLightMetalTheme.LIGHT_GRAY_0};
            table.putDefaults(defaults);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }
}

