/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.text.View;
import jnpad.GUIUtilities;
import jnpad.ui.plaf.JNPadDarkMetalTheme;
import jnpad.ui.plaf.JNPadLightMetalTheme;
import jnpad.ui.plaf.JNPadMenuUI;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Utilities;

public final class JNPadToolBarButtonUI
extends MetalButtonUI {
    private static final Border EMPTY_BORDER = GUIUtilities.createEmptyBorder(5);
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private Border oldBorder;
    private boolean oldRolloverEnabled;
    private boolean oldFocusable;
    private static Color selectedColor1;
    private static Color selectedColor2;
    private static Color borderColor1;
    private static Color borderColor2;
    private static final JNPadToolBarButtonUI INSTANCE;

    static {
        INSTANCE = new JNPadToolBarButtonUI();
    }

    public static ComponentUI createUI(JComponent c) {
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.oldBorder = b.getBorder();
        this.oldRolloverEnabled = b.isRolloverEnabled();
        this.oldFocusable = b.isFocusable();
        b.setBorder(EMPTY_BORDER);
        b.setRolloverEnabled(true);
        b.setFocusable(false);
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder(this.oldBorder);
        b.setRolloverEnabled(this.oldRolloverEnabled);
        b.setFocusable(this.oldFocusable);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        JNPadToolBarButtonUI.viewRect.x = i.left;
        JNPadToolBarButtonUI.viewRect.y = i.top;
        JNPadToolBarButtonUI.viewRect.width = b.getWidth() - (i.right + JNPadToolBarButtonUI.viewRect.x);
        JNPadToolBarButtonUI.viewRect.height = b.getHeight() - (i.bottom + JNPadToolBarButtonUI.viewRect.y);
        JNPadToolBarButtonUI.textRect.height = 0;
        JNPadToolBarButtonUI.textRect.width = 0;
        JNPadToolBarButtonUI.textRect.y = 0;
        JNPadToolBarButtonUI.textRect.x = 0;
        JNPadToolBarButtonUI.iconRect.height = 0;
        JNPadToolBarButtonUI.iconRect.width = 0;
        JNPadToolBarButtonUI.iconRect.y = 0;
        JNPadToolBarButtonUI.iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : this.defaultTextIconGap);
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed() || model.isSelected()) {
            g.setColor(b instanceof JToggleButton ? JNPadToolBarButtonUI.selectedColor2() : JNPadToolBarButtonUI.selectedColor1());
            g.fillRect(0, 0, c.getSize().width, c.getSize().height);
            this.doPaintIcon(g, b, iconRect);
            GUIUtilities.drawBorder(g, JNPadToolBarButtonUI.borderColor1(), 0, 0, c.getSize().width, c.getSize().height);
        } else if (model.isRollover()) {
            g.setColor(JNPadMenuUI.topLevelMenuBg());
            g.fillRect(0, 0, c.getSize().width, c.getSize().height);
            this.doPaintIcon(g, b, iconRect);
            GUIUtilities.drawBorder(g, JNPadToolBarButtonUI.borderColor2(), 0, 0, c.getSize().width, c.getSize().height);
        } else {
            this.doPaintIcon(g, b, iconRect);
        }
        if (Utilities.isNotEmptyString(text)) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, c, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    private void doPaintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
    }

    private static Color selectedColor1() {
        if (selectedColor1 == null) {
            selectedColor1 = LAFUtils.isDarkLAF() ? JNPadDarkMetalTheme.WHITE : JNPadLightMetalTheme.LIGHT_GRAY_1;
        }
        return selectedColor1;
    }

    private static Color selectedColor2() {
        if (selectedColor2 == null) {
            selectedColor2 = LAFUtils.isDarkLAF() ? JNPadDarkMetalTheme.WHITE : JNPadLightMetalTheme.LIGHT_GRAY_3;
        }
        return selectedColor2;
    }

    private static Color borderColor1() {
        if (borderColor1 == null) {
            borderColor1 = LAFUtils.isDarkLAF() ? JNPadLightMetalTheme.DARK_GRAY : JNPadLightMetalTheme.GRAY;
        }
        return borderColor1;
    }

    private static Color borderColor2() {
        if (borderColor2 == null) {
            borderColor2 = LAFUtils.isDarkLAF() ? JNPadLightMetalTheme.GRAY : JNPadLightMetalTheme.DARK_GRAY;
        }
        return borderColor2;
    }
}

