/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.status;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.ui.JNPadMenuItem;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.status.IHeapMonitorStatusBar;
import jnpad.util.Utilities;

public class HeapMonitor
extends JComponent {
    JPopupMenu popupMenu = new JPopupMenu();
    JNPadMenuItem miCleaningMemory = new JNPadMenuItem(JNPadBundle.getString("HeapMonitor.cleaningMemory.text", new Object[0]), GUIUtilities.loadIcon("gc.png"));
    JNPadMenuItem miHideHeapMonitor = new JNPadMenuItem(JNPadBundle.getString("HeapMonitor.hide.text", new Object[0]), GUIUtilities.loadIcon("java-close.png"));
    private static final int ORANGE_THRESHOLD = 70;
    private static final int RED_THRESHOLD = 90;
    private static final Color ORANGE;
    private static final Color RED;
    private static final long M = 0x100000L;
    private long total;
    private long used;
    private IHeapMonitorStatusBar statusBar;
    private static final long serialVersionUID = 3548053449964476421L;

    static {
        if (LAFUtils.isDarkLAF()) {
            ORANGE = new Color(139, 90, 0);
            RED = new Color(139, 0, 0);
        } else {
            ORANGE = new Color(255, 190, 125);
            RED = new Color(255, 70, 70);
        }
    }

    public HeapMonitor(IHeapMonitorStatusBar statusBar) {
        this.statusBar = statusBar;
        this.setPreferredSize(new Dimension(200, 1));
        this.updateStats();
        Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapMonitor.this.updateStats();
                HeapMonitor.this.repaint();
            }
        });
        timer.start();
        this.popupMenu.add(this.miCleaningMemory);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.miHideHeapMonitor);
        this.miCleaningMemory.setDescription(JNPadBundle.getString("HeapMonitor.cleaningMemory.description", new Object[0]));
        this.miHideHeapMonitor.setDescription(JNPadBundle.getString("HeapMonitor.hide.description", new Object[0]));
        this.miCleaningMemory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utilities.gc();
            }
        });
        this.miHideHeapMonitor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapMonitor.this.statusBar.showHeapMonitor(false);
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 501 && SwingUtilities.isRightMouseButton(e)) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
            this.popupMenu.pack();
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        int usedX = (int)(this.used * (long)bounds.width / this.total);
        int warnX = 70 * bounds.width / 100;
        int dangerX = 90 * bounds.width / 100;
        Color savedColor = g.getColor();
        g.setColor(LAFUtils.isDarkLAF() ? this.getBackground().brighter() : this.getBackground().darker());
        g.fillRect(0, 0, Math.min(usedX, warnX), bounds.height);
        g.setColor(ORANGE);
        g.fillRect(warnX, 0, Math.min(usedX - warnX, dangerX - warnX), bounds.height);
        g.setColor(RED);
        g.fillRect(dangerX, 0, Math.min(usedX - dangerX, bounds.width - dangerX), bounds.height);
        g.setColor(this.getForeground());
        String s = JNPadBundle.getString("HeapMonitor.label", this.used / 0x100000L, this.total / 0x100000L);
        int x = (bounds.width - g.getFontMetrics().stringWidth(s)) / 2;
        int y = (bounds.height + g.getFontMetrics().getHeight()) / 2;
        g.drawString(s, x, y - 2);
        g.setColor(savedColor);
    }

    private void updateStats() {
        long free = Runtime.getRuntime().freeMemory();
        this.total = Runtime.getRuntime().totalMemory();
        long max = Runtime.getRuntime().maxMemory();
        this.used = this.total - free;
        String tip = JNPadBundle.getString("HeapMonitor.tooltip", this.used * 100L / this.total, this.used / 0x100000L, this.total / 0x100000L, max / 0x100000L);
        this.setToolTipText(tip);
    }
}

