/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.tab;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.ui.tab.AbstractTabbedPane;

public class CloseButtonTabComponent
extends JPanel {
    private final AbstractTabbedPane tabbedPane;
    private static final long serialVersionUID = -1881405193929636495L;

    public CloseButtonTabComponent(final AbstractTabbedPane tabbedPane) {
        super(new FlowLayout(0, 0, 0));
        this.tabbedPane = tabbedPane;
        this.setOpaque(false);
        JLabel label = new JLabel(){

            @Override
            public String getText() {
                int idx = tabbedPane.indexOfTabComponent(CloseButtonTabComponent.this);
                if (idx != -1) {
                    return tabbedPane.getTitleAt(idx);
                }
                return null;
            }

            @Override
            public Icon getIcon() {
                int idx = tabbedPane.indexOfTabComponent(CloseButtonTabComponent.this);
                if (idx != -1) {
                    return tabbedPane.getIconAt(idx);
                }
                return null;
            }
        };
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.add(label);
        this.add(new CloseTabButton());
    }

    private class CloseTabButton
    extends JButton {
        private static final long serialVersionUID = 2127903096547704654L;

        CloseTabButton() {
            this.setPreferredSize(new Dimension(16, 16));
            this.setToolTipText(JNPadBundle.getString("CloseTabButton.close", new Object[0]));
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorderPainted(false);
            this.setRolloverEnabled(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = CloseButtonTabComponent.this.tabbedPane.indexOfTabComponent(CloseButtonTabComponent.this);
                    if (i != -1) {
                        CloseButtonTabComponent.this.tabbedPane.close(i);
                    }
                }
            });
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2D = (Graphics2D)g;
            Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.getModel().isRollover()) {
                GUIUtilities.paintCross(g, Color.BLACK, 8, 8, 6, 2);
            } else {
                GUIUtilities.paintCross(g, Color.GRAY, 8, 8, 6, 1);
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
        }
    }
}

