/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import jnpad.ui.ColorUtilities;
import jnpad.ui.plaf.LAFUtils;

public abstract class JNPadTableCellRenderer
extends JPanel
implements TableCellRenderer {
    protected boolean supportsFocusBorder;
    protected boolean tooltipEnabled;
    protected boolean alternateRowColorEnabled = true;
    protected Color alternateRowColor;
    private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final long serialVersionUID = -6184651210115838365L;

    protected JNPadTableCellRenderer() {
        this(true);
    }

    protected JNPadTableCellRenderer(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
        this.setOpaque(true);
        this.setSupportsFocusBorder(true);
    }

    public JNPadTableCellRenderer(boolean tooltipEnabled, boolean alternateRowColorEnabled) {
        this(tooltipEnabled);
        this.setAlternateRowColorEnabled(alternateRowColorEnabled);
    }

    public JNPadTableCellRenderer(Color alternateRowColor) {
        this(true);
        this.setAlternateRowColor(alternateRowColor);
    }

    public JNPadTableCellRenderer(boolean tooltipEnabled, Color alternateRowColor) {
        this(tooltipEnabled);
        this.setAlternateRowColor(alternateRowColor);
    }

    public void setSupportsFocusBorder(boolean supportsFocusBorder) {
        this.supportsFocusBorder = supportsFocusBorder;
        if (supportsFocusBorder) {
            this.setBorder(JNPadTableCellRenderer.getNoFocusBorder());
        }
    }

    public boolean getSupportsFocusBorder() {
        return this.supportsFocusBorder;
    }

    protected static Border getNoFocusBorder() {
        Border border = UIManager.getBorder("Table.cellNoFocusBorder");
        if (border != null) {
            return border;
        }
        return DEFAULT_NO_FOCUS_BORDER;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
    }

    public boolean isAlternateRowColorEnabled() {
        return this.alternateRowColorEnabled;
    }

    public void setAlternateRowColorEnabled(boolean alternateRowColorEnabled) {
        this.alternateRowColorEnabled = alternateRowColorEnabled;
    }

    public Color getAlternateRowColor() {
        return this.alternateRowColor;
    }

    public void setAlternateRowColor(Color alternateRowColor) {
        this.alternateRowColor = alternateRowColor;
        this.alternateRowColorEnabled = alternateRowColor != null;
    }

    protected void setRowBackground(Color c) {
        this.setBackground(c);
    }

    protected void setRowForeground(Color c) {
        this.setForeground(c);
    }

    protected void setRowFont(Font font) {
        this.setFont(font);
    }

    protected void setColors(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected && table.isEnabled()) {
            this.setRowForeground(table.getSelectionForeground());
            this.setRowBackground(table.getSelectionBackground());
        } else if (!table.isEnabled()) {
            this.setRowForeground(LAFUtils.getTextFieldInactiveForeground());
            this.setRowBackground(LAFUtils.getTextFieldInactiveBackground());
        } else {
            Color fg;
            Color bg;
            if (this.alternateRowColorEnabled && row % 2 == 0) {
                if (this.alternateRowColor != null) {
                    bg = this.alternateRowColor;
                    fg = ColorUtilities.computeForeground(bg);
                } else {
                    Color alternateColor = UIManager.getColor("Table.alternateRowColor");
                    if (alternateColor != null) {
                        bg = alternateColor;
                    } else {
                        bg = table.getBackground();
                        if (LAFUtils.isNimbusLAF() && bg instanceof UIResource) {
                            bg = ColorUtilities.createPureColor(bg);
                        }
                    }
                    fg = table.getForeground();
                }
            } else {
                bg = table.getBackground();
                if (LAFUtils.isNimbusLAF() && bg instanceof UIResource) {
                    bg = ColorUtilities.createPureColor(bg);
                }
                fg = table.getForeground();
            }
            this.setRowForeground(fg);
            this.setRowBackground(bg);
        }
    }

    protected abstract void setValue(JTable var1, Object var2, int var3, int var4);

    protected void setFont(JTable table, Object value, int row, int column) {
        this.setRowFont(table.getFont());
    }

    protected void setState(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    }

    protected void setBorder(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.supportsFocusBorder) {
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = LAFUtils.getTableFocusCellHighlightBorder();
                }
                this.setBorder(border);
                if (!isSelected && table.isCellEditable(row, column)) {
                    this.setRowForeground(LAFUtils.getTableFocusCellForeground());
                    this.setRowBackground(LAFUtils.getTableFocusCellBackground());
                }
            } else {
                this.setBorder(JNPadTableCellRenderer.getNoFocusBorder());
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setColors(table, value, isSelected, hasFocus, row, column);
        this.setFont(table, value, row, column);
        this.setBorder(table, value, isSelected, hasFocus, row, column);
        this.setState(table, value, isSelected, hasFocus, row, column);
        this.setValue(table, value, row, column);
        return this;
    }
}

