@echo off
REM ### ====================================================================== ###
REM ##                                                                          ##
REM ##                        jNPad Launch Script                               ##
REM ##                                                                          ##
REM ### ====================================================================== ###

if "%OS%"=="Windows_NT" @setlocal

set APP_NAME="jNPad"
set JAVA_OPTS=-Xms64m -Xmx128m

set DIRNAME=.\
REM # %~dp0 is expanded pathname of the current script under NT
if "%OS%" == "Windows_NT" set DIRNAME=%~dp0%

if not "%JNPAD_HOME%" == "" goto have_jnpad_home
set JNPAD_HOME=%DIRNAME%

:have_jnpad_home
set JNPAD_JAR=%JNPAD_HOME%\jnpad-0.3.jar

REM ###############################################
REM #### Alternatively, change JAVA_HOME below ####
REM ###############################################
REM set JAVA_HOME=C:\Archivos de programa\Java\jre6\
REM ###############################################

if not exist "%JAVA_HOME%\bin\java.exe" goto no_java_home
if not exist "%JAVA_HOME%\bin\javaw.exe" goto no_java_home
set JAVA=%JAVA_HOME%\bin\java
set JAVAW=%JAVA_HOME%\bin\javaw
REM echo JAVA_HOME : %JAVA_HOME%
REM echo JAVA      : %JAVA%
REM echo JAVAW     : %JAVAW%
goto skip_no_java_home

:no_java_home
set JAVA=java
goto read_cmd_line_args

:skip_no_java_home
if [%1] == [] goto no_console

:read_cmd_line_args
REM # Read all command line arguments
set ARGS=
:loop
if [%1] == [] goto loop_end
	set ARGS=%ARGS% %1
	shift
	goto loop
:loop_end

REM # Run JVM
REM echo "%JAVA%" %JAVA_OPTS% -jar "%JNPAD_JAR%" %ARGS% 
"%JAVA%" %JAVA_OPTS% -jar "%JNPAD_JAR%" %ARGS%
if errorlevel 1 pause
goto end

:no_console
REM # Run JVM no console
REM echo start %APP_NAME% "%JAVAW%" %JAVA_OPTS% -jar "%JNPAD_JAR%"
start %APP_NAME% "%JAVAW%" %JAVA_OPTS% -jar "%JNPAD_JAR%"

:end
if "%OS%"=="Windows_NT" @endlocal
REM pause
