#!/bin/sh
### ====================================================================== ###
##                                                                          ##
##                        jNPad Launch Script                               ##
##                                                                          ##
### ====================================================================== ###

# Locates the java executable.
if [ "$JAVA_HOME" != "" ] ; then
    JAVA=$JAVA_HOME/bin/java
else
    JAVACMD=`which java 2> /dev/null `
    if [ -z "$JAVACMD" ] ; then
        echo "Error: cannot find java VM."
        exit 1
    else
        JAVA=java
    fi
fi

# Resolve the path to the jnpad-0.3.jar located in the same directory as this script
if [ -h $0 ]
then
    # This script has been invoked from a symlink, resolve the link's target (i.e. the path to this script)
    JNPAD_SH=`ls -l "$0"`
    JNPAD_SH=${JNPAD_SH#*-> }
else
    JNPAD_SH=$0
fi

CURRENT_DIR=`dirname "$JNPAD_SH"`
JNPAD_JAR=$CURRENT_DIR/jnpad-0.3.jar

# echo "CURRENT_DIR : "$CURRENT_DIR
# echo "JNPAD_JAR : "$JNPAD_JAR

# For Cygwin, ensure paths are in Windows format before anything is touched
if $cygwin ; then
	[ -n "$CURRENT_DIR" ] &&
        CURRENT_DIR=`cygpath --windows "$CURRENT_DIR"`
    [ -n "$JNPAD_JAR" ] &&
        JNPAD_JAR=`cygpath --windows "$JNPAD_JAR"`
fi

# echo "CURRENT_DIR : "$CURRENT_DIR
# echo "JNPAD_JAR : "$JNPAD_JAR

exec $JAVA -jar $JNPAD_JAR $@