#!/bin/sh

# Clean:
# 1) remove logs
# 2) remove docs
# 3) remove clases
# 4) remove dist
# 5) remove bak
# 6) remove ant_build_output.txt
# 7) remove props/jnpad.properties
# 8) remove props/jnpad.defaults.properties
# 9) remove props/search.properties

function removeDir {
	if [ -d $1 ]; then
		rm -rf $1
	fi 
}

function removeFile {
	if [ -x $1 ]; then
		rm -f $1
	fi 
}

echo 
echo -ne " =          10% -> remove logs...                            \r"
removeDir logs

echo -ne " ==         20% -> remove docs...                            \r"
removeDir javadoc

echo -ne " ===        30% -> remove docs...                            \r"
removeFile jnpad-0.3-docs.zip

echo -ne " ====       40% -> remove clases...                          \r"
removeDir classes

echo -ne " =====      50% -> remove dist...                            \r"
removeDir dist

echo -ne " ======     60% -> remove bak...                             \r"
removeDir bak

echo -ne " =======    70% -> remove remove ant_build_output.txt...     \r"
removeFile ant_build_output.txt

echo -ne " ========   80% -> remove props/jnpad.properties...          \r"
removeFile props/jnpad.properties

echo -ne " ========   80% -> remove props/jnpad.defaults.properties... \r"
removeFile props/jnpad.defaults.properties

echo -ne " =========  90% -> remove props/search.properties...         \r"
removeFile props/search.properties

echo -ne " ========== 100% -> Task finished                            \r"
echo -ne '\n'
