/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.JNPadInput;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Config;
import jnpad.util.Utilities;

/**
 * The Class OpenRecentFileAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class OpenRecentFileAction extends JNPadAction {
  /** The in. */
  private JNPadInput                      in;

  /** The Constant NAME. */
  static final String                     NAME             = "open-recent-file";              //$NON-NLS-1$

  /** The map. */
  private static Map<String, JNPadAction> map              = new HashMap<String, JNPadAction>();

  /** UID */
  private static final long               serialVersionUID = 4720060976039922757L;

  /**
   *
   * @param jNPad JNPadFrame
   * @param in JNPadInput
   */
  public OpenRecentFileAction(JNPadFrame jNPad, JNPadInput in) {
    super(jNPad, NAME, Group.FILE);
    
    this.in = in;

    final String ttip = in.getPath();
    final String name = NAME + Utilities.SPACE_STRING + ttip;

    setToolTipText(ttip);
    setName(name);

    if (Config.isDefaultMode()) {
      if (in.isReadOnly()) {
        setIcon(GUIUtilities.loadIcon("file-readonly.png")); //$NON-NLS-1$
      }
      else {
        setIcon(GUIUtilities.loadIcon("file.png")); //$NON-NLS-1$
      }
    }

    map.put(name, this);
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    jNPad.openFile(in);
  }

  /**
   * Gets the completions for prefix.
   *
   * @param prefix the prefix
   * @return the completions for prefix
   */
  static List<String> getCompletionsForPrefix(String prefix) {
    List<String> list = new ArrayList<String>();
    for (String key : map.keySet()) {
      JNPadAction action = map.get(key);
      if (key.startsWith(prefix) && action.isEnabled()) {
        list.add(key);
      }
    }
    Collections.sort(list);
    return list;
  }
  
  /**
   * Perform action.
   *
   * @param name the name
   * @return true, if successful
   */
  static boolean performAction(String name) {
    JNPadAction action = map.get(name);
    if (action != null && action.isEnabled()) {
      action.performAction();
      return true;
    }
    return false;
  }
  
}
