/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_PRINT;

import java.awt.print.PageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.print.PrintText;
import jnpad.print.PrintingOptions;
import jnpad.text.JNPadTextArea;

/**
 * The Class PrintAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class PrintAction extends JNPadAction {
  /** Logger */
  private final static Logger LOGGER           = Logger.getLogger(PrintAction.class.getName());

  /** UID */
  private static final long   serialVersionUID = -6923219883495955962L;

  /**
   * Instantiates a new prints the action.
   *
   * @param jNPad JNPadFrame
   */
  public PrintAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_PRINT,
          Group.FILE,
          Accelerators.PRINT, "print.png"); //$NON-NLS-1$
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    JNPadTextArea textArea = jNPad.getActiveTextArea();
    if (textArea != null) {
      try {
        PrintingOptions printOptions = new PrintingOptions();
        printOptions.setPrintLineNumbers(Config.PRINT_LINE_NUMBERS.getValue());
        printOptions.setPrintHeader(Config.PRINT_HEADER.getValue());
        printOptions.setWrapText(Config.PRINT_WRAP_TEXT.getValue());
        printOptions.setPageFont(Config.PRINT_FONT.getValue());

        PageFormat pageFormat = jNPad.getPageFormat();

        printOptions.setPageFormat(pageFormat);

        new PrintText(textArea.getDocument(), textArea.getName(), printOptions, textArea.getTabSize());
      }
      catch (Exception ex) {
        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
      }
    }
  }

}
