/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_REPLACE;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.text.IEditAction;

/**
 * The Class ReplaceAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class ReplaceAction extends JNPadAction implements IEditAction {
  /** UID */
  private static final long serialVersionUID = 8587003817087697511L;

  /**
   * Instantiates a new replace action.
   *
   * @param jNPad the jNPad's frame
   */
  public ReplaceAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_REPLACE,
          Group.SEARCH,
          Accelerators.REPLACE, "replace.png"); //$NON-NLS-1$

    if(Config.isBasicMode()) {
      setLargeIcon(GUIUtilities.loadIcon("22/replace.png")); //$NON-NLS-1$
      setButtonText(ActionBundle.getString(ACTION_NAME_REPLACE.concat(".button.text"))); //$NON-NLS-1$
    }
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    jNPad.showReplaceDialog();
  }

}
