/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.config;

import java.awt.Font;
import java.util.StringTokenizer;

/**
 * The Class FontProp.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class FontProp extends Prop<Font> {
  /** UID */
  private static final long serialVersionUID = 4550275088818908648L;

  /**
   * Instantiates a new font prop.
   *
   * @param name the name
   * @param def the def
   */
  public FontProp(String name, Font def) {
    super(name, def);
  }

  /**
   * Gets the default string.
   *
   * @return the default string
   * @see jnpad.config.Prop#getDefaultString()
   */
  @Override
  public String getDefaultString() {
    return format(defaultValue);
  }

  /**
   * Parses the.
   *
   * @param value the value
   * @return the font
   * @throws IllegalArgumentException the illegal argument exception
   */
  public static Font parse(String value) throws IllegalArgumentException {
    String name;
    int size, style;

    try {
      StringTokenizer st = new StringTokenizer(value, ","); //$NON-NLS-1$

      name = st.nextToken().trim();
      String s_style = st.nextToken().trim();
      size = IntProp.parse(st.nextToken().trim());

      if (s_style.equalsIgnoreCase("Font.BOLD")) //$NON-NLS-1$
        style = Font.BOLD;
      else if (s_style.equalsIgnoreCase("Font.ITALIC")) //$NON-NLS-1$
        style = Font.ITALIC;
      else if (s_style.equalsIgnoreCase("Font.BOLD|Font.ITALIC") || //$NON-NLS-1$
               s_style.equalsIgnoreCase("Font.ITALIC|Font.BOLD"))   //$NON-NLS-1$
        style = Font.BOLD | Font.ITALIC;
      else
        style = IntProp.parse(s_style);
    }
    catch (Exception ex) {
      throw new IllegalArgumentException("Fuente inv�lida: " + value); //$NON-NLS-1$
    }

    return new Font(name, style, size);
  }

  /**
   * Format.
   *
   * @param value the value
   * @return the string
   */
  public static String format(Font value) {
    StringBuilder sb = new StringBuilder();
    sb.append(value.getName()).append(","). //$NON-NLS-1$
       append(value.getStyle()).append(","). //$NON-NLS-1$
       append(value.getSize());
    return sb.toString();
  }

  /**
   * Gets the value.
   *
   * @return the value
   * @see jnpad.config.Prop#getValue()
   */
  @Override
  public Font getValue() {
    return Config.getFontProp(this);
  }

  /**
   * Do set value.
   *
   * @param value the value
   * @see jnpad.config.Prop#doSetValue(java.lang.Object)
   */
  @Override
  protected void doSetValue(Font value) {
    Config.setFontProp(this, value);
  }
  
}
