/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text;

import java.beans.PropertyChangeEvent;

import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

import jnpad.text.syntax.ASN1View;
import jnpad.text.syntax.CPPView;
import jnpad.text.syntax.CView;
import jnpad.text.syntax.ContentTypes;
import jnpad.text.syntax.JavaView;
import jnpad.text.syntax.PlainView2;
import jnpad.text.syntax.PropertiesView;
import jnpad.text.syntax.WrappedPlainView2;

/**
 * The Class JNPadTextAreaUI.
 * 
 * @version 0.3
 * @since jNPad 0.1
 */
public class JNPadTextAreaUI extends BasicTextAreaUI implements ContentTypes {
  private static final EditorKit defaultKit = new JNPadTextAreaEditorKit();

  /**
   * Creates the ui.
   *
   * @param ta the ta
   * @return the component ui
   */
  public static ComponentUI createUI(JComponent ta) {
    return new JNPadTextAreaUI();
  }

  /**
   * Property change.
   *
   * @param evt the evt
   * @see javax.swing.plaf.basic.BasicTextAreaUI#propertyChange(java.beans.PropertyChangeEvent)
   */
  @Override
  protected void propertyChange(PropertyChangeEvent evt) {
    super.propertyChange(evt);
    if (evt.getPropertyName().equals("jnpad.contentType")) { //$NON-NLS-1$
      // rebuild the view
      modelChanged();
    }
  }

  /**
   * Creates the view.
   *
   * @param elem the elem
   * @return the view
   * @see javax.swing.plaf.basic.BasicTextAreaUI#create(javax.swing.text.Element)
   */
  @Override
  public View create(Element elem) {
    JTextComponent c = getComponent();
    if (c instanceof JNPadTextArea) {
      JNPadTextArea area = (JNPadTextArea) c;
      String style = area.getContentType();
      if (JAVA.equals(style))       return new JavaView(elem, false);
      if (C.equals(style))          return new CView(elem, false);
      if (CPP.equals(style))        return new CPPView(elem, false);
      if (PROPERTIES.equals(style)) return new PropertiesView(elem, false);
      if (ASN1.equals(style))       return new ASN1View(elem, false);
      if (PLAIN.equals(style)) {
        if (area.getLineWrap())
          return new WrappedPlainView2(elem, area.getWrapStyleWord());
        return new PlainView2(elem, false);
      }
    }
    return super.create(elem);
  }

  /**
   * Install ui.
   *
   * @param c the c
   * @see javax.swing.plaf.basic.BasicTextUI#installUI(javax.swing.JComponent)
   */
  @Override
  public void installUI(JComponent c) {
    if (!(c instanceof JNPadTextArea)) {
      throw new Error("JNPadTextAreaUI needs an instance of JNPadTextArea!"); //$NON-NLS-1$
    }
    super.installUI(c);
  }

  /**
   * Gets the editor kit.
   *
   * @param tc the tc
   * @return the editor kit
   * @see javax.swing.plaf.basic.BasicTextUI#getEditorKit(javax.swing.text.JTextComponent)
   */
  @Override
  public EditorKit getEditorKit(JTextComponent tc) {
    return defaultKit;
  }

}
