/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalComboBoxButton;

import jnpad.GUIUtilities;
import jnpad.ui.ColorUtilities;
import jnpad.ui.toolbar.ToolBarButton;

/**
 * The Class JNPadButtonUI.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class JNPadButtonUI extends MetalButtonUI {
  private static Color               color1a;
  private static Color               color1b;

  /** The Constant INSTANCE. */
  private static final JNPadButtonUI INSTANCE = new JNPadButtonUI();

  /**
   * Creates the ui.
   *
   * @param c the JComponent
   * @return the component ui
   */
  public static ComponentUI createUI(JComponent c) {
    if (c instanceof ToolBarButton) {
      return JNPadToolBarButtonUI.createUI(c);
    }
    return INSTANCE;
  }

  /**
   * Paint.
   *
   * @param g the Graphics
   * @param c the JComponent
   * @see javax.swing.plaf.basic.BasicButtonUI#paint(java.awt.Graphics, javax.swing.JComponent)
   */
  @Override
  public void paint(Graphics g, JComponent c) {
    if (!c.isOpaque()) {
      super.paint(g, c);
      return;
    }

    if (check(c)) {
      AbstractButton button = (AbstractButton) c;
      ButtonModel model = button.getModel();

      if (!button.isRolloverEnabled()) {
        button.setRolloverEnabled(true);
      }

      int w = c.getWidth();
      int h = c.getHeight();

      Color color1, color2;

      if (model.isRollover()) {
        color2 = JNPadMenuUI.topLevelMenuBg();
        color1 = color1a(color2);
      }
      else {
        color2 = c.getBackground();
        color1 = color1b(color2);
      }

      Graphics2D g2D = (Graphics2D) g;
      GradientPaint gp = new GradientPaint(0, 0, color1, 0, h, color2);
      g2D.setPaint(gp);
      g2D.fill(new Rectangle2D.Double(0, 0, w, h)); // g2D.fill(new Rectangle(0, 0, w, h));

      GUIUtilities.draw3DBorder(g, color1, ColorUtilities.darker(color2, 25), 2, 2, w - 4, h - 4);
    }

    super.paint(g, c);
  }

  /**
   * Paint text.
   *
   * @param g the Graphics
   * @param b the AbstractButton
   * @param textRect the text rect
   * @param text the text
   * @see javax.swing.plaf.basic.BasicButtonUI#paintText(java.awt.Graphics, javax.swing.AbstractButton, java.awt.Rectangle, java.lang.String)
   */
  @Override
  protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
    GUIUtilities.setRenderingHints(g);
    super.paintText(g, (JComponent) b, textRect, text);
  }
  
  /**
   * Check.
   *
   * @param c the JComponent
   * @return true, if successful
   */
  private static boolean check(JComponent c) {
    return (c.getWidth() > c.getHeight() + 15) && !(c instanceof MetalComboBoxButton);
  }

  /**
   * Color1a.
   *
   * @param color2 the color2
   * @return the color
   */
  private Color color1a(Color color2) {
    if (color1a == null)
      color1a = new Color(Math.min(255, color2.getRed() + 35), Math.min(255, color2.getRed() + 35), Math.min(255, color2.getBlue() + 35));
    return color1a;
  }

  /**
   * Color1b.
   *
   * @param color2 the color2
   * @return the color
   */
  private Color color1b(Color color2) {
    if (color1b == null)
      color1b = new Color(Math.min(255, color2.getRed() + 35), Math.min(255, color2.getRed() + 35), Math.min(255, color2.getBlue() + 35));
    return color1b;
  }

}
