/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

/**
 * The Class HeaderIcon.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class HeaderIcon implements Icon {
  /** The Constant NONE. */
  public static final int NONE      = 0;
  
  /** The Constant DECENDING. */
  public static final int DECENDING = 1;
  
  /** The Constant ASCENDING. */
  public static final int ASCENDING = 2;

  private int             _direction;
  private int             _width    = 8;
  private int             _height   = 8;

  /**
   * Instantiates a new header icon.
   *
   * @param direction int
   */
  public HeaderIcon(int direction) {
    _direction = direction;
  }

  /**
   * Gets the icon width.
   *
   * @return int
   */
  public int getIconWidth() {return _width;}

  /**
   * Gets the icon height.
   *
   * @return int
   */
  public int getIconHeight() {return _height;}

  /**
   * Paint icon.
   *
   * @param c the c
   * @param g the g
   * @param x the x
   * @param y the y
   * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics, int, int)
   */
  @Override
  public void paintIcon(Component c, Graphics g, int x, int y) {
    Color color1 = c.getBackground();
    Color color2 = color1.brighter();
    Color color3 = color1.darker();

    int w = _width;
    int h = _height;
    int k = w / 2;
    if (_direction == ASCENDING) {
      g.setColor(color3);
      g.drawLine(x, y, x + w, y);
      g.drawLine(x, y, x + k, y + h);
      g.setColor(color2);
      g.drawLine(x + w, y, x + k, y + h);
    }
    if (_direction != DECENDING) {
      return;
    }
    g.setColor(color3);
    g.drawLine(x + k, y, x, y + h);
    g.setColor(color2);
    g.drawLine(x, y + h, x + w, y + h);
    g.drawLine(x + k, y, x + w, y + h);
  }
}
