/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.table;

import javax.swing.table.DefaultTableCellRenderer;

/**
 * The Class JNPadDefaultTableCellRenderer.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class JNPadDefaultTableCellRenderer extends DefaultTableCellRenderer {
  /** The tooltip enabled. */
  private boolean           tooltipEnabled   = true;

  /** UID. */
  private static final long serialVersionUID = -7297590779467446738L;

  /**
   * Instantiates a new jNPad's default table cell renderer.
   */
  public JNPadDefaultTableCellRenderer() {
    super();
  }

  /**
   * Instantiates a new jNPad's default table cell renderer.
   *
   * @param halignment the halignment
   */
  public JNPadDefaultTableCellRenderer(int halignment) {
    setHorizontalAlignment(halignment);
  }

  /**
   * Instantiates a new jNPad's default table cell renderer.
   *
   * @param halignment the halignment
   * @param valignment the valignment
   */
  public JNPadDefaultTableCellRenderer(int halignment, int valignment) {
    setHorizontalAlignment(halignment);
    setVerticalAlignment(valignment);
  }

  /**
   * Instantiates a new jNPad's default table cell renderer.
   *
   * @param tooltipEnabled the tooltip enabled
   */
  public JNPadDefaultTableCellRenderer(boolean tooltipEnabled) {
    this();
    this.tooltipEnabled = tooltipEnabled;
  }

  /**
   * Instantiates a new jNPad's default table cell renderer.
   *
   * @param halignment the halignment
   * @param tooltipEnabled the tooltip enabled
   */
  public JNPadDefaultTableCellRenderer(int halignment, boolean tooltipEnabled) {
    this(halignment);
    this.tooltipEnabled = tooltipEnabled;
  }

  /**
   * Instantiates a new jNPad's default table cell renderer.
   *
   * @param halignment the halignment
   * @param valignment the valignment
   * @param tooltipEnabled the tooltip enabled
   */
  public JNPadDefaultTableCellRenderer(int halignment, int valignment, boolean tooltipEnabled) {
    this(halignment, valignment);
    this.tooltipEnabled = tooltipEnabled;
  }

  /**
   * Sets the value.
   *
   * @param value the new value
   * @see javax.swing.table.DefaultTableCellRenderer#setValue(java.lang.Object)
   */
  @Override
  protected void setValue(Object value) {
    TableUtilities.setValue(this, value, tooltipEnabled);
  }

  /**
   * Checks if is tooltip enabled.
   *
   * @return true, if is tooltip enabled
   */
  public boolean isTooltipEnabled() {
    return tooltipEnabled;
  }

  /**
   * Sets the tooltip enabled.
   *
   * @param tooltipEnabled the new tooltip enabled
   */
  public void setTooltipEnabled(boolean tooltipEnabled) {
    this.tooltipEnabled = tooltipEnabled;
  }

} // fin de JNPadDefaultTableCellRenderer
