/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * The Class Version.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class Version {
  /** The release number. */
  private static final int    RELEASE_NUMBER        = 0;

  /** The major revision number. */
  private static final int    MAJOR_REVISION_NUMBER = 3;

  /** The minor revision number. */
  private static int          MINOR_REVISION_NUMBER = -1;

  /** The Constant VERSION. */
  private static final String VERSION               = findVersion("version.txt"); //$NON-NLS-1$

  /** no instances */
  private Version() {
    super();
  }

  /**
   * Find version.
   *
   * @param fileName String
   * @return String
   */
  private static String findVersion(String fileName) {
    BufferedReader in = null;
    try {
      StringWriter writer = new StringWriter();
      PrintWriter out = new PrintWriter(writer);

      in = new BufferedReader(new InputStreamReader(new FileInputStream(fileName), "UTF-8")); //$NON-NLS-1$

      String line;
      while ((line = in.readLine()) != null) {
        out.println(line);
      }

      out.flush();

      return writer.toString();
    }
    catch (Exception ex) {
      return null;
    }
    finally {
      try {
        if (in != null) {
          in.close();
        }
      }
      catch (IOException ex) {
        //ignored
      }
    }
  }

  /**
   * Gets the version.
   *
   * @return String
   */
  public static String getVersion() {
    if (VERSION != null) {
      return VERSION;
    }

    StringBuilder sb = new StringBuilder()
        .append(RELEASE_NUMBER)
        .append(".") //$NON-NLS-1$
        .append(MAJOR_REVISION_NUMBER);

    if (MINOR_REVISION_NUMBER != -1) {
      sb.append(".").append(MINOR_REVISION_NUMBER); //$NON-NLS-1$
    }

    return sb.toString();
  }

}
