/*
 * Decompiled with CFR 0.152.
 */
package InnoBarBean;

import InnoBarBean.InnoBarButton;
import InnoBarBean.InnoBarCustomize;
import InnoBarBean.MsgPopUp;
import InnoBarBean.PopFileReader;
import InnoBarBean.PopFileWriter;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class InnoBar
extends Panel
implements Runnable,
MouseMotionListener,
MouseListener {
    private static final String COPYRIGHT = new String("(c)1997, InnoVal Systems Solutions, Inc., Harrison, New York");
    private static final String VERSION = new String("InnoBar Version 1.1");
    public static final int NONE = 0;
    public static final int SINGLE = 1;
    public static final int DOUBLE = 2;
    public static final int TRIPLE = 3;
    public static final int NO_FRAME = 0;
    public static final int DASH_FRAME = 1;
    public static final int SOLID_FRAME = 2;
    public static final int CORNER_FRAME = 3;
    public static final int LINES = 1;
    public static final int SOLID = 2;
    private int mouseDefault = 0;
    private int lastDefault = 1;
    private int buttonDefault = 2;
    private boolean allowMoveDefault = true;
    private boolean bubbleHelpDefault = true;
    private MsgPopUp mPu = null;
    private Thread m_thread = null;
    private boolean bubbleHelpEnabled = true;
    private int mForThread = -1;
    private int mPuInitialDelay = 1000;
    private int mPuNextDelay = 30;
    private int mPuDelay = this.mPuInitialDelay;
    private int msgBoxVOffset = 25;
    private int msgBoxHOffset = 15;
    private Color bubbleHelpForeground = Color.black;
    private Color bubbleHelpBackground = new Color(255, 255, 192);
    private Vector tbButtons = new Vector(10, 10);
    private int barWidth = 0;
    private int barHeight = 0;
    private Frame parent = null;
    private Image image = null;
    private Image off = null;
    private Point where = new Point(0, 0);
    private Graphics offg;
    private String fileName = null;
    private String label = "InnoBar";
    private String actionCommand = "InnoBar";
    private URL url;
    private boolean toolbarEnabled = false;
    private boolean allowUserCustomize = false;
    private boolean allowUserButtonMove = true;
    File userAttributeFile = null;
    transient ActionListener actionListener;
    private int buttonBorder = 2;
    private int lastClickedBorderStyle = 1;
    private int mouseOverBorder = 0;
    private int buttonDisabledStyle = 1;
    private int mouseOverIndex = -1;
    private int oldMouseOverIndex = -1;
    private int lastButtonClickedIndex = -1;
    private int lastButtonDownIndex = -1;
    private int focusIndex = -1;
    private Color colorTopOuterUp = Color.white;
    private Color colorTopInnerUp = Color.white;
    private Color colorBottomOuterUp = Color.black;
    private Color colorBottomInnerUp = Color.gray;
    private Color colorTopOuterDown = Color.black;
    private Color colorTopInnerDown = Color.gray;
    private Color colorBottomOuterDown = Color.white;
    private Color colorBottomInnerDown = Color.white;
    private Color colorLastClicked = Color.gray;
    private Color colorDisabled = Color.lightGray;
    private Color colorHidden = Color.lightGray;

    public boolean isToolBarEnabled() {
        return this.toolbarEnabled;
    }

    public void setToolBarEnabled(boolean val) {
        this.toolbarEnabled = val;
    }

    public void update() {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        try {
            this.mPuDelay = this.mPuInitialDelay;
            ((Component)this.mPu).setVisible(false);
            this.mouseOverIndex = -1;
            if (this.validButton(this.lastButtonDownIndex)) {
                if (this.isButtonDown(this.lastButtonDownIndex) || this.isButtonToggle(this.lastButtonDownIndex)) {
                    this.setButtonDown(this.lastButtonDownIndex, !this.isButtonDown(this.lastButtonDownIndex));
                }
                this.lastButtonDownIndex = -1;
            }
            this.where.x = 0;
            this.where.y = 0;
            this.paint(this.getGraphics());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mouseMoved(MouseEvent e) {
        try {
            this.oldMouseOverIndex = this.mouseOverIndex;
            this.mouseOverIndex = this.findButton(e.getX(), e.getY());
            if (this.validButton(this.mouseOverIndex)) {
                if (this.mouseOverIndex != this.oldMouseOverIndex) {
                    if (this.m_thread != null) {
                        this.m_thread.stop();
                    }
                    this.mForThread = this.mouseOverIndex;
                    ((Component)this.mPu).setVisible(false);
                    this.startNewThread();
                    this.where.x = this.getButtonX1(this.mouseOverIndex);
                    this.where.y = this.getButtonY2(this.mouseOverIndex);
                }
            } else {
                if (this.m_thread != null) {
                    this.m_thread.stop();
                }
                ((Component)this.mPu).setVisible(false);
                this.mouseOverIndex = -1;
            }
            this.paint(this.getGraphics());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mousePressed(MouseEvent e) {
        int button;
        if (e.getClickCount() == 1 && e.getModifiers() != 4 && this.validButton(button = this.findButton(e.getX(), e.getY())) && !this.isButtonDisabled(button)) {
            ((Component)this.mPu).setVisible(false);
            this.mPuDelay = this.mPuInitialDelay;
            this.lastButtonDownIndex = button;
            this.setButtonDown(this.lastButtonDownIndex, !this.isButtonDown(this.lastButtonDownIndex));
            this.paint(this.getGraphics());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() == 1) {
            if (this.m_thread != null) {
                try {
                    this.m_thread.stop();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            if (e.getModifiers() == 4) {
                if (this.validButton(this.lastButtonDownIndex)) {
                    this.setButtonDown(this.lastButtonDownIndex, !this.isButtonDown(this.lastButtonDownIndex));
                    this.paint(this.getGraphics());
                }
                if (this.allowUserCustomize) {
                    InnoBarCustomize userCustomize = new InnoBarCustomize(this);
                    userCustomize.show();
                    this.saveAttributes();
                }
            } else {
                int button = this.findButton(e.getX(), e.getY());
                if (button >= 0 && button == this.lastButtonDownIndex) {
                    this.lastButtonClickedIndex = button;
                    if (this.getButtonToggleGroup(this.lastButtonClickedIndex) > 0) {
                        for (int i = 0; i < this.tbButtons.size(); ++i) {
                            if (this.getButtonToggleGroup(i) != this.getButtonToggleGroup(this.lastButtonClickedIndex)) continue;
                            this.setButtonDown(i, false);
                        }
                        this.setButtonDown(this.lastButtonClickedIndex, true);
                    }
                    if (!this.isButtonToggle(this.lastButtonClickedIndex)) {
                        this.setButtonDown(this.lastButtonClickedIndex, !this.isButtonDown(this.lastButtonClickedIndex));
                    }
                    this.paint(this.getGraphics());
                    this.triggerActionEvent();
                } else {
                    if (!this.validButton(button)) {
                        button = this.getNearestButton(e.getX(), e.getY());
                    }
                    this.mouseOverIndex = button;
                    if (this.validButton(this.lastButtonDownIndex)) {
                        this.setButtonDown(this.lastButtonDownIndex, !this.isButtonDown(this.lastButtonDownIndex));
                        if (this.allowUserCustomize && this.allowUserButtonMove) {
                            InnoBarButton moveButton = (InnoBarButton)this.tbButtons.elementAt(this.lastButtonDownIndex);
                            this.tbButtons.removeElementAt(this.lastButtonDownIndex);
                            this.tbButtons.insertElementAt(moveButton, button);
                            this.shuffleButtonPositions(this.lastButtonDownIndex, button);
                        }
                    }
                    if (this.validButton(this.mouseOverIndex)) {
                        this.paint(this.getGraphics());
                    }
                }
                this.lastButtonDownIndex = -1;
            }
        }
    }

    private void shuffleButtonPositions(int oldLocation, int newLocation) {
        String direction = oldLocation > newLocation ? "left" : "right";
        int startPos = oldLocation > newLocation ? newLocation : oldLocation;
        int endPos = oldLocation < newLocation ? newLocation : oldLocation;
        int i = 0;
        if (direction.equals("left")) {
            InnoBarButton thisButton;
            InnoBarButton holdButton = (InnoBarButton)this.tbButtons.elementAt(startPos);
            int holdx1 = holdButton.buttonx1;
            int holdy1 = holdButton.buttony1;
            for (i = startPos; i < endPos; ++i) {
                thisButton = (InnoBarButton)this.tbButtons.elementAt(i);
                InnoBarButton nextButton = (InnoBarButton)this.tbButtons.elementAt(i + 1);
                thisButton.buttonx1 = nextButton.buttonx1;
                thisButton.buttony1 = nextButton.buttony1;
                thisButton.buttonx2 = thisButton.buttonx1 + thisButton.buttonw - 1;
                thisButton.buttony2 = thisButton.buttony1 + thisButton.buttonh - 1;
                this.tbButtons.setElementAt(thisButton, i);
            }
            thisButton = (InnoBarButton)this.tbButtons.elementAt(endPos);
            thisButton.buttonx1 = holdx1;
            thisButton.buttony1 = holdy1;
            thisButton.buttonx2 = thisButton.buttonx1 + thisButton.buttonw - 1;
            thisButton.buttony2 = thisButton.buttony1 + thisButton.buttonh - 1;
            this.tbButtons.setElementAt(thisButton, endPos);
        } else {
            InnoBarButton thisButton;
            InnoBarButton holdButton = (InnoBarButton)this.tbButtons.elementAt(endPos);
            int holdx1 = holdButton.buttonx1;
            int holdy1 = holdButton.buttony1;
            for (i = endPos; i > startPos; --i) {
                thisButton = (InnoBarButton)this.tbButtons.elementAt(i);
                InnoBarButton nextButton = (InnoBarButton)this.tbButtons.elementAt(i - 1);
                thisButton.buttonx1 = nextButton.buttonx1;
                thisButton.buttony1 = nextButton.buttony1;
                thisButton.buttonx2 = thisButton.buttonx1 + thisButton.buttonw - 1;
                thisButton.buttony2 = thisButton.buttony1 + thisButton.buttonh - 1;
                this.tbButtons.setElementAt(thisButton, i);
            }
            thisButton = (InnoBarButton)this.tbButtons.elementAt(startPos);
            thisButton.buttonx1 = holdx1;
            thisButton.buttony1 = holdy1;
            thisButton.buttonx2 = thisButton.buttonx1 + thisButton.buttonw - 1;
            thisButton.buttony2 = thisButton.buttony1 + thisButton.buttonh - 1;
            this.tbButtons.setElementAt(thisButton, startPos);
        }
    }

    public void moveButtonOnePosition(int buttonIndex, int direction) {
        if (direction > 1) {
            direction = 1;
        }
        if (direction < 1) {
            direction = -1;
        }
        InnoBarButton moveButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
        this.tbButtons.removeElementAt(buttonIndex);
        this.tbButtons.insertElementAt(moveButton, buttonIndex + direction);
        this.shuffleButtonPositions(buttonIndex, buttonIndex + direction);
    }

    private int findButton(int x, int y) {
        int ind = -1;
        for (int i = 0; i < this.tbButtons.size(); ++i) {
            if (!(x > this.getButtonX1(i) & x < this.getButtonX1(i) + this.getButtonWidth(i) & y > this.getButtonY1(i) & y < this.getButtonY1(i) + this.getButtonHeight(i))) continue;
            if (this.isButtonHidden(i)) break;
            ind = i;
            break;
        }
        return ind;
    }

    private int getNearestButton(int x, int y) {
        int ind = 0;
        for (int i = 0; i < this.tbButtons.size(); ++i) {
            if (x <= this.getButtonX1(i) || y <= this.getButtonY1(i) || this.isButtonHidden(i)) continue;
            ind = i;
        }
        return ind;
    }

    private boolean validButton(int button) {
        boolean ret_code = false;
        if (button >= 0 && button < this.tbButtons.size()) {
            ret_code = true;
        }
        return ret_code;
    }

    public String version() {
        return VERSION;
    }

    public String Copyright() {
        return COPYRIGHT;
    }

    public void clearButtons() {
        for (int i = 0; i < this.tbButtons.size(); ++i) {
            this.setButtonWidth(i, 0);
        }
    }

    public void resetToolBar() {
        this.tbButtons.removeAllElements();
        this.tbButtons = new Vector(10, 10);
    }

    public void defineButton(int button, int x, int y, int w, int h) {
        InnoBarButton newbutton = new InnoBarButton();
        newbutton.buttonNumber = button;
        newbutton.buttonx1 = x;
        newbutton.buttony1 = y;
        newbutton.buttonh = h;
        newbutton.buttonw = w;
        newbutton.buttonx2 = x + w - 1;
        newbutton.buttony2 = y + h - 1;
        newbutton.buttonToggle = false;
        newbutton.buttonDown = false;
        newbutton.buttonDisabledLocked = false;
        newbutton.buttonDisabledUser = false;
        newbutton.buttonHiddenLocked = false;
        newbutton.buttonHiddenUser = false;
        if (newbutton.buttonx2 > this.barWidth) {
            this.barWidth = newbutton.buttonx2;
        }
        if (newbutton.buttony2 > this.barHeight) {
            this.barHeight = newbutton.buttony2;
        }
        this.tbButtons.addElement(newbutton);
    }

    public void defineButton(int[][] xywh) {
        for (int i = 0; i < xywh.length; ++i) {
            this.defineButton(i, xywh[i][0], xywh[i][1], xywh[i][2], xywh[i][3]);
        }
    }

    public void defineButton(int[] arrayX, int y, int w, int h) {
        for (int i = 0; i < arrayX.length; ++i) {
            this.defineButton(i, arrayX[i], y, w, h);
        }
    }

    public void setButtonPrimaryImage(int button, int x, int y) {
        InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(button);
        updateButton.primaryDx = x;
        updateButton.primaryDy = y;
        this.tbButtons.setElementAt(updateButton, button);
    }

    public void setButtonPrimaryImage(int[] arrayX, int y) {
        for (int i = 0; i < arrayX.length; ++i) {
            this.setButtonPrimaryImage(i, arrayX[i], y);
        }
    }

    public void setButtonPrimaryImage(int[][] xy) {
        for (int i = 0; i < xy.length; ++i) {
            this.setButtonPrimaryImage(i, xy[i][0], xy[i][1]);
        }
    }

    public void setButtonMouseOverImage(int button, int x, int y) {
        InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(button);
        updateButton.mouseOverDx = x;
        updateButton.mouseOverDy = y;
        this.tbButtons.setElementAt(updateButton, button);
    }

    public void setButtonMouseOverImage(int[] arrayX, int y) {
        for (int i = 0; i < arrayX.length; ++i) {
            this.setButtonMouseOverImage(i, arrayX[i], y);
        }
    }

    public void setButtonMouseOverImage(int[][] xy) {
        for (int i = 0; i < xy.length; ++i) {
            this.setButtonMouseOverImage(i, xy[i][0], xy[i][1]);
        }
    }

    public void setButtonClickedImage(int button, int x, int y) {
        InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(button);
        updateButton.mouseDownDx = x;
        updateButton.mouseDownDy = y;
        this.tbButtons.setElementAt(updateButton, button);
    }

    public void setButtonClickedImage(int[] arrayX, int y) {
        for (int i = 0; i < arrayX.length; ++i) {
            this.setButtonClickedImage(i, arrayX[i], y);
        }
    }

    public void setButtonClickedImage(int[][] xy) {
        for (int i = 0; i < xy.length; ++i) {
            this.setButtonClickedImage(i, xy[i][0], xy[i][1]);
        }
    }

    public void setButtonLastClickedImage(int button, int x, int y) {
        InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(button);
        updateButton.lastClickedDx = x;
        updateButton.lastClickedDy = y;
        this.tbButtons.setElementAt(updateButton, button);
    }

    public void setButtonLastClickedImage(int[] arrayX, int y) {
        for (int i = 0; i < arrayX.length; ++i) {
            this.setButtonLastClickedImage(i, arrayX[i], y);
        }
    }

    public void setButtonLastClickedImage(int[][] xy) {
        for (int i = 0; i < xy.length; ++i) {
            this.setButtonLastClickedImage(i, xy[i][0], xy[i][1]);
        }
    }

    public void setButtonDisabledImage(int button, int x, int y) {
        InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(button);
        updateButton.disabledDx = x;
        updateButton.disabledDy = y;
        this.tbButtons.setElementAt(updateButton, button);
    }

    public void setButtonDisabledImage(int[] arrayX, int y) {
        for (int i = 0; i < arrayX.length; ++i) {
            this.setButtonDisabledImage(i, arrayX[i], y);
        }
    }

    public void setButtonDisabledImage(int[][] xy) {
        for (int i = 0; i < xy.length; ++i) {
            this.setButtonDisabledImage(i, xy[i][0], xy[i][1]);
        }
    }

    public boolean setBubbleHelpEnabled(boolean val) {
        boolean ret_code = true;
        if (this.toolbarEnabled && this.parent == null) {
            ret_code = false;
            this.bubbleHelpEnabled = false;
        } else {
            this.bubbleHelpEnabled = val;
        }
        return ret_code;
    }

    public void setBubbleHelpInitialDelay(int val) {
        this.mPuInitialDelay = val;
    }

    public void setBubbleHelpNextDelay(int val) {
        this.mPuNextDelay = val;
    }

    public void setBubbleHelpForegroundColor(Color newColor) {
        this.bubbleHelpForeground = newColor;
    }

    public void setBubbleHelpBackgroundColor(Color newColor) {
        this.bubbleHelpBackground = newColor;
    }

    public void setButtonBorder(int thickness) {
        this.buttonBorder = thickness < 0 ? 0 : (thickness > 3 ? 3 : thickness);
        this.paint(this.getGraphics());
    }

    public void setLastClickedBorderStyle(int style) {
        this.lastClickedBorderStyle = style;
        this.paint(this.getGraphics());
    }

    public void setDisabledStyle(int style) {
        this.buttonDisabledStyle = style;
    }

    public void setMouseOverBorder(int style) {
        this.mouseOverBorder = style;
    }

    public void setColorTopOuterUp(Color newColor) {
        this.colorTopOuterUp = newColor;
    }

    public void setColorTopInnerUp(Color newColor) {
        this.colorTopInnerUp = newColor;
    }

    public void setColorBottomOuterUp(Color newColor) {
        this.colorBottomOuterUp = newColor;
    }

    public void setColorBottomInnerUp(Color newColor) {
        this.colorBottomInnerUp = newColor;
    }

    public void setColorTopOuterDown(Color newColor) {
        this.colorTopOuterDown = newColor;
    }

    public void setColorTopInnerDown(Color newColor) {
        this.colorTopInnerDown = newColor;
    }

    public void setColorBottomOuterDown(Color newColor) {
        this.colorBottomOuterDown = newColor;
    }

    public void setColorBottomInnerDown(Color newColor) {
        this.colorBottomInnerDown = newColor;
    }

    public void setColorLastClicked(Color newColor) {
        this.colorLastClicked = newColor;
    }

    public void setColorDisabled(Color newColor) {
        this.colorDisabled = newColor;
    }

    public void setColorHidden(Color newColor) {
        this.colorHidden = newColor;
    }

    public void setButtonTag(int buttonIndex, String tag) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            updateButton.buttonTag = tag;
            if (updateButton.origButtonTag == null) {
                updateButton.origButtonTag = tag;
            }
            this.tbButtons.setElementAt(updateButton, buttonIndex);
        }
    }

    public void setButtonTag(String[] array) {
        for (int i = 0; i < array.length && i < this.tbButtons.size(); ++i) {
            this.setButtonTag(i, array[i]);
        }
    }

    public void setButtonToggle(int buttonIndex, boolean code) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            updateButton.buttonToggle = code;
            this.tbButtons.setElementAt(updateButton, buttonIndex);
        }
    }

    public void setButtonToggleGroup(int buttonIndex, int group) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            updateButton.toggleGroup = group;
            this.tbButtons.setElementAt(updateButton, buttonIndex);
        }
    }

    public void setButtonWidth(int buttonIndex, int width) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            updateButton.buttonw = width;
            this.tbButtons.setElementAt(updateButton, buttonIndex);
        }
    }

    public void setDisabled(int buttonIndex, boolean value) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            if (!updateButton.buttonDisabledLocked) {
                updateButton.buttonDisabledUser = value;
                this.tbButtons.setElementAt(updateButton, buttonIndex);
                this.paint(this.getGraphics());
            }
        }
    }

    public void setDisabledLocked(int buttonIndex, boolean value) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            updateButton.buttonDisabledLocked = value;
            updateButton.buttonDisabledUser = value;
            this.tbButtons.setElementAt(updateButton, buttonIndex);
            this.paint(this.getGraphics());
        }
    }

    private void setButtonDown(int button, boolean value) {
        InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(button);
        updateButton.buttonDown = value;
        this.tbButtons.setElementAt(updateButton, button);
    }

    public void setHidden(int buttonIndex, boolean value) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            if (!updateButton.buttonHiddenLocked) {
                updateButton.buttonHiddenUser = value;
                this.tbButtons.setElementAt(updateButton, buttonIndex);
                this.paint(this.getGraphics());
            }
        }
    }

    public void setHiddenLocked(int buttonIndex, boolean value) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton updateButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            updateButton.buttonHiddenLocked = value;
            updateButton.buttonHiddenUser = value;
            this.tbButtons.setElementAt(updateButton, buttonIndex);
            this.paint(this.getGraphics());
        }
    }

    public boolean Enable() {
        return this.Enable(0, 0);
    }

    public boolean Enable(int width, int height) {
        boolean ret_code = false;
        this.toolbarEnabled = false;
        if (this.image != null) {
            int w = this.image.getWidth(this);
            int h = this.image.getHeight(this);
            if (width > w) {
                w = width;
            }
            if (height > h) {
                h = height;
            }
            this.off = null;
            this.off = this.createImage(w, h);
            if (this.off != null) {
                this.offg = this.off.getGraphics();
            }
            if (this.offg != null) {
                ret_code = true;
            }
        }
        if (ret_code) {
            Container frame;
            this.toolbarEnabled = true;
            this.removeMouseListener(this);
            this.addMouseListener(this);
            this.removeMouseMotionListener(this);
            this.addMouseMotionListener(this);
            for (frame = this.getParent(); frame != null && !(frame instanceof Frame); frame = frame.getParent()) {
            }
            if (frame != null) {
                this.parent = (Frame)frame;
                this.mPu = new MsgPopUp(this.parent);
                ((Component)this.mPu).setSize(1, 1);
            } else {
                this.bubbleHelpEnabled = false;
            }
            this.mouseDefault = this.mouseOverBorder;
            this.lastDefault = this.lastClickedBorderStyle;
            this.buttonDefault = this.buttonBorder;
            this.allowMoveDefault = this.allowUserButtonMove;
            this.bubbleHelpDefault = this.bubbleHelpEnabled;
            if (this.isUserCustomizeEnabled()) {
                this.restoreAttributes();
            }
            this.repaint();
        } else {
            System.out.println("Toolbar could not be enabled.");
        }
        return ret_code;
    }

    public void setImageFileName(String str) {
        try {
            this.fileName = str;
            this.setImageURL(new URL(this.fileName));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.paint(this.getGraphics());
    }

    public void setImageURL(URL aUrl) {
        this.url = aUrl;
        this.fileName = null;
        Image loadedImage = this.getToolkit().getImage(this.url);
        if (loadedImage != null) {
            this.setImage(loadedImage);
            this.paint(this.getGraphics());
        }
    }

    public void setImage(Image img) {
        block2: {
            this.fileName = null;
            this.image = img;
            if (img == null) break block2;
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.image, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void userCustomizeEnable(File attrFile) {
        this.allowUserCustomize = true;
        this.userAttributeFile = attrFile;
    }

    public void userCustomizeDisable() {
        this.allowUserCustomize = false;
    }

    public void setUserButtonMoveEnabled(boolean val) {
        this.allowUserButtonMove = val;
    }

    public void restoreDefaults() {
        int i = 0;
        this.mouseOverBorder = this.mouseDefault;
        this.lastClickedBorderStyle = this.lastDefault;
        this.buttonBorder = this.buttonDefault;
        this.allowUserButtonMove = this.allowMoveDefault;
        this.bubbleHelpEnabled = this.bubbleHelpDefault;
        String[] buttonPositions = new String[this.tbButtons.size()];
        for (i = 0; i < this.tbButtons.size(); ++i) {
            InnoBarButton button = (InnoBarButton)this.tbButtons.elementAt(i);
            button.buttonDisabledUser = false;
            button.buttonHiddenUser = false;
            button.buttonTag = button.origButtonTag;
            this.tbButtons.setElementAt(button, i);
            buttonPositions[i] = String.valueOf(button.buttonNumber);
        }
        this.restoreButtonPositions(buttonPositions);
    }

    public void restoreAttributes() {
        String[] buttonPositions = new String[]{};
        String inString = new String();
        String value = new String();
        int i = 0;
        int pos = 0;
        int index = 0;
        PopFileReader attrFile = new PopFileReader();
        if (attrFile.open(this.userAttributeFile)) {
            inString = attrFile.lineIn();
            if (inString != null) {
                buttonPositions = new String[this.tbButtons.size()];
            }
            while (inString != null) {
                if (inString.startsWith("BB: ")) {
                    value = inString.substring(4);
                    this.setButtonBorder(Integer.valueOf(value));
                } else if (inString.startsWith("MB: ")) {
                    value = inString.substring(4);
                    this.setMouseOverBorder(Integer.valueOf(value));
                } else if (inString.startsWith("LB: ")) {
                    value = inString.substring(4);
                    this.setLastClickedBorderStyle(Integer.valueOf(value));
                } else if (inString.startsWith("AM: ")) {
                    value = inString.substring(4);
                    this.setUserButtonMoveEnabled(Boolean.valueOf(value));
                } else if (inString.startsWith("HE: ")) {
                    value = inString.substring(4);
                    this.setBubbleHelpEnabled(Boolean.valueOf(value));
                } else if (inString.startsWith("BA: ")) {
                    inString = inString.substring(4);
                    i = 0;
                    while ((index = inString.indexOf(",")) >= 0) {
                        value = inString.substring(0, index);
                        switch (++i) {
                            case 1: {
                                buttonPositions[pos] = value.trim();
                                break;
                            }
                            case 2: {
                                if (!this.validButton(pos) || !value.equals("true") && !value.equals("false")) break;
                                this.setDisabled(pos, Boolean.valueOf(value));
                                break;
                            }
                            case 3: {
                                if (!this.validButton(pos) || !value.equals("true") && !value.equals("false")) break;
                                this.setHidden(pos, Boolean.valueOf(value));
                            }
                        }
                        inString = inString.substring(index + 1);
                    }
                    if (inString.trim().length() > 0 && this.validButton(pos) && i == 3) {
                        this.setButtonTag(pos, inString.trim());
                    }
                    ++pos;
                }
                inString = attrFile.lineIn();
            }
            attrFile.close();
            this.restoreButtonPositions(buttonPositions);
        }
    }

    public void restoreButtonPositions(String[] buttonPositions) {
        int i = 0;
        int j = 0;
        if (buttonPositions.length > 0 && buttonPositions[0] != null) {
            Vector<InnoBarButton> holdButtons = new Vector<InnoBarButton>(this.tbButtons.size(), 1);
            InnoBarButton moveButton = new InnoBarButton();
            int[][] buttonIndexations = new int[this.tbButtons.size()][2];
            for (i = 0; i < this.tbButtons.size(); ++i) {
                moveButton = (InnoBarButton)this.tbButtons.elementAt(i);
                holdButtons.addElement(moveButton);
                buttonIndexations[i][0] = moveButton.buttonx1;
                buttonIndexations[i][1] = moveButton.buttony1;
            }
            for (i = 0; i < this.tbButtons.size(); ++i) {
                j = Integer.valueOf(buttonPositions[i]);
                moveButton = (InnoBarButton)this.tbButtons.elementAt(i);
                if (i != j) {
                    moveButton.buttonx1 = buttonIndexations[j][0];
                    moveButton.buttony1 = buttonIndexations[j][1];
                    moveButton.buttonx2 = moveButton.buttonx1 + moveButton.buttonw - 1;
                    moveButton.buttony2 = moveButton.buttony1 + moveButton.buttonh - 1;
                }
                holdButtons.setElementAt(moveButton, j);
            }
            this.tbButtons = holdButtons;
            this.paint(this.getGraphics());
        }
    }

    private void saveAttributes() {
        int i = 0;
        String[] buttonPositions = new String[this.tbButtons.size()];
        PopFileWriter attrFile = new PopFileWriter();
        attrFile.open(this.userAttributeFile);
        attrFile.lineOut(String.valueOf(String.valueOf("BB: ").concat(String.valueOf(this.getButtonBorder()))).concat(String.valueOf("\n")));
        attrFile.lineOut(String.valueOf(String.valueOf("MB: ").concat(String.valueOf(this.getMouseOverBorder()))).concat(String.valueOf("\n")));
        attrFile.lineOut(String.valueOf(String.valueOf("LB: ").concat(String.valueOf(this.getLastClickedBorderStyle()))).concat(String.valueOf("\n")));
        attrFile.lineOut(String.valueOf(String.valueOf("AM: ").concat(String.valueOf(this.isUserButtonMoveEnabled()))).concat(String.valueOf("\n")));
        attrFile.lineOut(String.valueOf(String.valueOf("HE: ").concat(String.valueOf(this.isBubbleHelpEnabled()))).concat(String.valueOf("\n")));
        for (i = 0; i < this.tbButtons.size(); ++i) {
            InnoBarButton holdButton = (InnoBarButton)this.tbButtons.elementAt(i);
            InnoBarButton getButton = (InnoBarButton)this.tbButtons.elementAt(holdButton.buttonNumber);
            buttonPositions[holdButton.buttonNumber] = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("BA: ").concat(String.valueOf(String.valueOf(i)))).concat(String.valueOf(","))).concat(String.valueOf(holdButton.buttonDisabledUser))).concat(String.valueOf(","))).concat(String.valueOf(holdButton.buttonHiddenUser))).concat(String.valueOf(","))).concat(String.valueOf(holdButton.buttonTag));
        }
        for (i = 0; i < buttonPositions.length; ++i) {
            attrFile.lineOut(String.valueOf(buttonPositions[i]).concat(String.valueOf("\n")));
        }
        attrFile.close();
    }

    public void setButtonClicked(int buttonNum) {
        int button = this.getButtonIndex(buttonNum);
        if (this.validButton(button) && !this.isButtonDisabled(button)) {
            this.lastButtonDownIndex = button;
            this.lastButtonClickedIndex = button;
            this.setButtonDown(this.lastButtonClickedIndex, !this.isButtonDown(this.lastButtonClickedIndex));
            if (this.getButtonToggleGroup(this.lastButtonClickedIndex) > 0) {
                for (int i = 0; i < this.tbButtons.size(); ++i) {
                    if (this.getButtonToggleGroup(i) != this.getButtonToggleGroup(this.lastButtonClickedIndex)) continue;
                    this.setButtonDown(i, false);
                }
                this.setButtonDown(this.lastButtonClickedIndex, true);
            }
            if (!this.isButtonToggle(this.lastButtonClickedIndex)) {
                this.setButtonDown(this.lastButtonClickedIndex, false);
            }
            this.paint(this.getGraphics());
            this.triggerActionEvent();
            this.lastButtonDownIndex = -1;
        }
    }

    public void setButtonMouseOver(int buttonNum) {
        int button = this.getButtonIndex(buttonNum);
        if (!this.isButtonDisabled(button) && !this.isButtonHidden(button)) {
            this.mouseOverIndex = button;
            this.paint(this.getGraphics());
        }
    }

    public int getButtonX1(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.buttonx1;
        }
        return -1;
    }

    public int getButtonY1(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.buttony1;
        }
        return -1;
    }

    public int getButtonX2(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.buttonx2;
        }
        return -1;
    }

    public int getButtonY2(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.buttony2;
        }
        return -1;
    }

    public int getButtonPrimaryDx(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.primaryDx;
        }
        return -1;
    }

    public int getButtonPrimaryDy(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.primaryDy;
        }
        return -1;
    }

    public int getButtonDisabledDx(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.disabledDx;
        }
        return -1;
    }

    public int getButtonDisabledDy(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.disabledDy;
        }
        return -1;
    }

    public int getButtonMouseOverDx(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.mouseOverDx;
        }
        return -1;
    }

    public int getButtonMouseOverDy(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.mouseOverDy;
        }
        return -1;
    }

    public int getButtonMouseDownDx(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.mouseDownDx;
        }
        return -1;
    }

    public int getButtonMouseDownDy(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.mouseDownDy;
        }
        return -1;
    }

    public int getButtonLastClickedDx(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.lastClickedDx;
        }
        return -1;
    }

    public int getButtonLastClickedDy(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.lastClickedDy;
        }
        return -1;
    }

    public int getButtonHeight(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.buttonh;
        }
        return -1;
    }

    public int getButtonWidth(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.buttonw;
        }
        return -1;
    }

    public int getButtonToggleGroup(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.toggleGroup;
        }
        return -1;
    }

    public int getButtonNumber(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.buttonNumber;
        }
        return -1;
    }

    public int getButtonIndex(int buttonNum) {
        int i = 0;
        for (i = 0; i < this.tbButtons.size(); ++i) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(i);
            if (checkButton.buttonNumber != buttonNum) continue;
            return i;
        }
        return -1;
    }

    public int getButtonClicked() {
        if (this.validButton(this.lastButtonClickedIndex)) {
            InnoBarButton clickedButton = (InnoBarButton)this.tbButtons.elementAt(this.lastButtonClickedIndex);
            return clickedButton.buttonNumber;
        }
        return -1;
    }

    public String getButtonClickedTag() {
        if (this.validButton(this.lastButtonClickedIndex)) {
            InnoBarButton clickedButton = (InnoBarButton)this.tbButtons.elementAt(this.lastButtonClickedIndex);
            return clickedButton.origButtonTag;
        }
        return null;
    }

    public String getButtonTag(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.buttonTag;
        }
        return null;
    }

    public String getButtonOriginalTag(int buttonIndex) {
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            return checkButton.origButtonTag;
        }
        return null;
    }

    public int getButtonMouseOver() {
        if (this.validButton(this.mouseOverIndex)) {
            InnoBarButton clickedButton = (InnoBarButton)this.tbButtons.elementAt(this.mouseOverIndex);
            return clickedButton.buttonNumber;
        }
        return -1;
    }

    public String getButtonMouseOverTag() {
        if (this.validButton(this.mouseOverIndex)) {
            return this.getButtonTag(this.mouseOverIndex);
        }
        return null;
    }

    public int getButtonLastMouseOver() {
        if (this.validButton(this.oldMouseOverIndex)) {
            InnoBarButton clickedButton = (InnoBarButton)this.tbButtons.elementAt(this.oldMouseOverIndex);
            return clickedButton.buttonNumber;
        }
        return -1;
    }

    public String getImageFileName() {
        return this.fileName;
    }

    public URL getImageURL() {
        return this.url;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isUserCustomizeEnabled() {
        return this.allowUserCustomize;
    }

    public boolean isUserButtonMoveEnabled() {
        return this.allowUserButtonMove;
    }

    public int getButtonBorder() {
        return this.buttonBorder;
    }

    public int getMouseOverBorder() {
        return this.mouseOverBorder;
    }

    public int getLastClickedBorderStyle() {
        return this.lastClickedBorderStyle;
    }

    public boolean isBubbleHelpEnabled() {
        return this.bubbleHelpEnabled;
    }

    public int getBubbleHelpInitialDelay() {
        return this.mPuInitialDelay;
    }

    public int getBubbleHelpNextDelay() {
        return this.mPuNextDelay;
    }

    public Color getBubbleHelpForegroundColor() {
        return this.bubbleHelpForeground;
    }

    public Color getBubbleHelpBackgroundColor() {
        return this.bubbleHelpBackground;
    }

    public Color getColorTopOuterUp() {
        return this.colorTopOuterUp;
    }

    public Color getColorTopInnerUp() {
        return this.colorTopInnerUp;
    }

    public Color getColorBottomOuterUp() {
        return this.colorBottomOuterUp;
    }

    public Color getColorBottomInnerUp() {
        return this.colorBottomInnerUp;
    }

    public Color getColorTopOuterDown() {
        return this.colorTopOuterDown;
    }

    public Color getColorTopInnerDown() {
        return this.colorTopInnerDown;
    }

    public Color getColorBottomOuterDown() {
        return this.colorBottomOuterDown;
    }

    public Color getColorBottomInnerDown() {
        return this.colorBottomInnerDown;
    }

    public Color getColorLastClicked() {
        return this.colorLastClicked;
    }

    public Color getColorDisabled() {
        return this.colorDisabled;
    }

    public Color getColorHidden() {
        return this.colorHidden;
    }

    public int getInnoBarSize() {
        return this.tbButtons.size();
    }

    public Frame getParentFrame() {
        return this.parent;
    }

    public boolean isButtonDown(int button) {
        InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(button);
        return checkButton.buttonDown;
    }

    public boolean isButtonToggle(int button) {
        InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(button);
        return checkButton.buttonToggle;
    }

    public boolean isButtonDisabled(int buttonIndex) {
        boolean ret_code = false;
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            if (checkButton.buttonDisabledLocked || checkButton.buttonDisabledUser) {
                ret_code = true;
            }
        }
        return ret_code;
    }

    public boolean isButtonHidden(int buttonIndex) {
        boolean ret_code = false;
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            if (checkButton.buttonHiddenLocked || checkButton.buttonHiddenUser) {
                ret_code = true;
            }
        }
        return ret_code;
    }

    public boolean isButtonHiddenLocked(int buttonIndex) {
        boolean ret_code = false;
        if (this.validButton(buttonIndex)) {
            InnoBarButton checkButton = (InnoBarButton)this.tbButtons.elementAt(buttonIndex);
            ret_code = checkButton.buttonHiddenLocked;
        }
        return ret_code;
    }

    public void paint(Graphics g) {
        int dy;
        int dx;
        int x = 0;
        int y = 0;
        if (!this.toolbarEnabled) {
            return;
        }
        if (this.image != null) {
            Dimension dim = this.getSize();
            this.offg.drawImage(this.image, x, y, this);
            for (int i = 0; i < this.tbButtons.size(); ++i) {
                if (this.isButtonHidden(i)) {
                    this.offg.setColor(this.colorHidden);
                    this.offg.fillRect(this.getButtonX1(i), this.getButtonY1(i), this.getButtonWidth(i), this.getButtonHeight(i));
                    continue;
                }
                if (this.isButtonDisabled(i) && this.getButtonDisabledDx(i) > 0 && this.getButtonDisabledDy(i) > 0) {
                    dx = this.getButtonDisabledDx(i) - this.getButtonX1(i);
                    dy = this.getButtonDisabledDy(i) - this.getButtonY1(i);
                    this.offg.copyArea(this.getButtonDisabledDx(i), this.getButtonDisabledDy(i), this.getButtonWidth(i), this.getButtonHeight(i), -dx, -dy);
                    continue;
                }
                if (this.isButtonDown(i) && this.getButtonMouseDownDx(i) > 0 && this.getButtonMouseDownDy(i) > 0) {
                    dx = this.getButtonMouseDownDx(i) - this.getButtonX1(i);
                    dy = this.getButtonMouseDownDy(i) - this.getButtonY1(i);
                    this.offg.copyArea(this.getButtonMouseDownDx(i), this.getButtonMouseDownDy(i), this.getButtonWidth(i), this.getButtonHeight(i), -dx, -dy);
                    continue;
                }
                dx = this.getButtonPrimaryDx(i) - this.getButtonX1(i);
                dy = this.getButtonPrimaryDy(i) - this.getButtonY1(i);
                this.offg.copyArea(this.getButtonPrimaryDx(i), this.getButtonPrimaryDy(i), this.getButtonWidth(i), this.getButtonHeight(i), -dx, -dy);
            }
        }
        if (this.validButton(this.mouseOverIndex) && this.getButtonMouseOverDx(this.mouseOverIndex) > 0 && this.getButtonMouseOverDy(this.mouseOverIndex) > 0 && !this.isButtonHidden(this.mouseOverIndex) && !this.isButtonDisabled(this.mouseOverIndex)) {
            dx = this.getButtonMouseOverDx(this.mouseOverIndex) - this.getButtonX1(this.mouseOverIndex);
            dy = this.getButtonMouseOverDy(this.mouseOverIndex) - this.getButtonY1(this.mouseOverIndex);
            this.offg.copyArea(this.getButtonMouseOverDx(this.mouseOverIndex), this.getButtonMouseOverDy(this.mouseOverIndex), this.getButtonWidth(this.mouseOverIndex), this.getButtonHeight(this.mouseOverIndex), -dx, -dy);
        }
        if (this.validButton(this.lastButtonClickedIndex) && this.getButtonLastClickedDx(this.lastButtonClickedIndex) > 0 && this.getButtonLastClickedDy(this.lastButtonClickedIndex) > 0 && !this.isButtonHidden(this.lastButtonClickedIndex) && !this.isButtonDisabled(this.lastButtonClickedIndex)) {
            dx = this.getButtonLastClickedDx(this.lastButtonClickedIndex) - this.getButtonX1(this.lastButtonClickedIndex);
            dy = this.getButtonLastClickedDy(this.lastButtonClickedIndex) - this.getButtonY1(this.lastButtonClickedIndex);
            this.offg.copyArea(this.getButtonLastClickedDx(this.lastButtonClickedIndex), this.getButtonLastClickedDy(this.lastButtonClickedIndex), this.getButtonWidth(this.lastButtonClickedIndex), this.getButtonHeight(this.lastButtonClickedIndex), -dx, -dy);
        }
        if (this.buttonDisabledStyle == 1) {
            this.offg.setColor(this.colorDisabled);
            for (int b = 0; b < this.tbButtons.size(); ++b) {
                if (!this.isButtonDisabled(b) || this.getButtonDisabledDx(b) != 0 || this.getButtonDisabledDy(b) != 0) continue;
                for (int line = this.getButtonY1(b); line < this.getButtonY2(b); line += 2) {
                    this.offg.drawLine(this.getButtonX1(b), line, this.getButtonX2(b), line);
                }
            }
        } else if (this.buttonDisabledStyle == 2) {
            this.offg.setColor(this.colorDisabled);
            for (int b = 0; b < this.tbButtons.size(); ++b) {
                if (!this.isButtonDisabled(b) || this.getButtonDisabledDx(b) != 0 || this.getButtonDisabledDy(b) != 0) continue;
                this.offg.fillRect(this.getButtonX1(b), this.getButtonY1(b), this.getButtonWidth(b), this.getButtonHeight(b));
            }
        }
        for (int i = 0; i < this.tbButtons.size(); ++i) {
            if (this.isButtonHidden(i)) continue;
            if (this.isButtonDown(i) && this.mouseOverIndex == i) {
                this.offg.setColor(this.colorTopOuterDown);
                this.offg.drawLine(this.getButtonX1(i), this.getButtonY1(i), this.getButtonX2(i), this.getButtonY1(i));
                this.offg.drawLine(this.getButtonX1(i), this.getButtonY1(i), this.getButtonX1(i), this.getButtonY2(i));
                this.offg.setColor(this.colorBottomOuterDown);
                this.offg.drawLine(this.getButtonX1(i), this.getButtonY2(i), this.getButtonX2(i), this.getButtonY2(i));
                this.offg.drawLine(this.getButtonX2(i), this.getButtonY1(i), this.getButtonX2(i), this.getButtonY2(i));
            }
            if (this.buttonBorder >= 1) {
                if (!this.isButtonDown(i)) {
                    this.offg.setColor(this.colorTopOuterUp);
                } else {
                    this.offg.setColor(this.colorTopOuterDown);
                }
                this.offg.drawLine(this.getButtonX1(i), this.getButtonY1(i), this.getButtonX2(i), this.getButtonY1(i));
                this.offg.drawLine(this.getButtonX1(i), this.getButtonY1(i), this.getButtonX1(i), this.getButtonY2(i));
                if (!this.isButtonDown(i)) {
                    this.offg.setColor(this.colorBottomOuterUp);
                } else {
                    this.offg.setColor(this.colorBottomOuterDown);
                }
                this.offg.drawLine(this.getButtonX1(i), this.getButtonY2(i), this.getButtonX2(i), this.getButtonY2(i));
                this.offg.drawLine(this.getButtonX2(i), this.getButtonY1(i), this.getButtonX2(i), this.getButtonY2(i));
            }
            if (this.buttonBorder >= 2) {
                if (!this.isButtonDown(i)) {
                    this.offg.setColor(this.colorTopInnerUp);
                } else {
                    this.offg.setColor(this.colorTopInnerDown);
                }
                this.offg.drawLine(this.getButtonX1(i) + 1, this.getButtonY1(i) + 1, this.getButtonX2(i) - 1, this.getButtonY1(i) + 1);
                this.offg.drawLine(this.getButtonX1(i) + 1, this.getButtonY1(i) + 1, this.getButtonX1(i) + 1, this.getButtonY2(i) - 1);
                if (!this.isButtonDown(i)) {
                    this.offg.setColor(this.colorBottomInnerUp);
                } else {
                    this.offg.setColor(this.colorBottomInnerDown);
                }
                this.offg.drawLine(this.getButtonX1(i) + 1, this.getButtonY2(i) - 1, this.getButtonX2(i) + 1, this.getButtonY2(i) - 1);
                this.offg.drawLine(this.getButtonX2(i) - 1, this.getButtonY1(i) + 1, this.getButtonX2(i) - 1, this.getButtonY2(i) - 1);
            }
            if (this.buttonBorder != 3) continue;
            if (!this.isButtonDown(i)) {
                this.offg.setColor(this.colorTopInnerUp);
            } else {
                this.offg.setColor(this.colorTopInnerDown);
            }
            this.offg.drawLine(this.getButtonX1(i) + 2, this.getButtonY1(i) + 2, this.getButtonX2(i) - 2, this.getButtonY1(i) + 2);
            this.offg.drawLine(this.getButtonX1(i) + 2, this.getButtonY1(i) + 2, this.getButtonX1(i) + 2, this.getButtonY2(i) - 2);
            if (!this.isButtonDown(i)) {
                this.offg.setColor(this.colorBottomInnerUp);
            } else {
                this.offg.setColor(this.colorBottomInnerDown);
            }
            this.offg.drawLine(this.getButtonX1(i) + 2, this.getButtonY2(i) - 2, this.getButtonX2(i) + 2, this.getButtonY2(i) - 2);
            this.offg.drawLine(this.getButtonX2(i) - 2, this.getButtonY1(i) + 2, this.getButtonX2(i) - 2, this.getButtonY2(i) - 2);
        }
        if (this.validButton(this.lastButtonClickedIndex) && !this.isButtonHidden(this.lastButtonClickedIndex) && !this.isButtonDisabled(this.lastButtonClickedIndex)) {
            int ind = 3;
            int lbci = this.lastButtonClickedIndex;
            this.offg.setColor(this.colorLastClicked);
            if (this.lastClickedBorderStyle == 1) {
                for (int i = this.getButtonX1(lbci) + ind; i < this.getButtonX2(lbci) - ind; i += 2) {
                    this.offg.drawLine(i, this.getButtonY1(lbci) + ind, i, this.getButtonY1(lbci) + ind);
                }
                for (int i = this.getButtonY1(lbci) + ind; i < this.getButtonY2(lbci) - ind; i += 2) {
                    this.offg.drawLine(this.getButtonX2(lbci) - ind, i, this.getButtonX2(lbci) - ind, i);
                }
                for (int i = this.getButtonX1(lbci) + ind; i < this.getButtonX2(lbci) - ind; i += 2) {
                    this.offg.drawLine(i, this.getButtonY2(lbci) - ind, i, this.getButtonY2(lbci) - ind);
                }
                for (int i = this.getButtonY1(lbci) + ind; i < this.getButtonY2(lbci) - ind; i += 2) {
                    this.offg.drawLine(this.getButtonX1(lbci) + ind, i, this.getButtonX1(lbci) + ind, i);
                }
            } else if (this.lastClickedBorderStyle == 2) {
                this.offg.drawRect(this.getButtonX1(lbci) + ind, this.getButtonY1(lbci) + ind, this.getButtonWidth(lbci) - ind - ind, this.getButtonHeight(lbci) - ind - ind);
            } else if (this.lastClickedBorderStyle == 3) {
                this.offg.drawLine(this.getButtonX1(lbci) + ind, this.getButtonY1(lbci) + ind, this.getButtonX1(lbci) + ind + 4, this.getButtonY1(lbci) + ind);
                this.offg.drawLine(this.getButtonX1(lbci) + ind, this.getButtonY1(lbci) + ind, this.getButtonX1(lbci) + ind, this.getButtonY1(lbci) + ind + 4);
                this.offg.drawLine(this.getButtonX2(lbci) - ind, this.getButtonY1(lbci) + ind, this.getButtonX2(lbci) - ind - 4, this.getButtonY1(lbci) + ind);
                this.offg.drawLine(this.getButtonX2(lbci) - ind, this.getButtonY1(lbci) + ind, this.getButtonX2(lbci) - ind, this.getButtonY1(lbci) + ind + 4);
                this.offg.drawLine(this.getButtonX1(lbci) + ind, this.getButtonY2(lbci) - ind - 4, this.getButtonX1(lbci) + ind, this.getButtonY2(lbci) - ind);
                this.offg.drawLine(this.getButtonX1(lbci) + ind, this.getButtonY2(lbci) - ind, this.getButtonX1(lbci) + ind + 4, this.getButtonY2(lbci) - ind);
                this.offg.drawLine(this.getButtonX2(lbci) - ind - 4, this.getButtonY2(lbci) - ind, this.getButtonX2(lbci) - ind, this.getButtonY2(lbci) - ind);
                this.offg.drawLine(this.getButtonX2(lbci) - ind, this.getButtonY2(lbci) - ind - 4, this.getButtonX2(lbci) - ind, this.getButtonY2(lbci) - ind);
            }
        }
        if (this.mouseOverBorder > 0 && this.mouseOverBorder <= 3 && this.validButton(this.mouseOverIndex) && !this.isButtonHidden(this.mouseOverIndex) && !this.isButtonDisabled(this.mouseOverIndex)) {
            this.offg.setColor(this.colorLastClicked);
            this.offg.drawRect(this.getButtonX1(this.mouseOverIndex), this.getButtonY1(this.mouseOverIndex), this.getButtonWidth(this.mouseOverIndex) - 1, this.getButtonHeight(this.mouseOverIndex) - 1);
            if (this.mouseOverBorder > 1) {
                this.offg.setColor(this.colorLastClicked);
                this.offg.drawRect(this.getButtonX1(this.mouseOverIndex) + 1, this.getButtonY1(this.mouseOverIndex) + 1, this.getButtonWidth(this.mouseOverIndex) - 3, this.getButtonHeight(this.mouseOverIndex) - 3);
                if (this.mouseOverBorder == 3) {
                    this.offg.setColor(this.colorLastClicked);
                    this.offg.drawRect(this.getButtonX1(this.mouseOverIndex) + 2, this.getButtonY1(this.mouseOverIndex) + 2, this.getButtonWidth(this.mouseOverIndex) - 5, this.getButtonHeight(this.mouseOverIndex) - 5);
                }
            }
        }
        g.drawImage(this.off, 0, 0, this);
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.barWidth + 1, this.barHeight + 1);
        }
        return new Dimension(10, 10);
    }

    private void startNewThread() {
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public void run() {
        Point loc = null;
        int trueX = 0;
        int trueY = 0;
        if (this.bubbleHelpEnabled && this.validButton(this.mouseOverIndex)) {
            try {
                loc = this.getLocationOnScreen();
                if (loc != null) {
                    trueX = loc.x;
                    trueY = loc.y;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(this.mPuDelay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.validButton(this.mForThread) && this.mForThread == this.mouseOverIndex) {
                this.mPuDelay = this.mPuNextDelay;
                this.mPu.setForeground(this.bubbleHelpForeground);
                this.mPu.setBackground(this.bubbleHelpBackground);
                this.mPu.setText(this.getButtonTag(this.mouseOverIndex), this.getButtonX1(this.mouseOverIndex) + trueX + this.msgBoxHOffset, this.getButtonY1(this.mouseOverIndex) + trueY - this.msgBoxVOffset);
                ((Component)this.mPu).setVisible(true);
            }
        }
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand == null ? this.label : this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void triggerActionEvent() {
        ActionEvent ae = new ActionEvent(this, 1001, this.actionCommand);
        this.actionListener.actionPerformed(ae);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",label="))).concat(String.valueOf(this.label));
    }
}

