/*
 * Decompiled with CFR 0.152.
 */
package InnoHelp;

import InnoHelp.ContentItem;
import InnoHelp.ContentPage;
import InnoHelp.InnoHelp;
import InnoHelp.MsgBox;
import InnoHelp.PopFileReader;
import InnoHelp.SortIndex;
import InnoHelp.SortVector;
import borland.jbcl.control.TabsetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCOutliner;
import jclass.bwt.JCOutlinerEvent;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerListener;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCOutlinerNodeStyle;
import jclass.util.JCVector;

public class HelpContents
extends Panel
implements JCOutlinerListener,
KeyListener,
TextListener,
JCActionListener,
ActionListener {
    private TabsetPanel tabPanel;
    private int panelWidth = 220;
    private int MINUSWIDTH = 12;
    private InnoHelp parent;
    private JCOutliner contentTree;
    private Panel panel = new Panel();
    private Panel tpanel = new Panel();
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();
    private List indexList;
    private TextField indexField;
    private Vector treeVector;
    private Vector indexVector;
    private Label label = new Label("Search for:");

    HelpContents(InnoHelp parent, int panelWidth) {
        this.parent = parent;
        this.panelWidth = panelWidth > this.MINUSWIDTH ? panelWidth - this.MINUSWIDTH : 200;
        this.setLayout(new BorderLayout());
        this.tabPanel = new TabsetPanel();
        this.add("Center", this.tabPanel);
        this.indexVector = new Vector();
        this.setupNotebook();
    }

    private void setupNotebook() {
        this.setupContentPage();
        this.setupIndexPage();
        this.tabPanel.setSelectedIndex(0);
    }

    public void setSize(int newPanelWidth) {
        newPanelWidth = newPanelWidth > this.MINUSWIDTH ? newPanelWidth - this.MINUSWIDTH : 200;
        this.contentTree.setColumnWidth(0, newPanelWidth);
        this.contentTree.setPreferredSize(newPanelWidth, 400);
    }

    public void setHomePage() {
        ContentItem root = (ContentItem)this.contentTree.getRootNode();
        JCVector child = root.getChildren();
        if (child != null && child.size() > 0) {
            JCOutlinerNode node = (JCOutlinerNode)child.elementAt(0);
            if (node instanceof ContentPage) {
                ContentPage page = (ContentPage)node;
                if (page.getUrl().length() > 0) {
                    this.parent.loadUrl(page.getUrl());
                }
            } else {
                ContentItem item = (ContentItem)node;
                if (item.getUrl().length() > 0) {
                    this.parent.loadUrl(item.getUrl());
                }
            }
        }
    }

    private void setupContentPage() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.tabPanel.add((Component)panel, "Contents");
        this.contentTree = new JCOutliner();
        this.contentTree.setRootVisible(false);
        this.contentTree.addActionListener(this);
        this.contentTree.setNumColumns(1);
        this.contentTree.setColumnWidth(0, this.panelWidth);
        this.contentTree.setPreferredSize(this.panelWidth, 400);
        this.contentTree.getDefaultNodeStyle().setShortcut(true);
        this.contentTree.addItemListener(this);
        panel.add(this.contentTree);
    }

    private void setupIndexPage() {
        this.panel.setLayout(new BorderLayout());
        this.panel.setSize(this.panelWidth, 400);
        this.tabPanel.add((Component)this.panel, "Index");
        int[] rowHeights = new int[]{1, 26, 2, 26, 2};
        int[] columnWidths = new int[]{1, this.panelWidth - 10, 1};
        double[] rowWeights = new double[]{0.0, 10.0, 0.0, 10.0, 0.0};
        double[] columnWeights = new double[]{0.0, 10.0, 0.0};
        this.grid.rowHeights = rowHeights;
        this.grid.columnWidths = columnWidths;
        this.grid.rowWeights = rowWeights;
        this.grid.columnWeights = columnWeights;
        this.con.gridx = -1;
        this.con.gridy = -1;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.fill = 1;
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.ipadx = 0;
        this.con.ipady = 0;
        this.tpanel.setLayout(this.grid);
        this.tpanel.add(this.label);
        this.con.gridx = 1;
        this.con.gridy = 1;
        this.grid.setConstraints(this.label, this.con);
        this.indexField = new TextField();
        this.indexField.addTextListener(this);
        this.indexField.addKeyListener(this);
        this.tpanel.add(this.indexField);
        this.con.gridx = 1;
        this.con.gridy = 3;
        this.grid.setConstraints(this.indexField, this.con);
        this.panel.add("North", this.tpanel);
    }

    public void outlinerFolderStateChangeBegin(JCOutlinerEvent ev) {
        JCOutliner outliner;
        JCOutlinerFolderNode folder = (JCOutlinerFolderNode)ev.getNode();
        if (folder == (outliner = (JCOutliner)ev.getSource()).getRootNode()) {
            return;
        }
        outliner.folderChanged(folder);
        JCActionEvent AE = new JCActionEvent(outliner, 1001, "OK");
        this.actionPerformed(AE);
    }

    public void outlinerFolderStateChangeEnd(JCOutlinerEvent ev) {
    }

    public void outlinerNodeSelectBegin(JCOutlinerEvent ev) {
    }

    public void outlinerNodeSelectEnd(JCOutlinerEvent ev) {
    }

    public void itemStateChanged(JCItemEvent ev) {
    }

    public void actionPerformed(JCActionEvent e) {
        if (e.getSource() == this.contentTree) {
            JCOutlinerNode node = this.contentTree.getSelectedNode();
            if (node instanceof ContentPage) {
                ContentPage page = (ContentPage)node;
                if (page.getUrl().length() > 0) {
                    this.parent.loadUrl(page.getUrl());
                }
            } else {
                ContentItem item = (ContentItem)node;
                if (item.getUrl().length() > 0) {
                    this.parent.loadUrl(item.getUrl());
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.indexList) {
            this.selectIndexItem();
        }
    }

    public void selectIndexItem() {
        int ind = this.indexList.getSelectedIndex();
        if (ind >= 0 && ind < this.indexVector.size()) {
            String url = (String)this.indexVector.elementAt(ind);
            this.parent.loadUrl(url.substring(url.indexOf(9) + 1));
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if ((e.getSource() == this.indexList || e.getSource() == this.indexField) && e.getKeyCode() == 10) {
            this.selectIndexItem();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void textValueChanged(TextEvent e) {
        if (this.indexField.getText().trim().length() > 0) {
            String val = this.indexField.getText().trim().toLowerCase();
            String chk = null;
            for (int i = 0; i < this.indexVector.size(); ++i) {
                chk = ((String)this.indexVector.elementAt(i)).toLowerCase();
                if (!chk.startsWith(val)) continue;
                this.indexList.select(i);
                this.indexList.makeVisible(i);
                break;
            }
        }
    }

    public boolean loadContentsFile(File file) {
        boolean ret_code = true;
        PopFileReader in = new PopFileReader();
        String text = "";
        if (file.exists()) {
            if (in.open(file)) {
                ContentItem rootNode;
                this.treeVector = new Vector();
                this.contentTree.setBatched(true);
                JCOutlinerNodeStyle style = this.contentTree.getDefaultNodeStyle();
                style.setShortcut(true);
                ContentItem lastNode = rootNode = new ContentItem("");
                while (text != null) {
                    text = in.lineIn();
                    if (text == null) continue;
                    lastNode = this.processLine(text, lastNode);
                }
                in.close();
                this.contentTree.setRootNode(this.copyTree(rootNode));
                this.expandCollapse(false);
                this.contentTree.folderChanged(rootNode);
                this.contentTree.setBatched(false);
                this.contentTree.repaint();
            } else {
                ret_code = false;
                this.repError("The Table of Contents file could not be accessed.");
            }
        } else {
            ret_code = false;
            this.repError("The Table of Contents File was not found.");
        }
        return ret_code;
    }

    private ContentItem copyTree(ContentItem root) {
        ContentItem rootNode = new ContentItem("");
        JCVector child = root.getChildren();
        for (int i = 0; i < child.size(); ++i) {
            this.copyNode((ContentItem)child.elementAt(i), rootNode);
        }
        return rootNode;
    }

    private void copyNode(ContentItem node, ContentItem parent) {
        JCVector child = node.getChildren();
        if (child != null && child.size() > 0) {
            ContentItem item = new ContentItem(node, parent);
            for (int i = 0; i < child.size(); ++i) {
                this.copyNode((ContentItem)child.elementAt(i), item);
            }
        } else {
            ContentPage item = new ContentPage(node, parent);
        }
    }

    private ContentItem processLine(String text, ContentItem lastitem) {
        String chk = new String(text.toLowerCase().trim());
        ContentItem litem = lastitem;
        if (chk.startsWith("<ul>")) {
            if (this.treeVector.indexOf(lastitem) < 0) {
                this.treeVector.addElement(lastitem);
            }
        } else if (chk.startsWith("<li>")) {
            text = new String(text.substring(4));
            litem = new ContentItem(text, (ContentItem)this.treeVector.lastElement());
        } else if (chk.startsWith("</ul>")) {
            this.treeVector.removeElement(this.treeVector.lastElement());
        }
        return litem;
    }

    public boolean loadIndexFile(File file) {
        boolean ret_code = true;
        PopFileReader in = new PopFileReader();
        String text = "";
        this.indexVector.removeAllElements();
        if (file.exists()) {
            if (in.open(file)) {
                while (text != null) {
                    text = in.lineIn();
                    if (text == null) continue;
                    this.processIndexLine(text);
                }
                in.close();
                SortVector sortvector = new SortVector(this.indexVector, new SortIndex());
                this.indexList = new List(this.indexVector.size());
                for (int i = 0; i < this.indexVector.size(); ++i) {
                    text = (String)this.indexVector.elementAt(i);
                    this.indexList.add(text.substring(0, text.indexOf(9)));
                }
                this.indexList.setVisible(true);
            } else {
                this.indexList = new List();
                ret_code = false;
                this.repError("The Index file could not be accessed.");
            }
        } else {
            this.indexList = new List();
            ret_code = false;
            this.repError("The Index File was not found.");
        }
        this.indexList.addActionListener(this);
        this.indexList.addKeyListener(this);
        this.panel.add(this.indexList);
        return ret_code;
    }

    private void processIndexLine(String text) {
        String chk = new String(text.toLowerCase().trim());
        ContentPage page = null;
        if (chk.startsWith("<li>") && (page = new ContentPage(text = new String(text.substring(4)))).getUrl().length() > 0) {
            this.indexVector.addElement(String.valueOf(String.valueOf((String)page.getLabel()).concat(String.valueOf('\t'))).concat(String.valueOf(page.getUrl())));
        }
    }

    public void expandCollapse(boolean way) {
        int stat = 1;
        if (way) {
            stat = 5;
        }
        this.contentTree.setBatched(true);
        this.expandCollapse((ContentItem)this.contentTree.getRootNode(), stat);
        ((ContentItem)this.contentTree.getRootNode()).setState(5);
        this.contentTree.setBatched(false);
        this.repaint();
    }

    public void expandCollapse(JCOutlinerNode node, int stat) {
        while (node != null) {
            if (node instanceof ContentItem) {
                this.expandChildren((ContentItem)node, stat);
            }
            node = this.contentTree.getNextNode(node);
        }
    }

    public void expandChildren(ContentItem node, int stat) {
        node.setState(stat);
        JCVector child = node.getChildren();
        if (child != null) {
            for (int i = 0; i < child.size(); ++i) {
                this.expandCollapse((JCOutlinerNode)child.elementAt(i), stat);
            }
        }
    }

    public void repError(String text) {
        MsgBox msg = new MsgBox(this, text);
    }
}

