/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnAware;
import borland.jbcl.dataset.DataChangeEvent;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.SingletonDataSetManager;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.view.LabelView;
import java.awt.Color;
import java.awt.Font;

public class LabelControl
extends LabelView
implements NavigationListener,
DataChangeListener,
AccessListener,
ColumnAware {
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled = false;

    public LabelControl() {
        this.setModel(new BasicSingletonContainer());
    }

    public LabelControl(String string) {
        this.setModel(new BasicSingletonContainer());
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.updateText();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        this.updateText();
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        this.updateText();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeDataChangeListener(this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addDataChangeListener(this);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetException.handleException(this.dataSet, this, dataSetException);
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && this.dataSet.isOpen() && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            this.bindProperties(column);
        }
    }

    private void bindProperties(Column column) {
        Color color = column.getBackground();
        Color color2 = column.getForeground();
        Font font = column.getFont();
        if (color != null) {
            this.setBackground(color);
        }
        if (color2 != null) {
            this.setForeground(color2);
        }
        if (font != null) {
            this.setFont(font);
        }
    }
}

