/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.model;

import borland.jbcl.model.Res;
import borland.jbcl.model.SystemResourceBundle;
import borland.jbcl.model.VariantFormatter;
import borland.jbcl.util.BooleanFormat;
import borland.jbcl.util.FastStringBuffer;
import borland.jbcl.util.InvalidFormatException;
import borland.jbcl.util.TextFormat;
import borland.jbcl.util.Variant;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class VariantFormatStr
extends VariantFormatter {
    String pattern;
    ParsePosition parsePos;
    FieldPosition fieldPos;
    DecimalFormat decimalFormat;
    SimpleDateFormat timeFormat;
    TextFormat textFormat;
    BooleanFormat booleanFormat;
    Locale locale;
    int variantType;
    int formatterType;
    int scale;
    int precision;
    boolean isCurrency;
    private static boolean BUG6296 = true;
    private static boolean BUG5595 = true;

    public VariantFormatStr(String string, int n, Locale locale, int n2, int n3, boolean bl) {
        this.scale = n2;
        this.precision = n3;
        this.isCurrency = bl;
        if (n <= 1) {
            n = 16;
        }
        this.variantType = n;
        this.formatterType = VariantFormatStr.formatTypeFromVariantType(n);
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.parsePos = new ParsePosition(0);
        this.decimalFormat = null;
        this.timeFormat = null;
        this.textFormat = null;
        this.booleanFormat = null;
        this.pattern = string == null || string.length() == 0 ? this.getDefaultPattern(this.variantType) : (this.formatterType == 4 ? string : VariantFormatStr.buildTrueFormatMask(string));
        switch (this.formatterType) {
            case 1: 
            case 2: {
                this.decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(this.locale);
                this.decimalFormat.applyPattern(this.pattern);
                break;
            }
            case 3: {
                this.timeFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, this.locale);
                this.timeFormat.setTimeZone(TimeZone.getDefault());
                this.timeFormat.applyPattern(this.pattern);
                break;
            }
            case 5: {
                this.booleanFormat = new BooleanFormat(this.pattern);
                break;
            }
            default: {
                this.textFormat = new TextFormat(this.pattern);
            }
        }
    }

    public VariantFormatStr(String string, int n) {
        this(string, n, null);
    }

    public VariantFormatStr(String string, int n, Locale locale) {
        this(string, n, locale, -1, -1, false);
    }

    public int getVariantType() {
        return this.variantType;
    }

    public String format(Variant variant) {
        StringBuffer stringBuffer = null;
        if (this.booleanFormat == null && (variant == null || variant.isNull() || !(variant instanceof Variant))) {
            return new String();
        }
        this.fieldPos = new FieldPosition(0);
        if (this.timeFormat != null) {
            java.util.Date date = VariantFormatStr.variantToLongDate(variant);
            if (date != null) {
                try {
                    stringBuffer = new StringBuffer();
                    stringBuffer = this.timeFormat.format(date, stringBuffer, this.fieldPos);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    stringBuffer = null;
                }
            }
        } else if (this.decimalFormat != null) {
            Double d = VariantFormatStr.variantToDouble(variant, this.scale);
            if (d != null) {
                stringBuffer = new StringBuffer();
                stringBuffer = this.decimalFormat.format((double)d, stringBuffer, this.fieldPos);
            }
        } else if (this.textFormat != null) {
            String string = VariantFormatStr.variantToString(variant);
            if (string != null) {
                stringBuffer = new StringBuffer();
                stringBuffer = this.textFormat.format(string, stringBuffer, this.fieldPos);
            }
        } else if (this.booleanFormat != null) {
            Boolean bl = VariantFormatStr.variantToBoolean(variant);
            stringBuffer = new StringBuffer();
            stringBuffer = this.booleanFormat.format(bl, stringBuffer, this.fieldPos);
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    public void parse(String string, Variant variant, int n) throws InvalidFormatException {
        if (variant == null || !(variant instanceof Variant)) {
            if (variant != null) {
                // empty if block
            }
            throw new InvalidFormatException(Res.getString(17));
        }
        if (string == null || string.length() == 0) {
            variant.setNull(1);
            return;
        }
        if (n <= 1) {
            n = this.variantType;
        }
        this.parsePos.setIndex(0);
        if (this.timeFormat != null) {
            java.util.Date date = this.timeFormat.parse(string, this.parsePos);
            if (date == null) {
                throw new InvalidFormatException(Res.getString(18), this.parsePos.getIndex());
            }
            variant = VariantFormatStr.longDateToVariant(date, variant, n);
        } else if (this.decimalFormat != null) {
            Number number = this.decimalFormat.parse(string, this.parsePos);
            if (number == null) {
                try {
                    Double d;
                    if (BUG6296 && string.charAt(0) == '+') {
                        FastStringBuffer fastStringBuffer = new FastStringBuffer(string);
                        fastStringBuffer.removeCharAt(0);
                        try {
                            number = this.decimalFormat.parse(fastStringBuffer.toString(), this.parsePos);
                        }
                        catch (Exception exception) {}
                    } else if (BUG5595 && (d = Double.valueOf(string)) == 0.0) {
                        number = d;
                        this.parsePos.setIndex(1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (number == null || number instanceof Double && ((Double)number).isNaN() || this.parsePos.getIndex() == 0) {
                variant = null;
            }
            if (number != null) {
                // empty if block
            }
            if (number != null) {
                VariantFormatStr.doubleToVariant(number.doubleValue(), variant, n, this.scale);
            }
        } else if (this.textFormat != null) {
            StringBuffer stringBuffer = this.textFormat.parse(string, this.parsePos);
            variant = stringBuffer == null ? null : VariantFormatStr.stringToVariant(stringBuffer.toString(), variant, n, this.scale);
        } else if (this.booleanFormat != null) {
            Boolean bl = this.booleanFormat.parse(string, this.parsePos);
            if (bl == null && string != null && string.length() > 0 && this.parsePos.getIndex() == 0) {
                throw new InvalidFormatException(Res.getString(18), this.parsePos.getIndex());
            }
            variant = VariantFormatStr.booleanToVariant(bl, variant, n);
        } else {
            variant = null;
        }
        if (variant == null) {
            throw new InvalidFormatException(Res.getString(18), this.parsePos.getIndex());
        }
    }

    public void parse(String string, Variant variant) throws InvalidFormatException {
        this.parse(string, variant, this.variantType);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String setPattern(String string) {
        String string2 = this.getPattern();
        if (string == null || string.length() == 0) {
            string = this.getDefaultPattern(this.variantType);
        }
        if (this.decimalFormat != null) {
            this.decimalFormat.applyPattern(string);
        } else if (this.timeFormat != null) {
            this.timeFormat.applyPattern(string);
        } else if (this.textFormat != null) {
            this.textFormat.applyPattern(string);
        } else if (this.booleanFormat != null) {
            this.booleanFormat.applyPattern(string);
        }
        this.pattern = string;
        return string2;
    }

    public Object setSpecialObject(int n, Object object) {
        Character c = null;
        if (this.textFormat != null) {
            switch (n) {
                case 1: {
                    c = new Character(this.textFormat.getFillCharacter());
                    this.textFormat.setFillCharacter(((Character)object).charValue());
                    break;
                }
                case 2: {
                    c = new Character(this.textFormat.getReplaceCharacter());
                    this.textFormat.setReplaceCharacter(((Character)object).charValue());
                }
            }
        }
        return c;
    }

    public Object getSpecialObject(int n) {
        if (this.textFormat != null) {
            switch (n) {
                case 1: {
                    return new Character(this.textFormat.getFillCharacter());
                }
                case 2: {
                    return new Character(this.textFormat.getReplaceCharacter());
                }
            }
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Format getFormatObj() {
        return this.decimalFormat != null ? this.decimalFormat : (this.timeFormat != null ? this.timeFormat : (this.textFormat != null ? this.textFormat : (this.booleanFormat != null ? this.booleanFormat : null)));
    }

    public int getScale() {
        return this.scale;
    }

    public static final String buildTrueFormatMask(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        block3: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            switch (c) {
                case '^': 
                case '{': 
                case '}': {
                    continue block3;
                }
                default: {
                    cArray2[n2++] = cArray[i];
                }
            }
        }
        return new String(cArray2, 0, n2);
    }

    static final int formatTypeFromVariantType(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 5;
            }
            case 13: 
            case 14: 
            case 15: {
                return 3;
            }
        }
        return 4;
    }

    protected String getDefaultPattern(int n) {
        String string = null;
        int n2 = 0;
        try {
            ResourceBundle resourceBundle = SystemResourceBundle.getBundle("java.text.resources.LocaleElements", this.locale);
            block1 : switch (this.formatterType) {
                case 1: 
                case 2: {
                    switch (n) {
                        case 2: {
                            string = new String("###");
                            break block1;
                        }
                        case 3: {
                            string = new String("#####");
                            break block1;
                        }
                        case 4: {
                            string = new String("###########");
                            break block1;
                        }
                        case 5: {
                            string = new String("####################");
                            break block1;
                        }
                    }
                    String[] stringArray = resourceBundle.getStringArray("NumberPatterns");
                    if (this.isCurrency) {
                        ++n2;
                    }
                    string = stringArray[n2];
                    break;
                }
                case 3: {
                    String[] stringArray = resourceBundle.getStringArray("DateTimePatterns");
                    switch (n) {
                        case 14: {
                            string = stringArray[2];
                            break block1;
                        }
                        case 15: {
                            string = MessageFormat.format(stringArray[8], stringArray[2], stringArray[7]);
                            break block1;
                        }
                    }
                    string = stringArray[7];
                    break;
                }
                case 5: {
                    string = Res.getString(31);
                    break;
                }
                default: {
                    string = new String("");
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            string = new String("");
        }
        return string;
    }

    static final java.util.Date variantToLongDate(Variant variant) {
        java.util.Date date = null;
        switch (variant.getType()) {
            case 5: {
                date = new java.util.Date(variant.getLong());
                break;
            }
            case 13: {
                Date date2 = variant.getDate();
                date = new java.util.Date(date2.getTime());
                break;
            }
            case 14: {
                Time time = variant.getTime();
                date = new java.util.Date(time.getTime());
                break;
            }
            case 15: {
                Timestamp timestamp = variant.getTimestamp();
                date = new java.util.Date(((java.util.Date)timestamp).getTime() + (long)(timestamp.getNanos() / 1000000));
                break;
            }
            default: {
                date = new java.util.Date(variant.toString());
            }
        }
        return date;
    }

    static final Variant longDateToVariant(java.util.Date date, Variant variant, int n) {
        if (variant == null) {
            variant = new Variant();
        }
        if (date == null) {
            variant.setAssignedNull();
            return variant;
        }
        switch (n) {
            case 13: {
                if (date == null) {
                    variant.setNull(1);
                    break;
                }
                variant.setDate(date.getTime());
                break;
            }
            case 14: {
                Time time = new Time(date.getTime());
                variant.setTime(time);
                break;
            }
            case 15: {
                Timestamp timestamp = new Timestamp(date.getTime());
                variant.setTimestamp(timestamp);
                break;
            }
            case 5: {
                variant.setLong(date.getTime());
                break;
            }
            default: {
                return null;
            }
        }
        return variant;
    }

    static final Boolean variantToBoolean(Variant variant) {
        Boolean bl = null;
        switch (variant.getType()) {
            case 11: {
                bl = new Boolean(variant.getBoolean());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                bl = new Boolean(variant.getAsInt() != 0);
                break;
            }
            case 5: {
                bl = new Boolean(variant.getLong() != (long)0);
            }
        }
        return bl;
    }

    static final Double variantToDouble(Variant variant, int n) {
        Double d = null;
        switch (variant.getType()) {
            case 6: {
                d = new Double(variant.getFloat());
                break;
            }
            case 7: {
                d = new Double(variant.getDouble());
                break;
            }
            case 10: {
                BigDecimal bigDecimal = variant.getBigDecimal();
                if (n >= 0) {
                    bigDecimal = bigDecimal.setScale(n, 4);
                }
                d = new Double(bigDecimal.doubleValue());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                d = new Double(variant.getAsInt());
                break;
            }
            case 5: {
                d = new Double(variant.getLong());
                break;
            }
            default: {
                d = new Double(variant.toString());
            }
        }
        return d;
    }

    static final Variant booleanToVariant(Boolean bl, Variant variant, int n) {
        if (variant == null) {
            variant = new Variant();
        }
        if (bl == null) {
            variant.setAssignedNull();
        } else {
            switch (n) {
                case 11: {
                    variant.setBoolean(bl);
                }
            }
        }
        return variant;
    }

    static final Variant doubleToVariant(double d, Variant variant, int n, int n2) throws InvalidFormatException {
        if (variant == null) {
            variant = new Variant();
        }
        switch (n) {
            case 2: {
                int n3 = (int)d;
                if (n3 > 127 || n3 < -128) {
                    throw new InvalidFormatException(Res.getString(33));
                }
                variant.setByte((byte)d);
                break;
            }
            case 3: {
                int n4 = (int)d;
                if (n4 > Short.MAX_VALUE || n4 < Short.MIN_VALUE) {
                    throw new InvalidFormatException(Res.getString(32));
                }
                variant.setShort((short)d);
                break;
            }
            case 4: {
                variant.setInt((int)d);
                break;
            }
            case 5: {
                variant.setLong((long)d);
                break;
            }
            case 7: {
                variant.setDouble(d);
                break;
            }
            case 6: {
                variant.setFloat((float)d);
                break;
            }
            case 10: {
                BigDecimal bigDecimal = new BigDecimal(d);
                if (n2 >= 0) {
                    bigDecimal = bigDecimal.setScale(n2, 4);
                }
                variant.setBigDecimal(bigDecimal);
                break;
            }
            default: {
                return null;
            }
        }
        return variant;
    }

    static final String variantToString(Variant variant) {
        String string;
        switch (variant.getType()) {
            case 16: {
                string = variant.getString();
                break;
            }
            default: {
                string = variant.toString();
            }
        }
        return string;
    }

    static final Variant stringToVariant(String string, Variant variant, int n, int n2) {
        switch (n) {
            case 16: {
                variant.setString(string.toString());
                break;
            }
            case 2: {
                variant.setByte((byte)Integer.parseInt(string));
                break;
            }
            case 3: {
                variant.setShort((short)Integer.parseInt(string));
                break;
            }
            case 4: {
                variant.setInt(Integer.parseInt(string));
                break;
            }
            case 5: {
                variant.setLong(Long.parseLong(string));
                break;
            }
            case 6: {
                Float f = new Float(string);
                variant.setFloat(f.floatValue());
                break;
            }
            case 7: {
                Double d = new Double(string);
                variant.setDouble(d);
                break;
            }
            case 10: {
                BigDecimal bigDecimal = new BigDecimal(string);
                if (n2 >= 0) {
                    bigDecimal.setScale(n2);
                }
                variant.setBigDecimal(bigDecimal);
                break;
            }
            case 13: {
                java.util.Date date = new java.util.Date(java.util.Date.parse(string));
                variant.setDate(date.getTime());
                break;
            }
            case 14: {
                Time time = new Time(java.util.Date.parse(string));
                variant.setTime(time);
                break;
            }
            case 15: {
                Timestamp timestamp = new Timestamp(java.util.Date.parse(string));
                variant.setTimestamp(timestamp);
                break;
            }
            default: {
                return null;
            }
        }
        return variant;
    }
}

