/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.util.Variant;
import borland.jbcl.view.BorderItemPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class CheckboxItemPainter
implements ItemPainter {
    public static final int CHECKMARK = 1;
    public static final int XMARK = 2;
    protected BorderItemPainter border = new BorderItemPainter(9);
    protected Dimension boxSize = new Dimension(13, 13);
    protected int checkStyle = 1;
    protected boolean flat = false;

    public CheckboxItemPainter() {
    }

    public CheckboxItemPainter(Dimension dimension) {
        if (dimension != null) {
            this.boxSize = dimension;
        }
    }

    public CheckboxItemPainter(Dimension dimension, int n) {
        this(dimension);
        this.checkStyle = n;
    }

    public CheckboxItemPainter(Dimension dimension, int n, boolean bl) {
        this(dimension, n);
        this.flat = bl;
    }

    public void setBoxSize(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        this.boxSize = dimension;
    }

    public Dimension getBoxSize() {
        return new Dimension(this.boxSize.width + 2, this.boxSize.height + 2);
    }

    public void setStyle(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.checkStyle = n;
    }

    public int getStyle() {
        return this.checkStyle;
    }

    public void setFlat(boolean bl) {
        this.flat = bl;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        return new Dimension(this.boxSize);
    }

    protected boolean isChecked(Object object, int n, ItemPaintSite itemPaintSite) {
        boolean bl = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if (object instanceof Variant) {
            bl = ((Variant)object).getType() == 11 ? ((Variant)object).getBoolean() : Boolean.valueOf(object.toString()).booleanValue();
        } else if (object instanceof String) {
            bl = Boolean.valueOf((String)object);
        } else if (object instanceof Integer) {
            bl = !object.equals(new Integer(0));
        }
        return bl;
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        int n2;
        Insets insets;
        Color color = graphics.getColor();
        Insets insets2 = insets = itemPaintSite != null ? itemPaintSite.getItemMargins() : new Insets(1, 1, 1, 1);
        if (insets == null) {
            insets = new Insets(1, 1, 1, 1);
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, this.boxSize.width, this.boxSize.height);
        int n3 = n2 = itemPaintSite != null ? itemPaintSite.getAlignment() : 34;
        if (n2 == 0) {
            n2 = 34;
        }
        int n4 = 0xF & n2;
        switch (n4) {
            case 2: {
                rectangle2.x = rectangle.x + (rectangle.width - this.boxSize.width) / 2;
                break;
            }
            case 3: {
                rectangle2.x = rectangle.x + rectangle.width - this.boxSize.width - insets.right;
                break;
            }
            case 4: {
                rectangle2.width = rectangle.width - insets.left - insets.right;
            }
        }
        int n5 = 0xF0 & n2;
        switch (n5) {
            case 32: {
                rectangle2.y = rectangle.y + (rectangle.height - this.boxSize.height) / 2;
                break;
            }
            case 48: {
                rectangle2.y = rectangle.y + rectangle.height - this.boxSize.height - insets.bottom;
                break;
            }
            case 64: {
                rectangle2.height = rectangle.height - insets.top - insets.bottom;
            }
        }
        if (itemPaintSite != null) {
            graphics.setColor(itemPaintSite.getBackground());
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.drawBox(graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n);
        if (this.isChecked(object, n, itemPaintSite)) {
            if (this.flat) {
                this.drawCheck(graphics, rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2, n);
            } else {
                this.drawCheck(graphics, rectangle2.x + 2, rectangle2.y + 2, rectangle2.width - 4, rectangle2.height - 4, n);
            }
        }
        graphics.setColor(color);
    }

    protected void drawBox(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (this.flat) {
            graphics.setColor((n5 & 1) != 0 ? SystemColor.controlShadow : Color.black);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        } else {
            if (SystemColor.control.equals(graphics.getColor())) {
                this.border.setFlags(4096);
            } else {
                this.border.setFlags(0);
            }
            this.border.paint(null, graphics, new Rectangle(n, n2, n3, n4), 0, null);
        }
        graphics.setColor((n5 & 1) != 0 ? SystemColor.control : SystemColor.window);
        if (this.flat) {
            graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        } else {
            graphics.fillRect(n + 2, n2 + 2, n3 - 4, n4 - 4);
        }
    }

    protected void drawCheck(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ++n;
        ++n2;
        graphics.setColor((n5 & 1) != 0 ? SystemColor.controlShadow : SystemColor.windowText);
        if (this.checkStyle == 1) {
            int n6 = n4 / 3;
            int n7 = n + n3 / 3 - 1;
            for (int i = 1; i <= n6; ++i) {
                graphics.drawLine(n7, n2 + n4 - i - 2, n, n2 + n6 - i + n4 / 2 - 2);
                graphics.drawLine(n7, n2 + n4 - i - 2, n + n3 - 3, n2 + n6 - i);
            }
        } else if (this.checkStyle == 2) {
            graphics.drawLine(n, n2, n + n3 - 3, n2 + n4 - 3);
            graphics.drawLine(n + 1, n2, n + n3 - 3, n2 + n4 - 4);
            graphics.drawLine(n, n2 + 1, n + n3 - 4, n2 + n4 - 3);
            graphics.drawLine(n, n2 + n4 - 3, n + n3 - 3, n2);
            graphics.drawLine(n + 1, n2 + n4 - 3, n + n3 - 3, n2 + 1);
            graphics.drawLine(n, n2 + n4 - 4, n + n3 - 4, n2);
        }
    }
}

