/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.SingletonModelEvent;
import borland.jbcl.model.SingletonModelListener;
import borland.jbcl.model.SingletonModelMulticaster;
import borland.jbcl.model.SingletonViewManager;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.view.SingletonView;
import java.awt.Checkbox;
import java.awt.event.ItemEvent;

public class CheckboxView
extends Checkbox
implements SingletonModelListener,
SingletonView {
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    private boolean readOnly;

    public SingletonModel getModel() {
        return this.model;
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        WritableSingletonModel writableSingletonModel = this.writeModel = singletonModel instanceof WritableSingletonModel ? (WritableSingletonModel)singletonModel : null;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
            this.modelContentChanged(null);
        }
        this.enableEvents(512L);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean bl) {
        this.setEnabled(!bl);
        this.readOnly = bl;
    }

    public void setViewManager(SingletonViewManager singletonViewManager) {
    }

    public SingletonViewManager getViewManager() {
        return null;
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        boolean bl = this.isChecked();
        if (bl != this.getState()) {
            super.setState(bl);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        super.processItemEvent(itemEvent);
        this.setChecked(this.getState());
    }

    public boolean isChecked() {
        Object object = this.model.get();
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return false;
    }

    public void setState(boolean bl) {
        if (!this.isReadOnly()) {
            super.setState(bl);
            this.setChecked(bl);
        }
    }

    public void setChecked(boolean bl) {
        boolean bl2;
        if (!this.isReadOnly() && (bl2 = this.isChecked()) != bl) {
            Object object = this.model.get();
            if (object instanceof Boolean) {
                this.writeModel.set(new Boolean(bl));
            } else if (object instanceof Number) {
                this.writeModel.set(new Integer(bl ? 1 : 0));
            } else if (object instanceof String) {
                this.writeModel.set(new Boolean(bl).toString());
            } else {
                this.writeModel.set(new Boolean(bl));
            }
        }
    }

    public Object get() {
        return this.model.get();
    }

    public boolean canSet() {
        return this.isReadOnly() ? false : this.writeModel.canSet(true);
    }

    public void set(Object object) {
        if (!this.isReadOnly()) {
            this.writeModel.set(object);
        }
    }
}

