/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Box;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.FormEntry;
import ice.htmlbrowser.FormInfo;
import java.awt.Dimension;
import java.awt.TextArea;

class BoxTextArea
extends Box
implements FormEntry {
    protected FormInfo form;
    protected TextArea textArea;
    private String name;
    private String defaultValue = "";

    BoxTextArea(DocContainer d, FormInfo form, String name, int rows, int cols) {
        super(d);
        this.form = form;
        this.name = name;
        if (rows < 1) {
            rows = 1;
        }
        if (cols < 1) {
            cols = 20;
        }
        this.textArea = new TextArea(rows, cols);
        this.doc.setAWTComponent(this, this.textArea);
    }

    void addText(String str) {
        this.defaultValue = String.valueOf(this.defaultValue).concat(String.valueOf(str));
        this.textArea.append(str);
    }

    void layout(int visWidth, boolean firstOnLine) {
        Dimension dim = this.textArea.getPreferredSize();
        this.resize(dim.width, dim.height);
        this.textArea.setSize(dim.width, dim.height);
    }

    int getBaseLine() {
        return this.height - 4;
    }

    public int getNumValues() {
        return 1;
    }

    public String getName(int idx) {
        return this.name;
    }

    public String getValue(int idx) {
        return this.textArea.getText();
    }

    public void reset() {
        this.textArea.setText(this.defaultValue);
    }
}

