/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BrowserClassLoader;
import ice.htmlbrowser.BrowserContext;
import ice.htmlbrowser.BrowserControl;
import ice.htmlbrowser.BrowserDemo;
import ice.htmlbrowser.BrowserSecurityManager;
import ice.htmlbrowser.BrowserTools;
import ice.htmlbrowser.Document;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;

public class Browser
extends Panel
implements BrowserContext,
Externalizable {
    public static String theVersion = "3.085";
    private static final Dimension hackZero = new Dimension(0, 0);
    private URL referer;
    private static int new_doc_count = 0;
    Document doc;
    protected Hashtable docCache = new Hashtable();
    protected Stack backHistory = new Stack();
    protected Stack fwdHistory = new Stack();
    private Font defaultFixedFont;
    private Font defaultPropFont;
    private boolean memoryCaching = true;
    private TextListener urlTextListener;
    private BrowserControl control;

    public static void main(String[] args) {
        try {
            System.setSecurityManager(new BrowserSecurityManager());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        System.out.println(String.valueOf("ICE Browser version ").concat(String.valueOf(theVersion)));
        String iceHome = new String("http://www.parallab.uib.no/ICE/Browser/ReleaseNotes.html");
        try {
            Properties props = new Properties(System.getProperties());
            iceHome = props.getProperty("ice.home", iceHome);
            ((Hashtable)props).put("ice.home", iceHome);
            System.setProperties(props);
        }
        catch (SecurityException se) {
            System.err.println("WARNING - cannot set home page");
        }
        BrowserDemo aa = new BrowserDemo(args.length >= 1 ? args[0] : iceHome);
        ((Component)aa).setSize(400, 600);
        aa.show();
    }

    public Browser() {
        this.setLayout(new BorderLayout());
        this.control = new BrowserControl(this);
        this.add("North", this.control);
        this.setProportionalFont(new Font("SansSerif", 0, 12));
        this.setFixedFont(new Font("Monospaced", 0, 12));
        this.setSize(300, 400);
    }

    public Dimension getPreferredSize() {
        Dimension current = this.getSize();
        return current.equals(hackZero) ? super.getPreferredSize() : current;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setVisibleControl(boolean flag) {
        this.control.setVisible(flag);
        this.validate();
    }

    public boolean isVisibleControl() {
        return this.control.isVisible();
    }

    public void setMemoryCaching(boolean flag) {
        this.memoryCaching = flag;
    }

    public boolean isMemoryCaching() {
        return this.memoryCaching;
    }

    public void setProportionalFont(Font font) {
        this.defaultPropFont = font;
        if (this.doc != null) {
            this.doc.setProportionalFont(font);
        }
    }

    public Font getProportionalFont() {
        if (this.doc == null) {
            return this.defaultPropFont;
        }
        return this.doc.getProportionalFont();
    }

    public void setFixedFont(Font font) {
        this.defaultFixedFont = font;
        if (this.doc != null) {
            this.doc.setProportionalFont(font);
        }
    }

    public Font getFixedFont() {
        if (this.doc == null) {
            return this.defaultFixedFont;
        }
        return this.doc.getFixedFont();
    }

    public String getVersion() {
        return theVersion;
    }

    public void setVersion(String ver) {
    }

    public String getCurrentLocation() {
        if (this.doc == null) {
            return "";
        }
        return this.doc.getDocumentBase().toString();
    }

    public void setCurrentLocation(String loc) {
        this.gotoLocation(loc);
    }

    public static ClassLoader getClassLoader(String key, URL jarURL) {
        BrowserClassLoader bcl = BrowserClassLoader.getClassLoader(key, jarURL.toString());
        bcl.loadJar(jarURL);
        return bcl;
    }

    public void addTextListener(TextListener l) {
        this.urlTextListener = l;
    }

    public void removeTextListener(TextListener l) {
        this.urlTextListener = null;
    }

    public void gotoLocation(String loc) {
        try {
            URL url = this.doc != null ? new URL(this.doc.getDocumentBase(), loc) : new URL(loc);
            this.gotoLocation(url, "_top");
        }
        catch (MalformedURLException e) {
            System.err.println(String.valueOf("MalformedURLException : ").concat(String.valueOf(e.getMessage())));
        }
    }

    public void gotoLocation(URL url) {
        this.gotoLocation(url, "_top");
    }

    public synchronized Document getCurrentDocument() {
        return this.doc;
    }

    public void gotoLocation(URL url, String targetFrame) {
        this.gotoLocation(url, targetFrame, null);
    }

    public void gotoLocation(URL url, String targetFrame, String outputString) {
        targetFrame = "_top";
        this.makeDocument(url, targetFrame, outputString, true);
        this.updateCurrentURL();
        if (!this.fwdHistory.empty()) {
            this.fwdHistory.removeAllElements();
        }
        this.backHistory.push(url);
    }

    private void makeDocument(URL url, String targetFrame, String outputString, boolean doWaitForRef) {
        if (this.doc != null) {
            this.setReferer(this.doc.getDocumentBase());
            this.doc.hideDocument();
            this.remove(this.doc);
        }
        String key = Browser.makeCacheKey(url);
        if (outputString == null) {
            Object o = null;
            if (!this.docCache.isEmpty() && this.docCache.containsKey(key)) {
                o = this.docCache.get(key);
            }
            this.doc = o != null && o instanceof Document ? (Document)o : null;
        } else {
            this.doc = null;
        }
        if (this.doc == null) {
            this.doc = new Document(url, outputString, this.getReferer());
            if (this.defaultPropFont != null) {
                this.doc.setProportionalFont(this.defaultPropFont);
            }
            if (this.defaultFixedFont != null) {
                this.doc.setFixedFont(this.defaultFixedFont);
            }
            if (this.isMemoryCaching()) {
                this.docCache.put(key, this.doc);
            }
            this.add("Center", this.doc);
            this.refresh();
        } else {
            this.add("Center", this.doc);
            if (doWaitForRef) {
                this.doc.setWaitForRef(url);
            }
            this.refresh();
            this.doc.showDocument();
        }
    }

    public void updateTitle(String title) {
        Frame f = this.getFrame();
        if (f != null) {
            f.setTitle(String.valueOf("ICE Browser - ").concat(String.valueOf(title)));
        }
    }

    public Frame getFrame() {
        return BrowserTools.findFrame(this);
    }

    public void updateCurrentURL() {
        if (this.urlTextListener != null) {
            this.urlTextListener.textValueChanged(new TextEvent(this, 900));
        }
    }

    public void setReferer(URL ref) {
        this.referer = ref;
    }

    public URL getReferer() {
        return this.referer;
    }

    public void goBack() {
        if (this.doc != null && this.doc.goBack()) {
            return;
        }
        if (this.backHistory.size() <= 1) {
            return;
        }
        this.updateCurrentHistoryEntry();
        this.fwdHistory.push(this.backHistory.pop());
        this.makeDocument((URL)this.backHistory.peek(), "_top", null, false);
        this.updateCurrentURL();
    }

    public void goForward() {
        if (this.doc != null && this.doc.goForward()) {
            return;
        }
        if (this.fwdHistory.size() <= 0) {
            return;
        }
        this.updateCurrentHistoryEntry();
        this.backHistory.push(this.fwdHistory.pop());
        this.makeDocument((URL)this.backHistory.peek(), "_top", null, false);
        this.updateCurrentURL();
    }

    private void updateCurrentHistoryEntry() {
    }

    public void reload() {
        if (this.backHistory.empty()) {
            return;
        }
        this.doc.hideDocument();
        this.remove(this.doc);
        URL url = (URL)this.backHistory.pop();
        this.docCache.remove(Browser.makeCacheKey(url));
        this.doc = null;
        this.gotoLocation(url);
    }

    public void refresh() {
        this.invalidate();
        this.validate();
    }

    public void stopLoading() {
        if (this.doc != null) {
            this.doc.stopLoading();
        }
    }

    public URL getDocumentBase() {
        if (this.doc == null) {
            return null;
        }
        return this.doc.getDocumentBase();
    }

    public void newDocument() {
        try {
            ++new_doc_count;
            if (this.doc != null) {
                this.doc.hideDocument();
                this.remove(this.doc);
            }
            this.doc = new Document(null);
            this.add("Center", this.doc);
            if (this.defaultPropFont != null) {
                this.doc.setProportionalFont(this.defaultPropFont);
            }
            if (this.defaultFixedFont != null) {
                this.doc.setFixedFont(this.defaultFixedFont);
            }
            URL url = new URL(String.valueOf("file:/untitled.").concat(String.valueOf(new_doc_count)));
            if (this.isMemoryCaching()) {
                this.docCache.put(Browser.makeCacheKey(url), this.doc);
            }
            this.doc.setDocumentBase(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void replaceDocument(Document newdoc) {
        if (newdoc != null && this.doc != null) {
            this.doc.hideDocument();
            this.remove(this.doc);
        }
        if (newdoc != null) {
            this.doc = newdoc;
            this.add("Center", this.doc);
            if (this.defaultPropFont != null) {
                this.doc.setProportionalFont(this.defaultPropFont);
            }
            if (this.defaultFixedFont != null) {
                this.doc.setFixedFont(this.defaultFixedFont);
            }
        }
    }

    static String makeCacheKey(URL url) {
        String key = url.toString();
        if (url.getRef() != null) {
            key = key.substring(0, key.lastIndexOf("#"));
        }
        return key;
    }

    public void parseHTMLString(String str) {
        if (this.doc == null) {
            this.newDocument();
        }
        if (this.doc != null) {
            this.doc.parseHTMLString(str);
        }
    }

    public void removeNotify() {
        if (this.doc != null) {
            this.doc.hideDocument();
        }
        super.removeNotify();
    }

    public void printDoc(PrintJob pj) {
        Document d;
        URL u = this.doc.getURL();
        if (u != null) {
            d = new Document(u);
            int w = pj.getPageDimension().width;
            d.setMarginWidth(50);
            d.setMarginHeight(10);
            d.setSize(w, 0);
            d.setVisible(false);
            this.add(d);
        } else {
            d = this.doc;
        }
        d.printDoc(pj);
        if (d != this.doc) {
            this.remove(d);
        }
    }

    public void writeExternal(ObjectOutput out) {
        try {
            Class<?> c;
            try {
                c = Class.forName("ice.connect.GlobalServer");
            }
            catch (ClassNotFoundException cnfe) {
                throw new ClassNotFoundException("ice.connect.GlobalServer not in system");
            }
            Object o = c.newInstance();
            out.writeObject(o);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(this.getClass().getName()).concat(String.valueOf(" : cannot serialize ice.connect.GlobalServer")));
            System.err.println(String.valueOf("          ").concat(String.valueOf(e.getMessage())));
            System.err.println("          this is non-fatal");
        }
        try {
            out.writeObject(this.getDocumentBase());
            out.writeObject(this.getSize());
            out.writeObject(new Boolean(this.isVisibleControl()));
        }
        catch (IOException ioe) {
            System.err.println(String.valueOf(this.getClass().getName()).concat(String.valueOf(" : cannot serialize properties")));
            System.err.println(String.valueOf("          ").concat(String.valueOf(ioe.getMessage())));
        }
    }

    public void readExternal(ObjectInput in) {
        URL docBase = null;
        try {
            Class<?> c;
            try {
                c = Class.forName("ice.connect.GlobalServer");
            }
            catch (ClassNotFoundException cnfe) {
                throw new ClassNotFoundException("ice.connect.GlobalServer not in system");
            }
            Object o = in.readObject();
            if (o.getClass() != c) {
                docBase = (URL)o;
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(this.getClass().getName()).concat(String.valueOf(" : cannot read serialized ice.connect.GlobalServer")));
            System.err.println(String.valueOf("          ").concat(String.valueOf(e.getMessage())));
            System.err.println("          this is non-fatal");
        }
        try {
            if (docBase == null) {
                docBase = (URL)in.readObject();
            }
            Dimension dim = (Dimension)in.readObject();
            Boolean vis = (Boolean)in.readObject();
            if (dim != null) {
                this.setSize(dim);
            }
            if (docBase != null) {
                this.gotoLocation(docBase);
            }
            if (vis != null) {
                this.setVisibleControl(vis);
            }
            this.refresh();
        }
        catch (Exception ioe) {
            System.err.println(String.valueOf(this.getClass().getName()).concat(String.valueOf(" : cannot read serialized properties")));
            System.err.println(String.valueOf("          ").concat(String.valueOf(ioe.getMessage())));
        }
    }

    public Adjustable getHScrollbar() {
        return this.doc.getHScrollbar();
    }

    public Adjustable getVScrollbar() {
        return this.doc.getVScrollbar();
    }
}

