/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.AreaPoly;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.BoxApplet;
import ice.htmlbrowser.BoxHorRule;
import ice.htmlbrowser.BoxImage;
import ice.htmlbrowser.BoxInputCheckbox;
import ice.htmlbrowser.BoxInputImage;
import ice.htmlbrowser.BoxInputPassword;
import ice.htmlbrowser.BoxInputRadio;
import ice.htmlbrowser.BoxInputReset;
import ice.htmlbrowser.BoxInputSubmit;
import ice.htmlbrowser.BoxInputText;
import ice.htmlbrowser.BoxLineBreak;
import ice.htmlbrowser.BoxListItem;
import ice.htmlbrowser.BoxParagraph;
import ice.htmlbrowser.BoxSelect;
import ice.htmlbrowser.BoxTable;
import ice.htmlbrowser.BoxTextArea;
import ice.htmlbrowser.BoxWord;
import ice.htmlbrowser.CoordsList;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.Document;
import ice.htmlbrowser.FontInfo;
import ice.htmlbrowser.FormEntry;
import ice.htmlbrowser.FormInfo;
import ice.htmlbrowser.FormInputHidden;
import ice.htmlbrowser.ImageMap;
import ice.htmlbrowser.Lex;
import ice.htmlbrowser.ListInfo;
import ice.htmlbrowser.StringCode;
import ice.htmlbrowser.Tag;
import ice.htmlbrowser.TextControl;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;

class Parser
implements Runnable {
    private Object lockObject = null;
    private boolean stopRunning = false;
    private boolean stop_flag = false;
    private boolean prevTagBreakable = false;
    private static final int IB_AREA = 1000;
    private static final int IB_BASE = 1001;
    private static final int IB_BR = 1002;
    private static final int IB_DD = 1003;
    private static final int IB_DT = 1004;
    private static final int IB_FRAME = 1005;
    private static final int IB_HR = 1006;
    private static final int IB_INPUT = 1007;
    private static final int IB_IMG = 1008;
    private static final int IB_PARAM = 1009;
    private static final int IB_A_S = 1010;
    private static final int IB_A_E = 1011;
    private static final int IB_ADDRESS_S = 1012;
    private static final int IB_ADDRESS_E = 1013;
    private static final int IB_APPLET_S = 1014;
    private static final int IB_APPLET_E = 1015;
    private static final int IB_AREA_S = 1016;
    private static final int IB_AREA_E = 1017;
    private static final int IB_B_S = 1018;
    private static final int IB_B_E = 1019;
    private static final int IB_BIG_S = 1020;
    private static final int IB_BIG_E = 1021;
    private static final int IB_BLOCKQUOTE_S = 1022;
    private static final int IB_BLOCKQUOTE_E = 1023;
    private static final int IB_BODY_S = 1024;
    private static final int IB_BODY_E = 1025;
    private static final int IB_CENTER_S = 1026;
    private static final int IB_CENTER_E = 1027;
    private static final int IB_CITE_S = 1028;
    private static final int IB_CITE_E = 1029;
    private static final int IB_CODE_S = 1030;
    private static final int IB_CODE_E = 1031;
    private static final int IB_DIR_S = 1032;
    private static final int IB_DIR_E = 1033;
    private static final int IB_DIV_S = 1034;
    private static final int IB_DIV_E = 1035;
    private static final int IB_DL_S = 1036;
    private static final int IB_DL_E = 1037;
    private static final int IB_EM_S = 1038;
    private static final int IB_EM_E = 1039;
    private static final int IB_FONT_S = 1040;
    private static final int IB_FONT_E = 1041;
    private static final int IB_FORM_S = 1042;
    private static final int IB_FORM_E = 1043;
    private static final int IB_FRAMESET_S = 1044;
    private static final int IB_FRAMESET_E = 1045;
    private static final int IB_H1_S = 1046;
    private static final int IB_H1_E = 1047;
    private static final int IB_H2_S = 1048;
    private static final int IB_H2_E = 1049;
    private static final int IB_H3_S = 1050;
    private static final int IB_H3_E = 1051;
    private static final int IB_H4_S = 1052;
    private static final int IB_H4_E = 1053;
    private static final int IB_H5_S = 1054;
    private static final int IB_H5_E = 1055;
    private static final int IB_H6_S = 1056;
    private static final int IB_H6_E = 1057;
    private static final int IB_I_S = 1058;
    private static final int IB_I_E = 1059;
    private static final int IB_KBD_S = 1060;
    private static final int IB_KBD_E = 1061;
    private static final int IB_LI_S = 1062;
    private static final int IB_LI_E = 1063;
    private static final int IB_MAP_S = 1064;
    private static final int IB_MAP_E = 1065;
    private static final int IB_MENU_S = 1066;
    private static final int IB_MENU_E = 1067;
    private static final int IB_OPTION_S = 1068;
    private static final int IB_OPTION_E = 1069;
    private static final int IB_OL_S = 1070;
    private static final int IB_OL_E = 1071;
    private static final int IB_P_S = 1072;
    private static final int IB_P_E = 1073;
    private static final int IB_PRE_S = 1074;
    private static final int IB_PRE_E = 1075;
    private static final int IB_S_S = 1076;
    private static final int IB_S_E = 1077;
    private static final int IB_SAMP_S = 1078;
    private static final int IB_SAMP_E = 1079;
    private static final int IB_SCRIPT_S = 1080;
    private static final int IB_SCRIPT_E = 1081;
    private static final int IB_SELECT_S = 1082;
    private static final int IB_SELECT_E = 1083;
    private static final int IB_SMALL_S = 1084;
    private static final int IB_SMALL_E = 1085;
    private static final int IB_STRIKE_S = 1086;
    private static final int IB_STRIKE_E = 1087;
    private static final int IB_STRONG_S = 1088;
    private static final int IB_STRONG_E = 1089;
    private static final int IB_STYLE_S = 1090;
    private static final int IB_STYLE_E = 1091;
    private static final int IB_SUB_S = 1092;
    private static final int IB_SUB_E = 1093;
    private static final int IB_SUP_S = 1094;
    private static final int IB_SUP_E = 1095;
    private static final int IB_TABLE_S = 1096;
    private static final int IB_TABLE_E = 1097;
    private static final int IB_TEXTAREA_S = 1098;
    private static final int IB_TEXTAREA_E = 1099;
    private static final int IB_TD_S = 1100;
    private static final int IB_TD_E = 1101;
    private static final int IB_TITLE_S = 1102;
    private static final int IB_TITLE_E = 1103;
    private static final int IB_TR_S = 1104;
    private static final int IB_TR_E = 1105;
    private static final int IB_TH_S = 1106;
    private static final int IB_TH_E = 1107;
    private static final int IB_TT_S = 1108;
    private static final int IB_TT_E = 1109;
    private static final int IB_U_S = 1110;
    private static final int IB_U_E = 1111;
    private static final int IB_UL_S = 1112;
    private static final int IB_UL_E = 1113;
    private static final int IB_VAR_S = 1114;
    private static final int IB_VAR_E = 1115;
    static StringCode[] hashConfig = null;
    private DocContainer doc;
    private Lex lex;
    private Thread parserThread;
    private String link;
    private String linkTargetFrame;
    private String anchor;
    private String baseTargetFrame;
    private String wordBuffer;
    private BoxApplet appletBox;
    private BoxSelect selectBox;
    private BoxTextArea textAreaBox;
    private BoxWord lastWordBox;
    private int textVerticalPosition;
    private int alignGlobal;
    private int alignParagraph;
    private int indentGlobal;
    private int indentCurrent;
    private ListInfo[] list_info;
    private ImageMap imageMap;
    private FormInfo formInfo;
    private TextControl tc;
    private Stack tcStack;
    private int fontBase;
    private Color colorBackground;
    private Color colorText;
    private Color colorLink;
    private boolean flagFrames;
    private boolean flagStyle;
    private boolean flagScript;
    private boolean flagTitle;
    static Hashtable ht = null;

    Parser(DocContainer d) {
        this.init(d);
    }

    public void init(DocContainer d) {
        int i;
        this.doc = d;
        if (this.parserThread != null) {
            this.stopRunning = true;
            try {
                this.setLexReader(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.parserThread = null;
        }
        this.initHashCode();
        ht = new Hashtable();
        for (i = 0; i < hashConfig.length; ++i) {
            ht.put(Parser.hashConfig[i].str, Parser.hashConfig[i].code);
        }
        this.lex = null;
        this.lex = new Lex();
        this.fontBase = FontInfo.makeFontIdx(0, 0, 2);
        this.list_info = null;
        this.list_info = new ListInfo[100];
        for (i = 0; i < 100; ++i) {
            this.list_info[i] = new ListInfo();
        }
        this.colorBackground = Document.getDefaultBackground();
        this.doc.setBackground(this.colorBackground);
        this.colorText = Color.black;
        this.colorLink = Color.blue;
        this.alignParagraph = this.alignGlobal = 1;
        this.indentCurrent = this.indentGlobal = 0;
        this.textVerticalPosition = 0;
        this.anchor = null;
        this.linkTargetFrame = null;
        this.link = null;
        this.baseTargetFrame = new String("_self");
        this.appletBox = null;
        this.selectBox = null;
        this.textAreaBox = null;
        this.formInfo = null;
        this.flagFrames = false;
        this.flagStyle = false;
        this.flagScript = false;
        this.flagTitle = false;
        this.tc = null;
        this.tc = new TextControl(this.fontBase, this.colorText, false, false);
        this.tcStack = null;
        this.tcStack = new Stack();
        this.lockObject = null;
        this.lockObject = new Object();
        this.stop_flag = false;
        this.prevTagBreakable = false;
        this.wordBuffer = null;
        this.appletBox = null;
        this.selectBox = null;
        this.textAreaBox = null;
        this.lastWordBox = null;
        this.imageMap = null;
        this.formInfo = null;
        this.parserThread = new Thread(this);
        this.parserThread.setPriority(4);
        this.parserThread.start();
    }

    void setPlainText(boolean flag) {
        if (flag) {
            this.lex.setPreformatted(true);
            this.lex.setPlainText(true);
            this.pushTC();
            this.tc = new TextControl(this.tc, FontInfo.setType(this.tc.getFont(), 1));
        } else {
            this.lex.setPreformatted(false);
            this.lex.setPlainText(false);
            this.popTC();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    synchronized void setLexReader(Reader r) throws IOException {
        try {
            block9: {
                try {
                    if (r == null) break block9;
                    this.lex.setReader(r);
                }
                catch (IOException e) {
                    throw new IOException("Not found");
                }
            }
            Object var4_2 = null;
            Object object = this.lockObject;
            // MONITORENTER : object
            try {
                this.lockObject.notify();
                Object var7_6 = null;
                // MONITOREXIT : object
                return;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                // MONITOREXIT : object
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            Object object2 = this.lockObject;
            // MONITORENTER : object2
            try {}
            catch (Throwable throwable2) {
                Object var7_9 = null;
                // MONITOREXIT : object2
                throw throwable2;
            }
            this.lockObject.notify();
            Object var7_8 = null;
            // MONITOREXIT : object2
            throw throwable;
        }
    }

    private void initHashCode() {
        StringCode[] hashConfig = new StringCode[]{new StringCode("AREA", 1000), new StringCode("BASE", 1001), new StringCode("BR", 1002), new StringCode("DD", 1003), new StringCode("DT", 1004), new StringCode("FRAME", 1005), new StringCode("HR", 1006), new StringCode("INPUT", 1007), new StringCode("IMG", 1008), new StringCode("PARAM", 1009), new StringCode("A", 1010), new StringCode("/A", 1011), new StringCode("ADDRESS", 1012), new StringCode("/ADDRESS", 1013), new StringCode("APPLET", 1014), new StringCode("/APPLET", 1015), new StringCode("AREA", 1016), new StringCode("/AREA", 1017), new StringCode("B", 1018), new StringCode("/B", 1019), new StringCode("BIG", 1020), new StringCode("/BIG", 1021), new StringCode("BLOCKQUOTE", 1022), new StringCode("/BLOCKQUOTE", 1023), new StringCode("BODY", 1024), new StringCode("/BODY", 1025), new StringCode("CENTER", 1026), new StringCode("/CENTER", 1027), new StringCode("CITE", 1028), new StringCode("/CITE", 1029), new StringCode("CODE", 1030), new StringCode("/CODE", 1031), new StringCode("DIR", 1032), new StringCode("/DIR", 1033), new StringCode("DIV", 1034), new StringCode("/DIV", 1035), new StringCode("DL", 1036), new StringCode("/DL", 1037), new StringCode("EM", 1038), new StringCode("/EM", 1039), new StringCode("FONT", 1040), new StringCode("/FONT", 1041), new StringCode("FORM", 1042), new StringCode("/FORM", 1043), new StringCode("FRAMESET", 1044), new StringCode("/FRAMESET", 1045), new StringCode("H1", 1046), new StringCode("/H1", 1047), new StringCode("H2", 1048), new StringCode("/H2", 1049), new StringCode("H3", 1050), new StringCode("/H3", 1051), new StringCode("H4", 1052), new StringCode("/H4", 1053), new StringCode("H5", 1054), new StringCode("/H5", 1055), new StringCode("H6", 1056), new StringCode("/H6", 1057), new StringCode("I", 1058), new StringCode("/I", 1059), new StringCode("KBD", 1060), new StringCode("/KBD", 1061), new StringCode("LI", 1062), new StringCode("/LI", 1063), new StringCode("MAP", 1064), new StringCode("/MAP", 1065), new StringCode("MENU", 1066), new StringCode("/MENU", 1067), new StringCode("OPTION", 1068), new StringCode("/OPTION", 1069), new StringCode("OL", 1070), new StringCode("/OL", 1071), new StringCode("P", 1072), new StringCode("/P", 1073), new StringCode("PRE", 1074), new StringCode("/PRE", 1075), new StringCode("S", 1076), new StringCode("/S", 1077), new StringCode("SAMP", 1078), new StringCode("/SAMP", 1079), new StringCode("SCRIPT", 1080), new StringCode("/SCRIPT", 1081), new StringCode("SELECT", 1082), new StringCode("/SELECT", 1083), new StringCode("SMALL", 1084), new StringCode("/SMALL", 1085), new StringCode("STRIKE", 1086), new StringCode("/STRIKE", 1087), new StringCode("STRONG", 1088), new StringCode("/STRONG", 1089), new StringCode("STYLE", 1090), new StringCode("/STYLE", 1091), new StringCode("SUB", 1092), new StringCode("/SUB", 1093), new StringCode("SUP", 1094), new StringCode("/SUP", 1095), new StringCode("TABLE", 1096), new StringCode("/TABLE", 1097), new StringCode("TEXTAREA", 1098), new StringCode("/TEXTAREA", 1099), new StringCode("TD", 1100), new StringCode("/TD", 1101), new StringCode("TITLE", 1102), new StringCode("/TITLE", 1103), new StringCode("TR", 1104), new StringCode("/TR", 1105), new StringCode("TH", 1106), new StringCode("/TH", 1107), new StringCode("TT", 1108), new StringCode("/TT", 1109), new StringCode("U", 1110), new StringCode("/U", 1111), new StringCode("UL", 1112), new StringCode("/UL", 1113), new StringCode("VAR", 1114), new StringCode("/VAR", 1115), new StringCode("NULLTAG", 0)};
        Parser.hashConfig = new StringCode[hashConfig.length];
        for (int i = 0; i < hashConfig.length; ++i) {
            Parser.hashConfig[i] = hashConfig[i];
        }
    }

    void stopLoading() {
        this.stop_flag = true;
    }

    public void setStop(boolean val) {
        this.stopRunning = val;
    }

    public void run() {
        this.stopRunning = false;
        this.doc.setParsingDone(false);
        while (!this.stopRunning) {
            while (!this.stopRunning && !this.parseNextToken()) {
                this.stop_flag = false;
                Object object = this.lockObject;
                synchronized (object) {
                    Object var4_3;
                    try {
                        try {
                            this.lockObject.wait();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        throw throwable;
                    }
                }
            }
            while (!this.stopRunning && this.parseNextToken()) {
                Thread.yield();
            }
            this.finishParsing();
        }
    }

    private void finishParsing() {
        this.doc.setParsingDone(true);
        this.doc.getParentDocument().showDocument();
    }

    public void stopParsing() {
        if (this.parserThread != null) {
            this.parserThread.stop();
            this.parserThread = null;
        }
        this.finishParsing();
        this.tc = null;
        this.tcStack = null;
    }

    private boolean parseNextToken() {
        int tokenType = this.lex.getNextToken();
        if (tokenType < 0) {
            return false;
        }
        if (this.stop_flag) {
            return false;
        }
        String tokenString = this.lex.getTokenString();
        if (tokenType == 3) {
            this.prevTagBreakable |= this.lex.isTokenBreakable();
            this.processTag(new Tag(tokenString));
        } else if (tokenType == 2) {
            if (!(this.flagFrames || this.flagStyle || this.flagScript || this.appletBox != null)) {
                this.addWord(tokenString);
            }
            this.prevTagBreakable = false;
        }
        return true;
    }

    protected void processTag(Tag tag) {
        String name;
        String param;
        String val = tag.getValue();
        Object o = ht.get(val);
        if (!(o instanceof Integer)) {
            return;
        }
        int hashVal = (Integer)o;
        if (hashVal == 1102) {
            this.flagTitle = true;
            this.wordBuffer = new String("[");
        } else if (hashVal == 1103) {
            if (this.flagTitle && this.wordBuffer != null) {
                this.doc.setTitle(String.valueOf(this.wordBuffer).concat(String.valueOf("]")));
                this.wordBuffer = null;
            }
            this.flagTitle = false;
        }
        if (hashVal == 1044 && this.doc.lastBox() == null) {
            this.flagFrames = true;
            String str_cols = tag.getStringParam("COLS");
            String str_rows = tag.getStringParam("ROWS");
            if (str_cols != null || str_rows != null) {
                int[] rowTypes;
                int[] rowValues;
                int[] colTypes;
                int[] colValues;
                if (str_cols != null) {
                    CoordsList cl = new CoordsList(str_cols);
                    colValues = cl.getListOfValues();
                    colTypes = cl.getListOfTypes();
                } else {
                    colValues = new int[1];
                    colTypes = new int[1];
                    colValues[0] = 100;
                    colTypes[0] = 1;
                }
                if (str_rows != null) {
                    CoordsList cl = new CoordsList(str_rows);
                    rowValues = cl.getListOfValues();
                    rowTypes = cl.getListOfTypes();
                } else {
                    rowValues = new int[1];
                    rowTypes = new int[1];
                    rowValues[0] = 100;
                    rowTypes[0] = 1;
                }
                this.doc.getParentDocument().startFrameset(colValues, colTypes, rowValues, rowTypes);
            }
        } else if (hashVal == 1045 && this.flagFrames) {
            this.doc.getParentDocument().finishFrameset();
        } else if (hashVal == 1005 && this.flagFrames) {
            String src = tag.getStringParam("SRC");
            String name2 = tag.getStringParam("NAME");
            int mw = tag.getIntParam("MARGINWIDTH");
            int mh = tag.getIntParam("MARGINHEIGHT");
            int scroll = 0;
            param = tag.getStringParam("SCROLLING", true);
            if (param != null) {
                if (param.equals("YES")) {
                    scroll = 1;
                } else if (param.equals("NO")) {
                    scroll = 2;
                }
            }
            if (src != null) {
                this.doc.getParentDocument().addFrame(src, name2, mw, mh, scroll);
            }
        }
        if (this.flagFrames) {
            return;
        }
        if (hashVal == 1080) {
            this.flagScript = true;
        } else if (hashVal == 1081) {
            this.flagScript = false;
        }
        if (this.flagScript) {
            return;
        }
        if (hashVal == 1090) {
            this.flagStyle = true;
        } else if (hashVal == 1091) {
            this.flagStyle = false;
        }
        if (this.flagStyle) {
            return;
        }
        if (hashVal == 1014) {
            String codeBase = tag.getStringParam("CODEBASE");
            String apcode = tag.getStringParam("CODE");
            int w = tag.getIntParam("WIDTH");
            int h = tag.getIntParam("HEIGHT");
            if (apcode != null && w >= 0 && h >= 0) {
                String archiveList;
                this.appletBox = new BoxApplet(this.doc, apcode, codeBase, w, h);
                this.doc.addBox(this.appletBox);
                this.appletBox.setTarget(this.baseTargetFrame);
                h = tag.getIntParam("HSPACE");
                if (h > 0) {
                    this.appletBox.setHSpace(h);
                }
                if ((h = tag.getIntParam("VSPACE")) > 0) {
                    this.appletBox.setVSpace(h);
                }
                if ((param = tag.getStringParam("ALIGN", true)) != null) {
                    if (param.equals("LEFT")) {
                        this.appletBox.setAttrib(1);
                    } else if (param.equals("CENTER")) {
                        this.appletBox.setAttrib(2);
                    } else if (param.equals("RIGHT")) {
                        this.appletBox.setAttrib(3);
                    }
                }
                if ((archiveList = tag.getStringParam("ARCHIVE")) != null) {
                    String[] alistAray = this.makeListArray(archiveList);
                    this.appletBox.setArchiveList(alistAray);
                }
            }
        } else if (hashVal == 1009 && this.appletBox != null) {
            name = tag.getStringParam("NAME");
            String value = tag.getStringParam("VALUE");
            if (name != null && value != null) {
                this.appletBox.addParam(name, value);
            }
        } else if (hashVal == 1015 && this.appletBox != null) {
            this.appletBox.init();
            this.appletBox.queueEvent(1);
            this.appletBox.queueEvent(2);
            this.appletBox.queueEvent(3);
            this.appletBox = null;
        }
        if (this.appletBox != null) {
            return;
        }
        if (hashVal == 1042) {
            String action = tag.getStringParam("ACTION");
            String method = tag.getStringParam("METHOD");
            String targetFrame = tag.getStringParam("TARGET");
            if (targetFrame == null) {
                targetFrame = this.baseTargetFrame;
            }
            if (action == null) {
                action = new String(this.doc.getDocumentBase().toString());
            }
            this.formInfo = new FormInfo(this.doc, action, method, targetFrame);
        } else if (hashVal == 1007 && this.formInfo != null) {
            Box b;
            String inputType = tag.getStringParam("TYPE", true);
            String inputName = tag.getStringParam("NAME");
            String inputValue = tag.getStringParam("VALUE");
            int inputSize = tag.getIntParam("SIZE");
            int inputMaxLength = tag.getIntParam("MAXLENGTH");
            boolean checked = tag.isParam("CHECKED");
            if (inputType == null || inputType.equals("TEXT")) {
                b = new BoxInputText(this.doc, this.formInfo, inputName, inputValue, inputSize, inputMaxLength);
                this.doc.addBox(b);
                this.formInfo.addFormEntry((FormEntry)((Object)b));
            } else if (inputType.equals("PASSWORD")) {
                b = new BoxInputPassword(this.doc, this.formInfo, inputName, inputValue, inputSize, inputMaxLength);
                this.doc.addBox(b);
                this.formInfo.addFormEntry((FormEntry)((Object)b));
            } else if (inputType.equals("SUBMIT")) {
                if (inputValue == null) {
                    inputValue = new String("Submit Query");
                }
                b = new BoxInputSubmit(this.doc, this.formInfo, inputName, inputValue);
                this.doc.addBox(b);
                this.formInfo.addFormEntry((FormEntry)((Object)b));
            } else if (inputType.equals("IMAGE")) {
                String imgSrc = tag.getStringParam("SRC");
                if (imgSrc != null) {
                    int w = tag.getIntParam("WIDTH");
                    int h = tag.getIntParam("HEIGHT");
                    BoxInputImage b2 = new BoxInputImage(this.doc, this.formInfo, inputName, inputValue, imgSrc, w, h);
                    this.doc.addBox(b2);
                    this.formInfo.addFormEntry(b2);
                }
            } else if (inputType.equals("RESET")) {
                b = new BoxInputReset(this.doc, this.formInfo, inputName, inputValue);
                this.doc.addBox(b);
                this.formInfo.addFormEntry((FormEntry)((Object)b));
            } else if (inputType.equals("CHECKBOX")) {
                b = new BoxInputCheckbox(this.doc, this.formInfo, inputName, inputValue, checked);
                this.doc.addBox(b);
                this.formInfo.addFormEntry((FormEntry)((Object)b));
            } else if (inputType.equals("RADIO")) {
                b = new BoxInputRadio(this.doc, this.formInfo, inputName, inputValue, checked);
                this.doc.addBox(b);
                this.formInfo.addFormEntry((FormEntry)((Object)b));
            } else if (inputType.equals("HIDDEN")) {
                FormInputHidden f = new FormInputHidden(this.formInfo, inputName, inputValue);
                this.formInfo.addFormEntry(f);
            }
        } else if (hashVal == 1082 && this.formInfo != null) {
            String selectName = tag.getStringParam("NAME");
            int selectSize = tag.getIntParam("SIZE");
            this.selectBox = new BoxSelect(this.doc, this.formInfo, selectName, selectSize, false);
            this.doc.addBox(this.selectBox);
            this.formInfo.addFormEntry(this.selectBox);
            this.wordBuffer = "";
        } else if (hashVal == 1068 && this.selectBox != null) {
            if (this.wordBuffer.length() > 0) {
                this.selectBox.addOptionText(this.wordBuffer);
            }
            String optionName = tag.getStringParam("VALUE");
            this.selectBox.addOption(optionName, tag.isParam("SELECTED"));
            this.wordBuffer = "";
        } else if (hashVal == 1069 && this.selectBox != null) {
            this.selectBox.addOptionText(this.wordBuffer);
            this.wordBuffer = "";
        } else if (hashVal == 1083 && this.formInfo != null) {
            if (this.wordBuffer.length() > 0) {
                this.selectBox.addOptionText(this.wordBuffer);
            }
            this.selectBox.finishSelect();
            this.selectBox = null;
            this.wordBuffer = null;
        } else if (hashVal == 1098 && this.formInfo != null) {
            String textAreaName = tag.getStringParam("NAME");
            int cols = tag.getIntParam("COLS");
            int rows = tag.getIntParam("ROWS");
            this.textAreaBox = new BoxTextArea(this.doc, this.formInfo, textAreaName, rows, cols);
            this.doc.addBox(this.textAreaBox);
            this.formInfo.addFormEntry(this.textAreaBox);
            this.wordBuffer = "";
        } else if (hashVal == 1099 && this.formInfo != null) {
            if (this.textAreaBox != null && this.wordBuffer != null) {
                this.textAreaBox.addText(this.wordBuffer);
            }
            this.textAreaBox = null;
            this.wordBuffer = null;
        } else if (hashVal == 1043) {
            this.formInfo = null;
            this.selectBox = null;
            this.textAreaBox = null;
            this.wordBuffer = null;
        }
        if (this.selectBox != null || this.textAreaBox != null) {
            return;
        }
        switch (hashVal) {
            case 1001: {
                param = tag.getStringParam("HREF");
                if (param != null) {
                    this.doc.setDocumentBase(param);
                }
                if ((param = tag.getStringParam("TARGET")) == null) break;
                this.baseTargetFrame = param;
                break;
            }
            case 1010: {
                this.pushTC();
                if (tag.isParam("HREF")) {
                    this.link = tag.getStringParam("HREF");
                    this.linkTargetFrame = tag.getStringParam("TARGET");
                    if (this.linkTargetFrame == null) {
                        this.linkTargetFrame = this.baseTargetFrame;
                    }
                    this.tc = new TextControl(this.tc.getFont(), this.colorLink, this.tc.getUnderline(), this.tc.getStrikeout());
                }
                if (!tag.isParam("NAME")) break;
                this.anchor = tag.getStringParam("NAME");
                break;
            }
            case 1011: {
                this.link = null;
                this.linkTargetFrame = null;
                this.popTC();
                break;
            }
            case 1008: {
                String imgName = tag.getStringParam("SRC");
                if (imgName == null) break;
                int w = tag.getIntParam("WIDTH");
                int h = tag.getIntParam("HEIGHT");
                BoxImage b = new BoxImage(this.doc, imgName, w, h);
                b.setColor(this.colorBackground);
                param = tag.getStringParam("USEMAP");
                if (param != null) {
                    b.setUseMap(param);
                } else {
                    if (this.link != null) {
                        b.setLink(this.link, this.linkTargetFrame);
                        b.setColor(this.colorLink);
                    }
                    b.setIsMap(tag.isParam("ISMAP"));
                }
                if (this.anchor != null) {
                    b.setAnchor(this.anchor);
                    this.anchor = null;
                }
                if ((param = tag.getStringParam("ALIGN", true)) != null) {
                    if (param.equals("LEFT")) {
                        b.setAttrib(4);
                    } else if (param.equals("RIGHT")) {
                        b.setAttrib(5);
                    } else if (param.equals("TOP") || param.equals("TEXTTOP")) {
                        b.setVAlign(2);
                    } else if (param.equals("MIDDLE") || param.equals("ABSMIDDLE")) {
                        b.setVAlign(1);
                    }
                }
                if ((h = tag.getIntParam("HSPACE")) > 0) {
                    b.setHSpace(h);
                }
                if ((h = tag.getIntParam("VSPACE")) > 0) {
                    b.setVSpace(h);
                }
                this.doc.addBox(b);
                break;
            }
            case 1064: {
                name = tag.getStringParam("NAME");
                if (name == null) break;
                this.imageMap = this.doc.newImageMap(name);
                break;
            }
            case 1016: {
                String coords;
                if (this.imageMap == null) break;
                String shape = tag.getStringParam("SHAPE");
                if (shape == null) {
                    shape = "RECT";
                }
                String loc = tag.getStringParam("HREF");
                String targetFrame = tag.getStringParam("TARGET");
                if (targetFrame == null) {
                    targetFrame = this.baseTargetFrame;
                }
                if ((coords = tag.getStringParam("COORDS")) == null) break;
                if (shape.equalsIgnoreCase("RECT") || shape.equalsIgnoreCase("DEFAULT")) {
                    CoordsList cl = new CoordsList(coords);
                    if (cl.size() < 4) break;
                    int x1 = cl.getItemValue(0);
                    if (cl.getItemType(0) == 1) {
                        x1 = -x1;
                    }
                    int y1 = cl.getItemValue(1);
                    if (cl.getItemType(1) == 1) {
                        y1 = -y1;
                    }
                    int x2 = cl.getItemValue(2);
                    if (cl.getItemType(2) == 1) {
                        x2 = -x2;
                    }
                    int y2 = cl.getItemValue(3);
                    if (cl.getItemType(3) == 1) {
                        y2 = -y2;
                    }
                    this.imageMap.addAreaRect(x1, y1, x2, y2, loc, targetFrame);
                    break;
                }
                if (shape.equalsIgnoreCase("CIRCLE")) {
                    CoordsList cl = new CoordsList(coords);
                    if (cl.size() < 3) break;
                    int x = cl.getItemValue(0);
                    if (cl.getItemType(0) == 1) {
                        x = -x;
                    }
                    int y = cl.getItemValue(1);
                    if (cl.getItemType(1) == 1) {
                        y = -y;
                    }
                    int r = cl.getItemValue(2);
                    if (cl.getItemType(2) == 1) {
                        r = -r;
                    }
                    this.imageMap.addAreaCircle(x, y, r, loc, targetFrame);
                    break;
                }
                if (!shape.equalsIgnoreCase("POLY")) break;
                CoordsList cl = new CoordsList(coords);
                AreaPoly ap = new AreaPoly(loc, targetFrame);
                for (int vertex = 0; vertex < cl.size() - 1; vertex += 2) {
                    ap.addCoordPair(cl.getItemValue(vertex), cl.getItemValue(vertex + 1));
                }
                this.imageMap.addAreaPoly(ap);
                break;
            }
            case 1065: {
                this.imageMap = null;
                break;
            }
            case 1096: {
                this.doc.addBox(new BoxLineBreak(this.doc));
                int bsize = tag.getIntParam("BORDER");
                if (bsize < 0) {
                    bsize = tag.isParam("BORDER") ? 1 : 0;
                }
                int w = 0;
                param = tag.getStringParam("WIDTH");
                if (param != null) {
                    w = tag.getIntParam("WIDTH");
                    if (w > 0) {
                        if (param.indexOf("%") != -1) {
                            w = -w;
                        }
                    } else {
                        w = 0;
                    }
                }
                BoxTable tb = new BoxTable(this.doc, w, bsize);
                tb.setColor(this.colorBackground);
                w = tag.getIntParam("CELLSPACING");
                if (w >= 0) {
                    tb.setCellSpacing(w);
                }
                if ((w = tag.getIntParam("CELLPADDING")) >= 0) {
                    tb.setCellPadding(w);
                }
                if ((param = tag.getStringParam("ALIGN", true)) != null) {
                    if (param.equals("LEFT")) {
                        tb.setAttrib(4);
                    } else if (param.equals("RIGHT")) {
                        tb.setAttrib(5);
                    }
                }
                this.doc.redirectTo(tb);
                break;
            }
            case 1104: {
                if (this.doc.getRedirect() == null) break;
                BoxTable tb = this.doc.getRedirect();
                tb.addTableRow();
                param = tag.getStringParam("ALIGN", true);
                if (param != null) {
                    if (param.equals("LEFT")) {
                        tb.setRowAlign(0);
                    }
                    if (param.equals("CENTER")) {
                        tb.setRowAlign(2);
                    } else if (param.equals("RIGHT")) {
                        tb.setRowAlign(1);
                    }
                }
                if ((param = tag.getStringParam("VALIGN", true)) == null) break;
                if (param.equals("TOP")) {
                    tb.setRowVAlign(0);
                    break;
                }
                if (param.equals("MIDDLE")) {
                    tb.setRowVAlign(2);
                    break;
                }
                if (!param.equals("BOTTOM")) break;
                tb.setRowVAlign(1);
                break;
            }
            case 1100: 
            case 1106: {
                Color c;
                if (this.doc.getRedirect() == null) break;
                BoxTable tb = this.doc.getRedirect();
                int w = 0;
                param = tag.getStringParam("WIDTH");
                if (param != null) {
                    w = tag.getIntParam("WIDTH");
                    if (w > 0) {
                        if (param.indexOf("%") != -1) {
                            w = -w;
                        }
                    } else {
                        w = 0;
                    }
                }
                int cspan = tag.getIntParam("COLSPAN");
                int rspan = tag.getIntParam("ROWSPAN");
                if (cspan < 1) {
                    cspan = 1;
                }
                if (rspan < 1) {
                    rspan = 1;
                }
                tb.addTableCell(cspan, rspan, w);
                if (tag.isParam("NOWRAP")) {
                    tb.setCellNoWrap();
                }
                if ((c = tag.getColorParam("BGCOLOR")) != null) {
                    tb.setCellColor(c);
                }
                if (val.equals("TH")) {
                    tb.setCellAlign(2);
                }
                if ((param = tag.getStringParam("ALIGN", true)) != null) {
                    if (param.equals("CENTER")) {
                        tb.setCellAlign(2);
                    } else if (param.equals("RIGHT")) {
                        tb.setCellAlign(1);
                    } else if (param.equals("LEFT")) {
                        tb.setCellAlign(0);
                    }
                }
                if ((param = tag.getStringParam("VALIGN", true)) == null) break;
                if (param.equals("TOP")) {
                    tb.setCellVAlign(0);
                    break;
                }
                if (param.equals("MIDDLE")) {
                    tb.setCellVAlign(2);
                    break;
                }
                if (!param.equals("BOTTOM")) break;
                tb.setCellVAlign(1);
                break;
            }
            case 1097: {
                BoxTable bt = this.doc.getRedirect();
                if (bt != null) {
                    bt.finishTable();
                }
                this.doc.redirectTo(null);
                if (bt == null) break;
                this.doc.addBox(bt);
                this.doc.addBox(new BoxLineBreak(this.doc));
                break;
            }
            case 1024: {
                Color c = tag.getColorParam("BGCOLOR");
                if (c != null) {
                    this.doc.setBackground(c);
                    this.colorBackground = c;
                }
                if ((c = tag.getColorParam("LINK")) != null) {
                    this.colorLink = c;
                }
                if ((c = tag.getColorParam("TEXT")) != null) {
                    this.colorText = c;
                    this.tc = new TextControl(this.tc.getFont(), c, this.tc.getUnderline(), this.tc.getStrikeout());
                }
                if ((param = tag.getStringParam("BACKGROUND")) == null) break;
                this.doc.setBackgroundImage(param);
                break;
            }
            case 1002: {
                Box b = new BoxLineBreak(this.doc);
                param = tag.getStringParam("CLEAR", true);
                if (param != null) {
                    if (param.equals("ALL") || param.equals("BOTH")) {
                        b.setAttrib(8);
                    } else if (param.equals("LEFT")) {
                        b.setAttrib(6);
                    } else if (param.equals("RIGHT")) {
                        b.setAttrib(7);
                    }
                }
                this.doc.addBox(b);
                break;
            }
            case 1026: {
                Box b = new BoxLineBreak(this.doc);
                this.alignGlobal = 2;
                b.setAttrib(this.alignGlobal);
                this.doc.addBox(b);
                break;
            }
            case 1027: {
                Box b = new BoxLineBreak(this.doc);
                this.alignParagraph = this.alignGlobal = 1;
                b.setAttrib(this.alignGlobal);
                this.doc.addBox(b);
                break;
            }
            case 1032: 
            case 1066: 
            case 1112: {
                if (this.list_info[this.indentCurrent].getType() < 0) {
                    this.doc.addBox(this.newBoxParagraph());
                } else {
                    this.doc.addBox(new BoxLineBreak(this.doc));
                }
                ++this.indentGlobal;
                this.changeIndent(this.indentCurrent, this.indentGlobal);
                this.indentCurrent = this.indentGlobal;
                this.list_info[this.indentCurrent].setType(0);
                param = tag.getStringParam("TYPE", true);
                int sub_type = this.indentCurrent - 1;
                if (param != null) {
                    if (param.equals("DISC")) {
                        sub_type = 0;
                    } else if (param.equals("CIRCLE")) {
                        sub_type = 1;
                    } else if (param.equals("SQUARE")) {
                        sub_type = 2;
                    }
                }
                this.list_info[this.indentCurrent].setSubType(sub_type);
                break;
            }
            case 1070: {
                if (this.list_info[this.indentCurrent].getType() < 0) {
                    this.doc.addBox(this.newBoxParagraph());
                } else {
                    this.doc.addBox(new BoxLineBreak(this.doc));
                }
                ++this.indentGlobal;
                this.changeIndent(this.indentCurrent, this.indentGlobal);
                this.indentCurrent = this.indentGlobal;
                this.list_info[this.indentCurrent].setType(1);
                param = tag.getStringParam("TYPE");
                int stype = 0;
                if (param != null) {
                    if (param.equals("A")) {
                        stype = 1;
                    } else if (param.equals("a")) {
                        stype = 2;
                    } else if (param.equals("I")) {
                        stype = 3;
                    } else if (param.equals("i")) {
                        stype = 4;
                    }
                }
                this.list_info[this.indentCurrent].setSubType(stype);
                int c = tag.getIntParam("START");
                if (c <= 0) break;
                this.list_info[this.indentCurrent].setCount(c);
                break;
            }
            case 1033: 
            case 1067: 
            case 1071: 
            case 1113: {
                --this.indentGlobal;
                if (this.indentGlobal < 0) {
                    this.indentGlobal = 0;
                }
                if (this.list_info[this.indentGlobal].getType() < 0) {
                    this.doc.addBox(new BoxParagraph(this.doc, this.tc.getFont()));
                } else {
                    this.doc.addBox(new BoxLineBreak(this.doc));
                }
                this.changeIndent(this.indentCurrent, this.indentGlobal);
                this.indentCurrent = this.indentGlobal;
                break;
            }
            case 1062: {
                int type = this.list_info[this.indentCurrent].getType();
                if (type == 0) {
                    param = tag.getStringParam("TYPE", true);
                    if (param != null) {
                        int stype = -1;
                        if (param.equals("DISC")) {
                            stype = 0;
                        } else if (param.equals("CIRCLE")) {
                            stype = 1;
                        } else if (param.equals("SQUARE")) {
                            stype = 2;
                        }
                        if (stype >= 0) {
                            this.list_info[this.indentCurrent].setSubType(stype);
                        }
                    }
                } else if (type == 1) {
                    int c;
                    param = tag.getStringParam("TYPE", true);
                    if (param != null) {
                        int stype = -1;
                        if (param.equals("A")) {
                            stype = 1;
                        } else if (param.equals("a")) {
                            stype = 2;
                        } else if (param.equals("I")) {
                            stype = 3;
                        } else if (param.equals("i")) {
                            stype = 4;
                        } else if (param.equals("1")) {
                            stype = 0;
                        }
                        if (stype >= 0) {
                            this.list_info[this.indentCurrent].setSubType(stype);
                        }
                    }
                    if ((c = tag.getIntParam("VALUE")) > 0) {
                        this.list_info[this.indentCurrent].setCount(c);
                    }
                }
                BoxListItem b = this.list_info[this.indentCurrent].newBoxListItem(this.doc, this.tc.getFont());
                if (this.indentCurrent <= 0) {
                    b.setAttrib(0);
                }
                b.setColor(this.tc.getColor());
                this.doc.addBox(b);
                break;
            }
            case 1063: {
                break;
            }
            case 1036: {
                ++this.indentGlobal;
                this.changeIndent(this.indentCurrent, this.indentGlobal);
                this.indentCurrent = this.indentGlobal;
                break;
            }
            case 1037: {
                this.doc.addBox(this.newBoxParagraph());
                --this.indentGlobal;
                if (this.indentGlobal < 0) {
                    this.indentGlobal = 0;
                }
                this.changeIndent(this.indentCurrent, this.indentGlobal);
                this.indentCurrent = this.indentGlobal;
                break;
            }
            case 1004: {
                int old = this.indentCurrent--;
                if (this.indentCurrent < 0) {
                    this.indentCurrent = 0;
                }
                this.changeIndent(old, this.indentCurrent);
                break;
            }
            case 1003: {
                int old = this.indentCurrent;
                this.indentCurrent = this.indentCurrent == 0 ? 1 : this.indentGlobal;
                this.changeIndent(old, this.indentCurrent);
                break;
            }
            case 1040: {
                Color color = tag.getColorParam("COLOR");
                int font = this.tc.getFont();
                param = tag.getStringParam("SIZE", true);
                if (param != null) {
                    int size = FontInfo.getSize(font);
                    char c = param.charAt(0);
                    if (c == '+') {
                        size += param.charAt(1) - 48;
                    } else if (c == '-') {
                        size -= param.charAt(1) - 48;
                    } else if (c >= '1' && c <= '7') {
                        size = c - 49;
                    }
                    if (size > 6) {
                        size = 6;
                    }
                    if (size < 0) {
                        size = 0;
                    }
                    font = FontInfo.setSize(font, size);
                }
                this.pushTC();
                if (color != null) {
                    this.tc = new TextControl(font, color, this.tc.getUnderline(), this.tc.getStrikeout());
                    break;
                }
                this.tc = new TextControl(this.tc, font);
                break;
            }
            case 1041: {
                this.popTC();
                break;
            }
            case 1018: 
            case 1088: {
                this.pushTC();
                this.tc = new TextControl(this.tc, FontInfo.setStyle(this.tc.getFont(), 1));
                break;
            }
            case 1019: 
            case 1089: {
                this.popTC();
                break;
            }
            case 1012: 
            case 1028: 
            case 1038: 
            case 1058: 
            case 1114: {
                this.pushTC();
                this.tc = new TextControl(this.tc, FontInfo.setStyle(this.tc.getFont(), 2));
                break;
            }
            case 1013: 
            case 1029: 
            case 1039: 
            case 1059: 
            case 1115: {
                this.popTC();
                break;
            }
            case 1030: 
            case 1060: 
            case 1078: 
            case 1108: {
                this.pushTC();
                this.tc = new TextControl(this.tc, FontInfo.setType(this.tc.getFont(), 1));
                break;
            }
            case 1031: 
            case 1061: 
            case 1079: 
            case 1109: {
                this.popTC();
                break;
            }
            case 1020: 
            case 1084: {
                int size = FontInfo.getSize(this.tc.getFont());
                if (val.equals("SMALL") && size > 0) {
                    --size;
                } else if (val.equals("BIG") && size < 6) {
                    ++size;
                }
                this.pushTC();
                this.tc = new TextControl(this.tc, FontInfo.setSize(this.tc.getFont(), size));
                break;
            }
            case 1021: 
            case 1085: {
                this.popTC();
                break;
            }
            case 1092: 
            case 1094: {
                int size = FontInfo.getSize(this.tc.getFont());
                if (size > 0) {
                    --size;
                }
                this.pushTC();
                this.tc = new TextControl(this.tc, FontInfo.setSize(this.tc.getFont(), size));
                if (val.equals("SUP")) {
                    ++this.textVerticalPosition;
                    break;
                }
                --this.textVerticalPosition;
                break;
            }
            case 1093: 
            case 1095: {
                this.popTC();
                if (val.equals("/SUP")) {
                    --this.textVerticalPosition;
                    break;
                }
                ++this.textVerticalPosition;
                break;
            }
            case 1110: {
                this.pushTC();
                this.tc = new TextControl(this.tc.getFont(), this.tc.getColor(), true, this.tc.getStrikeout());
                break;
            }
            case 1111: {
                this.popTC();
                break;
            }
            case 1076: 
            case 1086: {
                this.pushTC();
                this.tc = new TextControl(this.tc.getFont(), this.tc.getColor(), this.tc.getUnderline(), true);
                break;
            }
            case 1077: 
            case 1087: {
                this.popTC();
                break;
            }
            case 1006: {
                int h;
                this.doc.addBox(this.newBoxParagraph());
                int w = 0;
                boolean flag = false;
                int align = this.alignGlobal;
                param = tag.getStringParam("ALIGN", true);
                if (param != null) {
                    align = param.equals("CENTER") ? 2 : (param.equals("RIGHT") ? 3 : 1);
                }
                if ((param = tag.getStringParam("WIDTH")) != null) {
                    w = tag.getIntParam("WIDTH");
                    if (param.indexOf("%") != -1) {
                        w = -w;
                    }
                }
                if ((h = tag.getIntParam("SIZE")) <= 0) {
                    h = 3;
                }
                if (tag.isParam("NOSHADE")) {
                    flag = true;
                }
                BoxLineBreak b = new BoxHorRule(this.doc, w, h, flag);
                b.setColor(this.colorBackground);
                b.setAttrib(align);
                this.doc.addBox(b);
                b = new BoxParagraph(this.doc, this.tc.getFont());
                this.alignParagraph = this.alignGlobal;
                b.setAttrib(this.alignParagraph);
                this.doc.addBox(b);
                break;
            }
            case 1046: 
            case 1048: 
            case 1050: 
            case 1052: 
            case 1054: 
            case 1056: {
                char size = val.charAt(1);
                int font = FontInfo.setSize(this.tc.getFont(), 6 - (size - 49));
                font = FontInfo.setStyle(font, 1);
                this.pushTC();
                this.tc = new TextControl(this.tc, font);
                Box b = this.newBoxParagraph();
                param = tag.getStringParam("ALIGN", true);
                if (param != null) {
                    this.alignParagraph = param.equals("CENTER") ? 2 : (param.equals("RIGHT") ? 3 : 1);
                    b.setAttrib(this.alignParagraph);
                }
                this.doc.addBox(b);
                break;
            }
            case 1047: 
            case 1049: 
            case 1051: 
            case 1053: 
            case 1055: 
            case 1057: {
                this.popTC();
                Box b = this.newBoxParagraph();
                this.alignParagraph = this.alignGlobal;
                b.setAttrib(this.alignParagraph);
                this.doc.addBox(b);
                break;
            }
            case 1072: {
                Box b = this.newBoxParagraph();
                param = tag.getStringParam("ALIGN", true);
                this.alignParagraph = param != null ? (param.equals("CENTER") ? 2 : (param.equals("RIGHT") ? 3 : 1)) : this.alignGlobal;
                b.setAttrib(this.alignParagraph);
                this.doc.addBox(b);
                break;
            }
            case 1073: {
                Box b = this.newBoxParagraph();
                this.alignParagraph = this.alignGlobal;
                b.setAttrib(this.alignParagraph);
                this.doc.addBox(b);
                break;
            }
            case 1034: {
                Box b = new BoxLineBreak(this.doc);
                param = tag.getStringParam("ALIGN", true);
                this.alignParagraph = param != null ? (param.equals("CENTER") ? 2 : (param.equals("RIGHT") ? 3 : 1)) : this.alignGlobal;
                b.setAttrib(this.alignParagraph);
                this.doc.addBox(b);
                break;
            }
            case 1035: {
                Box b = new BoxLineBreak(this.doc);
                this.alignParagraph = this.alignGlobal;
                b.setAttrib(this.alignParagraph);
                this.doc.addBox(b);
                break;
            }
            case 1022: {
                this.doc.addBox(this.newBoxParagraph());
                ++this.indentGlobal;
                this.changeIndent(this.indentCurrent, this.indentGlobal);
                this.indentCurrent = this.indentGlobal;
                break;
            }
            case 1023: {
                this.doc.addBox(this.newBoxParagraph());
                --this.indentGlobal;
                if (this.indentGlobal < 0) {
                    this.indentGlobal = 0;
                }
                this.changeIndent(this.indentCurrent, this.indentGlobal);
                this.indentCurrent = this.indentGlobal;
                break;
            }
            case 1074: {
                this.doc.addBox(this.newBoxParagraph());
                this.lex.setPreformatted(true);
                this.pushTC();
                this.tc = new TextControl(this.tc, FontInfo.setType(this.tc.getFont(), 1));
                break;
            }
            case 1075: {
                this.lex.setPreformatted(false);
                this.popTC();
                this.doc.addBox(new BoxParagraph(this.doc, this.tc.getFont()));
                break;
            }
        }
    }

    private Box newBoxParagraph() {
        Box b = this.doc.lastBox();
        b = b != null && (b instanceof BoxParagraph || b instanceof BoxLineBreak) ? new BoxLineBreak(this.doc) : new BoxParagraph(this.doc, this.tc.getFont());
        return b;
    }

    private void changeIndent(int indentOld, int indentNew) {
        int i = indentNew - indentOld;
        if (i > 0) {
            while (i > 0) {
                --i;
                BoxLineBreak b = new BoxLineBreak(this.doc);
                b.setAttrib(9);
                this.doc.addBox(b);
            }
        } else if (i < 0) {
            while (i < 0) {
                this.list_info[indentOld + ++i].init();
                BoxLineBreak b = new BoxLineBreak(this.doc);
                b.setAttrib(10);
                this.doc.addBox(b);
            }
        } else {
            BoxLineBreak b = new BoxLineBreak(this.doc);
            this.doc.addBox(b);
        }
    }

    private void addWord(String word) {
        if (word == null) {
            return;
        }
        if (this.wordBuffer != null) {
            this.wordBuffer = this.wordBuffer.length() <= 1 || !this.lex.isTokenBreakable() ? String.valueOf(this.wordBuffer).concat(String.valueOf(word)) : String.valueOf(this.wordBuffer).concat(String.valueOf(String.valueOf(" ").concat(String.valueOf(word))));
        } else {
            Box b;
            if (this.lex.isPreformatted() && word.equals("\n")) {
                if (!(this.doc.lastBox() instanceof BoxLineBreak)) {
                    b = new BoxLineBreak(this.doc);
                    this.lastWordBox = null;
                } else {
                    b = new BoxParagraph(this.doc, this.tc.getFont());
                }
            } else {
                boolean is_break = this.lex.isTokenBreakable();
                is_break = is_break || this.doc.lastBox() instanceof BoxLineBreak || this.prevTagBreakable;
                BoxWord bb = new BoxWord(this.doc, this.tc.getFont(), word);
                bb.setBreakable(is_break);
                b = bb;
                bb.setVerticalPosition(this.textVerticalPosition);
                if (this.tc.getUnderline()) {
                    bb.setUnderline();
                }
                if (this.tc.getStrikeout()) {
                    bb.setStrikeout();
                }
                if (this.link != null) {
                    bb.setLink(this.link, this.linkTargetFrame);
                }
                bb.setColor(this.tc.getColor());
                if (this.anchor != null) {
                    bb.setAnchor(this.anchor);
                    this.anchor = null;
                }
                this.lastWordBox = bb;
            }
            this.doc.addBox(b);
        }
    }

    private String[] makeListArray(String list) {
        StringTokenizer subParser = new StringTokenizer(list, " \t\n\r,");
        String[] listArray = new String[subParser.countTokens()];
        try {
            int i = 0;
            while (subParser.hasMoreElements()) {
                listArray[i] = subParser.nextToken();
                System.out.println(listArray[i]);
                ++i;
            }
        }
        catch (NoSuchElementException e) {
            System.out.println(e);
        }
        return listArray;
    }

    private void pushTC() {
        this.tcStack.push(this.tc);
    }

    private void popTC() {
        if (!this.tcStack.empty()) {
            this.tc = (TextControl)this.tcStack.pop();
        }
    }
}

