/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BrowserTools;
import ice.htmlbrowser.BrowserURLLoader;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.Parser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;

class ProcessURL
extends Thread {
    private boolean finishedProcessing;
    private URL url;
    private DocContainer doc;
    private Parser parser;
    private String outputString;
    boolean doverbose = true;

    public ProcessURL(DocContainer doc, Parser parser, URL url, String outputString) {
        this.url = url;
        this.doc = doc;
        this.parser = parser;
        this.outputString = outputString;
    }

    public void run() {
        System.out.println("Process URL thread...");
        System.out.println("starting to process");
        URL referer = this.doc.getReferer();
        this.finishedProcessing = false;
        while (!this.finishedProcessing) {
            int iod;
            String fileName;
            String msg;
            BrowserURLLoader bl = new BrowserURLLoader(this.url, this.doc);
            URLConnection bluc = null;
            try {
                bluc = bl.openConnection();
                if (bluc == null) {
                    throw new IOException();
                }
                if (referer != null) {
                    bluc.setRequestProperty("Referer", referer.toExternalForm());
                }
                if (this.outputString != null && this.outputString.length() > 0) {
                    bluc.setDoOutput(true);
                    bluc.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                    OutputStream theControl = bluc.getOutputStream();
                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter(theControl));
                    out.write(this.outputString);
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                String msg2 = new String(String.valueOf(String.valueOf(String.valueOf("<H4>").concat(String.valueOf(this.url.toString()))).concat(String.valueOf("<BR>"))).concat(String.valueOf("Cannot open connection </H4>")));
                this.doc.parseHTMLString(msg2);
                this.finishedProcessing = true;
                return;
            }
            try {
                InputStream is = bl.getInputStream();
            }
            catch (UnknownHostException e) {
                msg = new String(String.valueOf(String.valueOf(String.valueOf("<H4>Unknown host : ").concat(String.valueOf(e.getMessage()))).concat(String.valueOf("<BR>"))).concat(String.valueOf("</H4>")));
                this.doc.parseHTMLString(msg);
                this.finishedProcessing = true;
                return;
            }
            catch (NoRouteToHostException e) {
                msg = new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf("<hr>\nAn error occurred while connecting to ").concat(String.valueOf(this.url.toString()))).concat(String.valueOf("<dl><dt>The server responded with:</dt><dd>"))).concat(String.valueOf(e.getMessage()))).concat(String.valueOf("</dd></dl><hr>")));
                this.doc.parseHTMLString(msg);
                this.finishedProcessing = true;
                return;
            }
            catch (IOException e) {
                System.out.println(String.valueOf("IO exception ").concat(String.valueOf(e)));
                e.printStackTrace();
                msg = new String(String.valueOf(String.valueOf(String.valueOf("<H4>Cannot connect to ").concat(String.valueOf(this.url.toString()))).concat(String.valueOf("<BR>"))).concat(String.valueOf("</H4>")));
                this.doc.parseHTMLString(msg);
                this.finishedProcessing = true;
                return;
            }
            String type = bl.getContentType();
            System.out.println(String.valueOf("URL type: ").concat(String.valueOf(type)));
            this.verbose(String.valueOf("Connected to: ").concat(String.valueOf(bl.getURL())));
            this.doc.setDocumentBase(bl.getURL());
            if (type == null || type.equals("text/html")) {
                this.parser.setPlainText(false);
            } else if (type.equals("text/plain")) {
                this.parser.setPlainText(true);
            } else {
                if (type.equals("image/gif") || type.equals("image/jpeg")) {
                    this.doc.htmlAppend(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("<H4>").concat(String.valueOf(this.url.toString()))).concat(String.valueOf("</H4>"))).concat(String.valueOf("<P> <CENTER><HR><IMG SRC=\""))).concat(String.valueOf(this.url.toString()))).concat(String.valueOf("\"> <HR> </CENTER>")));
                    this.finishedProcessing = true;
                    return;
                }
                fileName = new String(this.url.getFile());
                iod = fileName.lastIndexOf(46);
                if (iod >= 0) {
                    fileName = fileName.substring(iod);
                }
                if (fileName.equalsIgnoreCase(".jar")) {
                    try {
                        this.url = this.constructJamURL(this.url);
                        continue;
                    }
                    catch (MalformedURLException e2) {
                        String msg3 = new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.url.toString()).concat(String.valueOf("</tt><BR>"))).concat(String.valueOf("Something is wrong"))).concat(String.valueOf("<hr>\nAn error occurred while connecting to "))).concat(String.valueOf(this.url.toString()))).concat(String.valueOf("<dl><dt>The server responded with:</dt><dd>"))).concat(String.valueOf(e2.getMessage()))).concat(String.valueOf("</dd></dl><hr>")));
                        this.doc.parseHTMLString(msg3);
                        this.finishedProcessing = true;
                        return;
                    }
                }
                this.saveFromStream(bl);
                return;
            }
            fileName = new String(this.url.getFile());
            iod = fileName.lastIndexOf(46);
            if (iod >= 0) {
                fileName = fileName.substring(iod);
            }
            if (fileName.equalsIgnoreCase(".jar")) {
                try {
                    this.url = this.constructJamURL(this.url);
                    continue;
                }
                catch (MalformedURLException e2) {
                    String msg4 = new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.url.toString()).concat(String.valueOf("</tt><BR>"))).concat(String.valueOf("Something is wrong"))).concat(String.valueOf("<hr>\nAn error occurred while connecting to "))).concat(String.valueOf(this.url.toString()))).concat(String.valueOf("<dl><dt>The server responded with:</dt><dd>"))).concat(String.valueOf(e2.getMessage()))).concat(String.valueOf("</dd></dl><hr>")));
                    this.doc.parseHTMLString(msg4);
                    this.finishedProcessing = true;
                    e2.printStackTrace();
                    return;
                }
            }
            try {
                InputStream in = bl.getInputStream();
                this.parser.setLexReader(new InputStreamReader(in));
                this.finishedProcessing = true;
            }
            catch (IOException e) {
                System.out.println(String.valueOf("IO exception ").concat(String.valueOf(e)));
                e.printStackTrace();
                String msg5 = new String(String.valueOf(String.valueOf(String.valueOf("<H4>Cannot connect to ").concat(String.valueOf(this.url.toString()))).concat(String.valueOf("<BR>"))).concat(String.valueOf("</H4>")));
                this.doc.htmlAppend(msg5);
                return;
            }
        }
    }

    private URL constructJamURL(URL jarURL) throws MalformedURLException {
        String embeddedURL = String.valueOf(String.valueOf(String.valueOf(jarURL.getProtocol()).concat(String.valueOf("://"))).concat(String.valueOf(jarURL.getHost()))).concat(String.valueOf(jarURL.getFile()));
        String embeddedRef = jarURL.getRef();
        if (embeddedRef == null || embeddedRef.equals("")) {
            embeddedRef = "index.html";
        }
        embeddedURL = URLEncoder.encode(embeddedURL);
        String jamURLStr = String.valueOf(String.valueOf(String.valueOf("jam://").concat(String.valueOf(embeddedURL))).concat(String.valueOf("/"))).concat(String.valueOf(embeddedRef));
        URL jamURL = new URL(jamURLStr);
        return jamURL;
    }

    private void verbose(String msg) {
        System.out.println(msg);
    }

    private void saveFromStream(BrowserURLLoader bl) {
        try {
            BrowserTools st = new BrowserTools(this.doc);
            st.saveFromStream(bl.getInputStream());
        }
        catch (IOException e) {
            System.out.println(String.valueOf("IO exception ").concat(String.valueOf(e)));
            e.printStackTrace();
        }
        String msg = new String(String.valueOf(String.valueOf(String.valueOf("<H4>").concat(String.valueOf(this.url.toString()))).concat(String.valueOf("<BR>"))).concat(String.valueOf("File download complete </H4>")));
        this.doc.parseHTMLString(msg);
    }
}

