/*
 * Decompiled with CFR 0.152.
 */
package innoval.mail;

import innoval.mail.Imap4;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class Imap4LogonPrompt
extends Dialog
implements KeyListener,
ActionListener {
    private boolean ret_code = false;
    private Frame frame;
    private Imap4 imap;
    private Label text;
    private Button okButton;
    private Button cancelButton;
    private TextField server;
    private TextField userid;
    private TextField password;
    private TextField port;

    Imap4LogonPrompt(Frame frame, Imap4 imap) {
        super(frame, "Connect to an IMAP4 Server", true);
        this.frame = frame;
        this.imap = imap;
        this.initDialog();
        this.enableEvents(64L);
        this.show();
    }

    public boolean getReturn() {
        return this.ret_code;
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 5, 20, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 120, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Server Name", 2);
        this.add(label);
        this.reset(con);
        con.gridx = 0;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(label, con);
        label = new Label("Userid", 2);
        this.add(label);
        this.reset(con);
        con.gridx = 0;
        con.gridy = 3;
        con.gridwidth = 2;
        grid.setConstraints(label, con);
        label = new Label("Password", 2);
        this.add(label);
        this.reset(con);
        con.gridx = 0;
        con.gridy = 5;
        con.gridwidth = 2;
        grid.setConstraints(label, con);
        label = new Label("Port Number", 2);
        this.add(label);
        this.reset(con);
        con.gridx = 0;
        con.gridy = 7;
        con.gridwidth = 2;
        grid.setConstraints(label, con);
        this.server = new TextField();
        this.add(this.server);
        this.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(this.server, con);
        this.userid = new TextField();
        this.add(this.userid);
        this.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        con.gridwidth = 2;
        grid.setConstraints(this.userid, con);
        this.password = new TextField();
        this.password.setEchoChar('*');
        this.add(this.password);
        this.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        con.gridwidth = 2;
        grid.setConstraints(this.password, con);
        this.port = new TextField();
        this.add(this.port);
        this.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        con.gridwidth = 2;
        grid.setConstraints(this.port, con);
        ((TextComponent)this.server).setText(this.imap.getServer());
        ((TextComponent)this.userid).setText(this.imap.getUserid());
        ((TextComponent)this.password).setText(this.imap.getPassword());
        ((TextComponent)this.port).setText(String.valueOf("").concat(String.valueOf(this.imap.getPort())));
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.add(this.okButton);
        this.text = new Label("");
        this.add(this.text);
        this.reset(con);
        con.gridx = 1;
        con.gridy = 9;
        con.gridwidth = 3;
        grid.setConstraints(this.text, con);
        this.reset(con);
        con.gridx = 1;
        con.gridy = 11;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.add(this.cancelButton);
        this.reset(con);
        con.gridx = 3;
        con.gridy = 11;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        this.centerDialog(null, this.frame);
    }

    private void reset(GridBagConstraints con) {
        con.gridx = -1;
        con.gridy = -1;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.weightx = 0.0;
        con.weighty = 0.0;
        con.anchor = 10;
        con.fill = 1;
        con.insets = new Insets(0, 0, 0, 0);
        con.ipadx = 0;
        con.ipady = 0;
    }

    private void centerDialog(Dialog d, Frame f) {
        int yPos;
        int xPos;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int dWidth = d.getSize().width;
        int dHeight = d.getSize().height;
        if (f == null) {
            xPos = (screen.width - dWidth) / 2;
            yPos = (screen.height - dHeight) / 2;
        } else {
            xPos = f.getLocation().x + f.getSize().width / 2 - dWidth / 2;
            yPos = f.getLocation().y + f.getSize().height / 2 - dHeight / 2;
        }
        if (xPos < 0) {
            xPos = (screen.width - dWidth) / 2;
        }
        if (yPos < 0) {
            yPos = (screen.width - dHeight) / 2;
        }
        if (xPos + dWidth > screen.width) {
            xPos = screen.width - dWidth - 10;
        }
        if (yPos + dHeight > screen.height) {
            yPos = screen.height - dHeight - 10;
        }
        ((Component)d).setBounds(xPos, yPos, dWidth, dHeight);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.checkValues()) {
                this.imap.setServer(this.server.getText());
                this.imap.setUserid(this.userid.getText());
                this.imap.setPassword(this.password.getText());
                this.imap.setPort(Integer.valueOf(this.port.getText()));
                this.ret_code = true;
                this.closeWindow();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.closeWindow();
        }
    }

    private boolean checkValues() {
        boolean ret_code = false;
        if (this.server.getText().trim().length() == 0) {
            this.text.setText("Please enter a server name.");
            this.server.requestFocus();
        } else if (this.userid.getText().trim().length() == 0) {
            this.text.setText("Please enter a userid.");
            this.userid.requestFocus();
        } else if (this.password.getText().trim().length() == 0) {
            this.text.setText("Please enter a password.");
            this.password.requestFocus();
        } else if (this.port.getText().trim().length() == 0) {
            this.text.setText("Please enter a port number.");
            this.port.requestFocus();
        } else {
            try {
                int num = Integer.valueOf(this.port.getText().trim());
                ret_code = true;
            }
            catch (NumberFormatException e) {
                this.text.setText("The specified port number is invalid.");
                this.port.requestFocus();
            }
        }
        return ret_code;
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.closeWindow();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void closeWindow() {
        try {
            this.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

