/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AddressBook;
import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class AddAddress
extends Dialog
implements KeyListener,
ActionListener {
    public boolean ret_code;
    private AddressBook addrbook;
    private Frame frame;
    private Button okButton;
    private Button cancelButton;
    private Checkbox shortCheck;
    private TextField nickField = new TextField();
    private TextField addrField = new TextField();
    private TextField nameField = new TextField();
    private TextField orgField = new TextField();

    AddAddress(Frame frame, AddressBook addrbook, String addr) {
        super(frame, "Add a New Address", true);
        this.frame = frame;
        this.addrbook = addrbook;
        this.parseAddress(addr);
        this.setupDialog();
        this.show();
    }

    private void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 5, 20, 5, 20, 15, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 150, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Nickname", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.nickField.addKeyListener(this);
        this.add(this.nickField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.nickField, con);
        label = new Label("Email Address", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.addrField.addKeyListener(this);
        this.add(this.addrField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        grid.setConstraints(this.addrField, con);
        label = new Label("Full Name", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.nameField.addKeyListener(this);
        this.add(this.nameField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        grid.setConstraints(this.nameField, con);
        label = new Label("Organization", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.orgField.addKeyListener(this);
        this.add(this.orgField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 7;
        grid.setConstraints(this.orgField, con);
        this.shortCheck = new Checkbox("Short list");
        this.add(this.shortCheck);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 9;
        grid.setConstraints(this.shortCheck, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 11;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 11;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
    }

    private void parseAddress(String text) {
        int spot = text.indexOf(60);
        if (spot >= 0) {
            ((TextComponent)this.nameField).setText(text.substring(0, spot).trim());
            text = new String(text.substring(spot + 1));
            spot = text.indexOf(62);
            if (spot >= 0) {
                text = new String(text.substring(0, spot).trim());
            }
            ((TextComponent)this.addrField).setText(text.trim());
        } else {
            ((TextComponent)this.addrField).setText(text.trim());
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.addToBook()) {
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private boolean addToBook() {
        MsgBox msg;
        boolean ret_code = true;
        if (ret_code && this.nickField.getText().trim().length() == 0) {
            msg = new MsgBox(this.frame, "Please enter a nickname value.");
            this.nickField.requestFocus();
            ret_code = false;
        }
        if (ret_code && this.addrbook.checkNickname(this.nickField.getText().trim())) {
            msg = new MsgBox(this.frame, "The specified nickname is not unique within the the current address book.");
            ret_code = false;
            this.nickField.requestFocus();
        }
        if (ret_code && this.addrField.getText().trim().length() == 0) {
            msg = new MsgBox(this.frame, "Please enter an email address.");
            this.addrField.requestFocus();
            ret_code = false;
        }
        if (ret_code && this.nameField.getText().trim().length() == 0 && this.orgField.getText().trim().length() == 0) {
            msg = new MsgBox(this.frame, "Please enter a full name or organization.");
            this.nameField.requestFocus();
            ret_code = false;
        }
        if (ret_code) {
            ret_code = this.addrbook.addAddress(this.nickField.getText().trim(), this.addrField.getText().trim(), this.nameField.getText().trim(), this.orgField.getText().trim(), this.shortCheck.getState());
        }
        return ret_code;
    }
}

