/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import borland.jbcl.control.BevelPanel;
import innoval.mailer.AddrBookLoad;
import innoval.mailer.AddrBookSettings;
import innoval.mailer.Address;
import innoval.mailer.AddressBook;
import innoval.mailer.AddressBookFilter;
import innoval.mailer.AddressGroup;
import innoval.mailer.AutoRefresh;
import innoval.mailer.FolderField;
import innoval.mailer.FolderItem;
import innoval.mailer.ImportAddressBook;
import innoval.mailer.JList;
import innoval.mailer.JTabPanel;
import innoval.mailer.JTextArea;
import innoval.mailer.MsgBox;
import innoval.mailer.NewAddressBook;
import innoval.mailer.Profile;
import innoval.mailer.SelectAddressBook;
import innoval.mailer.SelectFolder;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.VirtualFolderFrame;
import innoval.mailer.VirtualFolderList;
import innoval.mailer.jstreet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import jclass.util.JCVector;

public class AddrBook
extends Dialog
implements ActionListener,
ItemListener {
    static final int NICKNAME = 0;
    static final int FULLNAME = 1;
    static final int EMAIL = 2;
    static final int ORGANIZATION = 3;
    static final int GROUPS = 4;
    static final int SORTFIRSTWORD = 0;
    static final int SORTLASTWORD = 1;
    static final String SAVENAME = new String("AddressBook");
    static final String LASTBOOK = new String("LastAddressBookFile");
    static final String ADDRBOOKMARKER = new String("ADDRESS BOOK");
    private jstreet parent;
    private Frame frame;
    private AddrBookLoad addrbookload;
    private Panel listPanel;
    private Panel detPanel;
    private Panel namePanel;
    private Panel morePanel;
    private Panel groupPanel;
    public Vector indexVector = new Vector();
    private Choice sortchoice;
    private Choice alertChoice;
    private JTabPanel notebook;
    private CardLayout cardlayout;
    private boolean initialized = false;
    private Checkbox shortCheck;
    private Checkbox shortListCheck;
    private Checkbox groupshortCheck;
    private Checkbox commaButton;
    private Checkbox editCheck = new Checkbox();
    private Checkbox moreeditCheck;
    private Button toallButton;
    private Button ccallButton;
    private Button bccallButton;
    private Button toButton;
    private Button ccButton;
    private Button bccButton;
    private Button virtButton;
    private Button folderButton;
    private Button okButton;
    private Button undoButton;
    private Button newButton;
    private Button copyButton;
    private Button deleteButton;
    private Button groupAddButton;
    private Button groupDelButton;
    private Button groupOkButton;
    private Button groupCopyButton;
    private Button groupCancelButton;
    private Button groupNewButton;
    private Button groupRemoveButton;
    private Button moreokButton;
    private Button moreundoButton;
    private Button morenewButton;
    private Button morecopyButton;
    private Button moredeleteButton;
    private JList mainList;
    private JList nicklist;
    private JList glist;
    private List remoteList;
    private FolderField folderText;
    private TextField nicknameText;
    private TextField emailText;
    private TextField fullnameText;
    private TextField titleText;
    private TextField orgText;
    private TextField faxText;
    private TextField phoneText;
    private TextField nickgroupText;
    private TextField namegroupText;
    private TextField remoteFolder;
    private TextComponent remoteEntry;
    private Label sortLabel;
    private Label nickmoreLabel;
    private Label emailmoreLabel;
    private Label namemoreLabel;
    private Label groupLabel;
    private JTextArea notesText;
    private JTextArea postaddrText;
    private int activeIndex = -1;
    private int currentStyle;
    private Button IDM_FILE_EXIT;
    private Button IDM_FILE_NEW;
    private Button IDM_FILE_OPEN;
    private Button IDM_FILE_IMPORT;
    private Button IDM_FILE_SAVEAS;
    private Button IDM_FILE_SETTINGS;
    private Button IDM_GOTO;
    private Profile profile;
    private AddressBook addrbook = null;

    AddrBook(Frame frame, jstreet parent, AddressBook addrbook) {
        super(frame, "Address Book", true);
        if (addrbook != null && !addrbook.exists()) {
            addrbook = null;
        }
        this.frame = frame;
        this.profile = parent.getProfile();
        this.parent = parent;
        this.remoteList = null;
        this.remoteEntry = null;
        this.addrbookload = null;
        this.addrbook = addrbook;
        this.initAddrBook();
        if (addrbook != null || this.getNewAddressBook(true)) {
            this.setProfile(parent.getProfile());
            this.enableEvents(64L);
        }
    }

    public void setProfile(Profile profile) {
        this.activeIndex = -1;
        if (this.addrbook != null) {
            this.readAddrBook();
            this.currentStyle = this.addrbook.getSortType();
            this.sortchoice.select(this.currentStyle);
        } else {
            this.setFrameTitle();
        }
        this.loadListBox(true);
        this.notebook.setSelectedIndex(0);
    }

    public String getName() {
        String name = "";
        if (this.addrbook != null) {
            name = this.addrbook.getName();
        }
        return name;
    }

    public String getFileName() {
        String name = "";
        if (this.addrbook != null) {
            name = this.addrbook.getFileName();
        }
        return name;
    }

    public void setRemoteList(List list) {
        this.remoteList = list;
    }

    public void setRemoteEntry(TextComponent remoteEntry) {
        this.remoteEntry = remoteEntry;
    }

    public void setRemoteFolder(TextField remoteFolder) {
        this.remoteFolder = remoteFolder;
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void Close() {
        boolean go = false;
        if (this.addrbook == null) {
            if (this.mainList.getItemCount() > 0) {
                this.saveBookAs();
            }
            this.dispose();
            go = true;
        } else if (this.activeIndex < 0 || this.saveValues(false)) {
            this.dispose();
            go = true;
        }
    }

    public void saveLastAddrBook() {
        if (this.addrbook != null) {
            String text = new String(this.addrbook.getFileName());
            if (text.toLowerCase().startsWith(this.parent.getSystemDir().toLowerCase())) {
                text = new String(text.substring(this.parent.getSystemDir().length()));
            }
            this.profile.WriteString(SAVENAME, LASTBOOK, text, true);
        }
    }

    public boolean getNewAddressBook(boolean parm) {
        boolean ret_code = false;
        NewAddressBook newbook = new NewAddressBook(this.frame, this.parent, parm);
        if (newbook.getName() != null) {
            this.clearAddressBook();
            this.addrbook = new AddressBook(this.frame, this.parent, new File(newbook.getName()));
            if (this.addrbook.exists()) {
                this.readAddrBook();
            } else {
                this.editCheck.setState(true);
                this.setEditEnabled(this.editCheck.getState());
            }
            this.loadListBox(true);
            this.saveLastAddrBook();
            this.setFrameTitle();
            ret_code = true;
        }
        return ret_code;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.IDM_FILE_EXIT) {
            this.Close();
        } else if (e.getSource() == this.IDM_FILE_NEW) {
            if (this.activeIndex < 0 || this.saveValues(false)) {
                this.getNewAddressBook(false);
            }
        } else if (e.getSource() == this.IDM_FILE_OPEN) {
            SelectAddressBook selectbook;
            if ((this.activeIndex < 0 || this.saveValues(false)) && (selectbook = new SelectAddressBook(this.frame, this.parent)).getName() != null) {
                this.clearAddressBook();
                this.addrbook = new AddressBook(this.frame, this.parent, new File(selectbook.getName()));
                this.readAddrBook();
                this.loadListBox(true);
                this.saveLastAddrBook();
                this.setFrameTitle();
            }
        } else if (e.getSource() == this.IDM_FILE_SAVEAS) {
            this.saveBookAs();
        } else if (e.getSource() == this.IDM_FILE_IMPORT) {
            this.saveValues(false);
            ImportAddressBook selectbook = new ImportAddressBook(this.frame, this);
        } else if (e.getSource() == this.okButton || e.getSource() == this.moreokButton || e.getSource() == this.groupOkButton) {
            this.saveValues(false);
        } else if (e.getSource() == this.undoButton || e.getSource() == this.groupCancelButton || e.getSource() == this.moreundoButton) {
            this.reloadValues();
        } else if (e.getSource() == this.newButton || e.getSource() == this.morenewButton || e.getSource() == this.groupNewButton) {
            if (this.saveValues(false)) {
                this.clearValues();
                this.deSelect();
                if (this.currentStyle == 4) {
                    this.nickgroupText.requestFocus();
                } else {
                    this.nicknameText.requestFocus();
                }
            }
        } else if (e.getSource() == this.copyButton || e.getSource() == this.groupCopyButton || e.getSource() == this.morecopyButton) {
            if (this.saveValues(false)) {
                this.copyValues();
                this.deSelect();
            }
        } else if (e.getSource() == this.deleteButton || e.getSource() == this.moredeleteButton || e.getSource() == this.groupDelButton) {
            this.deleteValue();
        } else if (e.getSource() == this.folderButton) {
            SelectFolder selectfolder = new SelectFolder(this.frame, this.parent, this.parent.CurrentDirectory, true, true);
            selectfolder.show();
            if (selectfolder.ret_code) {
                switch (selectfolder.getSelection()) {
                    case 10: {
                        this.folderText.setText(FolderItem.CURRENTMONTH);
                        break;
                    }
                    case 11: {
                        this.folderText.setText("<none>");
                        break;
                    }
                    default: {
                        FolderItem folder = selectfolder.getSelectedFolder();
                        this.folderText.setText(folder.getPath().getAbsolutePath());
                    }
                }
            }
            selectfolder = null;
        } else if (e.getSource() == this.groupAddButton) {
            String[] nicks = this.nicklist.getSelectedItems();
            for (int i = 0; i < nicks.length; ++i) {
                if (this.inList(this.glist, nicks[i])) continue;
                this.glist.addItem(nicks[i].toUpperCase());
            }
        } else if (e.getSource() == this.groupRemoveButton) {
            int[] nicks = this.glist.getSelectedIndexes();
            for (int i = nicks.length - 1; i >= 0; --i) {
                this.glist.delItem(nicks[i]);
            }
        } else if (e.getSource() == this.IDM_FILE_SETTINGS) {
            if (this.nicknameText.getText().trim().length() == 0 || this.saveValues(false)) {
                AddrBookSettings settings = new AddrBookSettings(this.frame, this, this.addrbook);
                settings.show();
                if (settings.getReturn()) {
                    this.addrbook.save();
                    this.clearValues();
                    this.loadListBox(true);
                }
            }
        } else if (e.getSource() == this.toallButton || e.getSource() == this.ccallButton || e.getSource() == this.bccallButton) {
            if (this.saveValues(false)) {
                this.processAddrButton(e, true);
            }
        } else if (e.getSource() == this.toButton || e.getSource() == this.ccButton || e.getSource() == this.bccButton) {
            if (this.activeIndex >= 0) {
                if (this.saveValues(false)) {
                    this.processAddrButton(e, false);
                }
            } else {
                MsgBox settings = new MsgBox(this, "No address is currently selected.");
            }
        } else if (e.getSource() == this.virtButton) {
            Vector addrvect = this.getSelectedAddresses(false);
            if (addrvect != null && addrvect.size() > 0) {
                this.Close();
                this.makeVirtualFolder(addrvect);
            }
        } else if (e.getSource() == this.IDM_GOTO) {
            String text = this.IDM_GOTO.getLabel();
            if (!(this.nickgroupText.getText().trim().length() == 0 && this.nicknameText.getText().trim().length() == 0 || this.saveValues(false))) {
                ((CheckboxMenuItem)e.getSource()).setState(false);
            } else {
                if (text.equals("Groups")) {
                    this.IDM_GOTO.setLabel("Individuals");
                } else {
                    this.IDM_GOTO.setLabel("Groups");
                }
                this.clearValues();
                if (text.equals("Individuals")) {
                    this.currentStyle = this.sortchoice.getSelectedIndex();
                    this.groupLabel.setVisible(false);
                    this.sortchoice.setVisible(true);
                    this.sortLabel.setVisible(true);
                    this.cardlayout.show(this.detPanel, "notebook");
                } else if (text.equals("Groups")) {
                    this.currentStyle = 4;
                    this.sortchoice.setVisible(false);
                    this.sortLabel.setVisible(false);
                    this.groupLabel.setVisible(true);
                    this.cardlayout.show(this.detPanel, "grouppanel");
                }
                this.loadListBox(true);
            }
        }
    }

    public void makeVirtualFolder(Vector addr) {
        String[] parmList = new String[addr.size()];
        String[] srchFolderList = this.getFolderList();
        for (int i = 0; i < addr.size(); ++i) {
            parmList[i] = SettingsAdvanced.formatAddress((String)addr.elementAt(i));
        }
        VirtualFolderList list = new VirtualFolderList(this.parent, VirtualFolderFrame.VF_FROMTO, parmList, srchFolderList);
        list.load();
    }

    private String[] getFolderList() {
        Vector folderVector = new Vector();
        for (FolderItem item = (FolderItem)this.parent.folderlist.getFolderRootNode().getChildren().getFirst(); item != null; item = item.getNext()) {
            if (item.isTrash()) continue;
            if (item.getName().equals(jstreet.PRINTQUEUE)) continue;
            this.getFolderChildList(folderVector, item);
        }
        String[] srchFolderList = new String[folderVector.size()];
        for (int i = 0; i < folderVector.size(); ++i) {
            srchFolderList[i] = new String((String)folderVector.elementAt(i));
        }
        return srchFolderList;
    }

    private void getFolderChildList(Vector folderVector, FolderItem item) {
        folderVector.addElement(item.getPath().getAbsolutePath());
        JCVector children = item.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                FolderItem childItem = (FolderItem)children.elementAt(i);
                this.getFolderChildList(folderVector, childItem);
            }
        }
    }

    private Vector getSelectedAddresses(boolean includeall) {
        Vector<String> vector = new Vector<String>();
        boolean quit = false;
        int z = 0;
        AddressGroup group = null;
        Address addr = null;
        String tadr = null;
        if (this.currentStyle == 4) {
            while (!quit) {
                if (includeall) {
                    group = this.addrbook.getGroup(z++);
                    if (z >= this.addrbook.groupSize()) {
                        quit = true;
                    }
                } else {
                    if (this.activeIndex >= 0) {
                        group = this.addrbook.getGroup(this.activeIndex);
                    }
                    quit = true;
                }
                if (group == null) continue;
                for (int i = 0; i < group.size(); ++i) {
                    tadr = this.addrbook.resolveNickname(group.get(i));
                    if (tadr == null) continue;
                    vector.addElement(tadr);
                }
            }
        } else {
            while (!quit) {
                if (includeall) {
                    addr = this.addrbook.getAddress(z++);
                    if (z >= this.addrbook.addressSize()) {
                        quit = true;
                    }
                } else {
                    if (this.activeIndex >= 0) {
                        addr = this.addrbook.getAddress(this.activeIndex);
                    }
                    quit = true;
                }
                if (addr == null) continue;
                vector.addElement(new String(this.addrbook.formatAddress(addr)));
            }
        }
        return vector;
    }

    public void goToFront(TextComponent text) {
        Container frame;
        for (frame = text.getParent(); frame != null && !(frame instanceof Frame); frame = frame.getParent()) {
        }
        if (frame != null) {
            ((Frame)frame).toFront();
        }
    }

    private void processAddrButton(ActionEvent e, boolean includeall) {
        String prefix = "";
        if (e.getSource() == this.toButton || e.getSource() == this.toallButton) {
            prefix = new String("To: ");
        } else if (e.getSource() == this.ccButton || e.getSource() == this.ccallButton) {
            prefix = new String("cc: ");
        } else if (e.getSource() == this.bccButton || e.getSource() == this.bccallButton) {
            prefix = new String("bcc: ");
        }
        if (this.currentStyle == 4) {
            String addrlist = "";
            boolean quit = false;
            int z = 0;
            AddressGroup group = null;
            while (!quit) {
                if (includeall) {
                    group = this.addrbook.getGroup(z++);
                    if (z >= this.addrbook.groupSize()) {
                        quit = true;
                    }
                } else {
                    group = this.addrbook.getGroup(this.activeIndex);
                    quit = true;
                }
                for (int i = 0; i < group.size(); ++i) {
                    String addr = this.addrbook.resolveNickname(group.get(i));
                    if (addr == null) continue;
                    addr = new String(String.valueOf(prefix).concat(String.valueOf(addr)));
                    if (this.remoteList != null) {
                        this.remoteList.addItem(addr);
                        continue;
                    }
                    addrlist = addrlist.length() > 0 ? new String(String.valueOf(String.valueOf(addrlist).concat(String.valueOf(","))).concat(String.valueOf(addr))) : new String(addr);
                }
            }
            if (this.remoteEntry != null) {
                String adr = this.remoteEntry.getText();
                adr = adr.length() > 0 ? new String(String.valueOf(String.valueOf(adr).concat(String.valueOf(","))).concat(String.valueOf(addrlist))) : new String(addrlist);
                this.remoteEntry.setText(adr);
                this.addedFeedback(e.getSource());
            } else if (this.remoteList == null) {
                this.Close();
                this.parent.composeAddress(this.parent, addrlist, "");
            }
        } else {
            boolean quit = false;
            int z = 0;
            String addrlist = null;
            String tadr = null;
            Address addr = null;
            while (!quit) {
                if (includeall) {
                    addr = this.addrbook.getAddress(z++);
                    if (z >= this.addrbook.addressSize()) {
                        quit = true;
                    }
                } else {
                    addr = this.addrbook.getAddress(this.activeIndex);
                    quit = true;
                }
                tadr = new String(String.valueOf(prefix).concat(String.valueOf(this.addrbook.formatAddress(addr))));
                if (addrlist == null) {
                    addrlist = new String(tadr);
                    continue;
                }
                addrlist = new String(String.valueOf(String.valueOf(addrlist).concat(String.valueOf(","))).concat(String.valueOf(tadr)));
            }
            if (this.remoteList != null) {
                int spot = 0;
                do {
                    if ((spot = addrlist.indexOf(44)) >= 0) {
                        this.remoteList.addItem(addrlist.substring(0, spot));
                        addrlist = new String(addrlist.substring(spot + 1));
                        continue;
                    }
                    this.remoteList.addItem(addrlist);
                } while (spot >= 0);
                this.addedFeedback(e.getSource());
            } else if (this.remoteEntry != null) {
                String adr = this.remoteEntry.getText();
                adr = adr.length() > 0 ? new String(String.valueOf(String.valueOf(adr).concat(String.valueOf(","))).concat(String.valueOf(addrlist))) : new String(addrlist);
                this.remoteEntry.setText(adr);
                if (this.remoteFolder != null && this.folderText.getText().length() > 0) {
                    ((TextComponent)this.remoteFolder).setText(this.folderText.getText());
                }
                this.addedFeedback(e.getSource());
            } else {
                this.Close();
                this.parent.composeAddress(this.parent, addrlist, this.folderText.getText());
            }
        }
    }

    private void addedFeedback(Object val) {
        if (val instanceof Button) {
            Button button = (Button)val;
            String text = button.getLabel();
            Color color = button.getForeground();
            button.setForeground(Color.red);
            button.setLabel("Added");
            AutoRefresh.Sleep(400L);
            button.setLabel(text);
            button.setForeground(color);
        }
    }

    public void setAddressBook(String bookfile) {
        if (this.activeIndex < 0 || this.saveValues(false)) {
            this.clearAddressBook();
            this.addrbook = null;
            this.addrbook = new AddressBook(this.frame, this.parent, new File(bookfile));
            this.readAddrBook();
            this.loadListBox(true);
            this.saveLastAddrBook();
            this.setFrameTitle();
        }
    }

    public boolean inList(List list, String text) {
        boolean ret_code = false;
        String[] val = list.getItems();
        for (int i = 0; i < val.length; ++i) {
            if (!val[i].equalsIgnoreCase(text)) continue;
            ret_code = true;
            break;
        }
        return ret_code;
    }

    public boolean saveBookAs() {
        NewAddressBook newbook;
        boolean ret_code = false;
        if ((this.activeIndex < 0 || this.saveValues(false)) && (newbook = new NewAddressBook(this.frame, this.parent, "Save As")).getName() != null) {
            String file = newbook.getName();
            this.addrbook.setFile(new File(file));
            this.addrbook.save();
            this.saveLastAddrBook();
            this.setFrameTitle();
            ret_code = true;
        }
        return ret_code;
    }

    public void deSelect() {
        int ind = this.mainList.getSelectedIndex();
        if (ind >= 0) {
            this.mainList.deselect(ind);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.sortchoice && e.getStateChange() == 1) {
            if (this.saveValues(false)) {
                this.clearValues();
                this.currentStyle = this.sortchoice.getSelectedIndex();
                this.addrbook.setSortType(this.currentStyle);
                this.loadListBox(true);
            }
        } else if (e.getSource() == this.mainList && e.getStateChange() == 1) {
            if (this.activeIndex < 0 || this.saveValues(false)) {
                this.loadDetail();
            }
            if (this.activeIndex >= 0) {
                this.mainList.select(this.getListIndex(this.activeIndex));
            }
        } else if (e.getSource() == this.shortCheck && (e.getStateChange() == 1 || e.getStateChange() == 2)) {
            if (this.activeIndex < 0 || this.saveValues(false)) {
                this.clearValues();
                this.loadListBox(true);
            }
        } else if (!(e.getSource() != this.editCheck && e.getSource() != this.moreeditCheck || e.getStateChange() != 1 && e.getStateChange() != 2)) {
            if (e.getSource() == this.editCheck) {
                this.moreeditCheck.setState(this.editCheck.getState());
            } else {
                this.editCheck.setState(this.moreeditCheck.getState());
            }
            if (!this.editCheck.getState() && this.activeIndex >= 0) {
                this.saveValues(true);
            }
            this.setEditEnabled(this.editCheck.getState());
        }
    }

    public void loadDetail() {
        switch (this.currentStyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.loadAddress();
                break;
            }
            case 4: {
                this.loadGroup();
            }
        }
    }

    public void initAddrBook() {
        this.listPanel = new Panel();
        this.setupListPanel(this.listPanel);
        this.detPanel = new Panel();
        this.cardlayout = new CardLayout();
        this.detPanel.setLayout(this.cardlayout);
        this.notebook = new JTabPanel();
        this.notebook.setPreferredSize(100, 100);
        this.detPanel.add((Component)this.notebook, "notebook");
        this.setupNamePanel();
        this.setupMorePanel();
        this.setupGroupPanel();
        this.setEditEnabled(false);
        this.setLayout(new BorderLayout());
        this.add("North", this.setupButtonBar());
        BevelPanel panel = new BevelPanel();
        panel.setLayout(new BorderLayout());
        panel.add("West", this.listPanel);
        panel.add("East", this.detPanel);
        this.add("Center", panel);
        this.pack();
        this.groupLabel.setVisible(false);
        Dimension dim = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
    }

    public void setFrameTitle() {
        String text = null;
        text = this.addrbook == null ? new String("Address Book [<new>]") : (this.addrbook.getFileName().startsWith(this.parent.getAccountDir()) ? new String(String.valueOf(String.valueOf("Address Book [").concat(String.valueOf(this.addrbook.getName()))).concat(String.valueOf(" (Private)]"))) : new String(String.valueOf(String.valueOf("Address Book [").concat(String.valueOf(this.addrbook.getName()))).concat(String.valueOf(" (Public)]"))));
        this.setTitle(text);
    }

    private BevelPanel setupButtonBar() {
        BevelPanel panel = new BevelPanel();
        panel.setBevelInner(2);
        panel.setBevelOuter(2);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 60, 5, 60, 5, 60, 5, 120, 5, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.IDM_FILE_NEW = new Button("New");
        this.IDM_FILE_NEW.addActionListener(this);
        panel.add(this.IDM_FILE_NEW);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.IDM_FILE_NEW, con);
        this.IDM_FILE_OPEN = new Button("Open");
        this.IDM_FILE_OPEN.addActionListener(this);
        panel.add(this.IDM_FILE_OPEN);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        grid.setConstraints(this.IDM_FILE_OPEN, con);
        this.IDM_FILE_SAVEAS = new Button("Save As");
        this.IDM_FILE_SAVEAS.addActionListener(this);
        panel.add(this.IDM_FILE_SAVEAS);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.IDM_FILE_SAVEAS, con);
        this.IDM_FILE_IMPORT = new Button("Import");
        this.IDM_FILE_IMPORT.addActionListener(this);
        panel.add(this.IDM_FILE_IMPORT);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 1;
        grid.setConstraints(this.IDM_FILE_IMPORT, con);
        this.IDM_FILE_SETTINGS = new Button("Settings");
        this.IDM_FILE_SETTINGS.addActionListener(this);
        panel.add(this.IDM_FILE_SETTINGS);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 1;
        grid.setConstraints(this.IDM_FILE_SETTINGS, con);
        this.IDM_GOTO = new Button("Groups");
        this.IDM_GOTO.addActionListener(this);
        panel.add(this.IDM_GOTO);
        jstreet.reset(con);
        con.gridx = 11;
        con.gridy = 1;
        grid.setConstraints(this.IDM_GOTO, con);
        this.IDM_FILE_EXIT = new Button("Close");
        this.IDM_FILE_EXIT.addActionListener(this);
        panel.add(this.IDM_FILE_EXIT);
        jstreet.reset(con);
        con.gridx = 13;
        con.gridy = 1;
        grid.setConstraints(this.IDM_FILE_EXIT, con);
        panel.setLayout(grid);
        return panel;
    }

    public void setupListPanel(Panel listPanel) {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{10, 20, 20, 10, 100, 80, 5, 20, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.sortLabel = new Label("List by:", 2);
        listPanel.add(this.sortLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.sortLabel, con);
        this.groupLabel = new Label("Address Groups");
        listPanel.add(this.groupLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 5;
        grid.setConstraints(this.groupLabel, con);
        this.sortchoice = new Choice();
        this.sortchoice.addItem("Nicknames");
        this.sortchoice.addItem("Full names");
        this.sortchoice.addItem("Email addresses");
        this.sortchoice.addItem("Organization");
        listPanel.add(this.sortchoice);
        this.sortchoice.addItemListener(this);
        this.sortchoice.select(0);
        this.currentStyle = 0;
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(this.sortchoice, con);
        this.shortCheck = new Checkbox("Short list");
        this.shortCheck.addItemListener(this);
        listPanel.add(this.shortCheck);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        grid.setConstraints(this.shortCheck, con);
        this.mainList = new JList(0, false);
        this.mainList.setPreferredSize(30, 30);
        this.mainList.addItemListener(this);
        listPanel.add(this.mainList);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 4;
        con.gridwidth = 5;
        con.gridheight = 2;
        con.fill = 1;
        grid.setConstraints(this.mainList, con);
        this.toButton = new Button("To:");
        this.toButton.addActionListener(this);
        listPanel.add(this.toButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(this.toButton, con);
        this.ccButton = new Button("Cc:");
        this.ccButton.addActionListener(this);
        listPanel.add(this.ccButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        grid.setConstraints(this.ccButton, con);
        this.bccButton = new Button("Bcc:");
        this.bccButton.addActionListener(this);
        listPanel.add(this.bccButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 7;
        grid.setConstraints(this.bccButton, con);
        this.virtButton = new Button("Virtual folder");
        this.virtButton.addActionListener(this);
        listPanel.add(this.virtButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 9;
        con.gridwidth = 5;
        grid.setConstraints(this.virtButton, con);
        this.toallButton = new Button("To: All");
        this.toallButton.addActionListener(this);
        listPanel.add(this.toallButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 11;
        grid.setConstraints(this.toallButton, con);
        this.ccallButton = new Button("Cc: All");
        this.ccallButton.addActionListener(this);
        listPanel.add(this.ccallButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 11;
        grid.setConstraints(this.ccallButton, con);
        this.bccallButton = new Button("Bcc: All");
        this.bccallButton.addActionListener(this);
        listPanel.add(this.bccallButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 11;
        grid.setConstraints(this.bccallButton, con);
        listPanel.setLayout(grid);
    }

    public void setupNamePanel() {
        this.namePanel = new Panel();
        this.notebook.add((Component)this.namePanel, "Page 1");
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 5, 20, 5, 20, 5, 20, 80, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 45, 5, 45, 5, 45, 5, 45, 5, 45, 1, 1, 1};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Nickname", 2);
        this.namePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 1;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.nicknameText = new TextField();
        this.namePanel.add(this.nicknameText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(this.nicknameText, con);
        this.shortListCheck = new Checkbox("Short list");
        this.namePanel.add(this.shortListCheck);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(this.shortListCheck, con);
        label = new Label("Email address", 2);
        this.namePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 3;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.emailText = new TextField();
        this.namePanel.add(this.emailText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        con.gridwidth = 7;
        grid.setConstraints(this.emailText, con);
        label = new Label("Full name", 2);
        this.namePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 5;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.fullnameText = new TextField();
        this.namePanel.add(this.fullnameText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        con.gridwidth = 7;
        grid.setConstraints(this.fullnameText, con);
        label = new Label("Organization", 2);
        this.namePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 7;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.orgText = new TextField();
        this.namePanel.add(this.orgText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 7;
        con.gridwidth = 7;
        grid.setConstraints(this.orgText, con);
        this.alertChoice = new Choice();
        label = new Label("Sent folder", 2);
        this.namePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 9;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.folderText = new FolderField("", this.parent);
        this.namePanel.add(this.folderText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 9;
        con.gridwidth = 5;
        grid.setConstraints(this.folderText, con);
        this.folderButton = new Button("Select");
        this.folderButton.addActionListener(this);
        this.namePanel.add(this.folderButton);
        jstreet.reset(con);
        con.gridx = 11;
        con.gridy = 9;
        con.gridwidth = 1;
        grid.setConstraints(this.folderButton, con);
        this.okButton = new Button("Save");
        this.okButton.addActionListener(this);
        this.namePanel.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 14;
        grid.setConstraints(this.okButton, con);
        this.undoButton = new Button("Undo");
        this.undoButton.addActionListener(this);
        this.namePanel.add(this.undoButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 14;
        grid.setConstraints(this.undoButton, con);
        this.newButton = new Button("New");
        this.newButton.addActionListener(this);
        this.namePanel.add(this.newButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 14;
        grid.setConstraints(this.newButton, con);
        this.copyButton = new Button("Copy");
        this.copyButton.addActionListener(this);
        this.namePanel.add(this.copyButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 14;
        grid.setConstraints(this.copyButton, con);
        this.deleteButton = new Button("Delete");
        this.deleteButton.addActionListener(this);
        this.namePanel.add(this.deleteButton);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 14;
        grid.setConstraints(this.deleteButton, con);
        this.editCheck.setLabel("Allow changes");
        this.editCheck.addItemListener(this);
        this.editCheck.setVisible(false);
        this.editCheck.setState(true);
        this.namePanel.add(this.editCheck);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 16;
        con.gridwidth = 6;
        grid.setConstraints(this.editCheck, con);
        label = new Label("Notes", 2);
        this.namePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 11;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.notesText = new JTextArea();
        this.notesText.setPreferredSize(100, 100);
        this.namePanel.add(this.notesText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 11;
        con.gridwidth = 7;
        con.gridheight = 2;
        grid.setConstraints(this.notesText, con);
        this.namePanel.setLayout(grid);
    }

    public void setEditEnabled(boolean val) {
        try {
            this.folderButton.setEnabled(val);
            this.okButton.setEnabled(val);
            this.undoButton.setEnabled(val);
            this.newButton.setEnabled(val);
            this.copyButton.setEnabled(val);
            this.deleteButton.setEnabled(val);
            this.moreokButton.setEnabled(val);
            this.moreundoButton.setEnabled(val);
            this.morenewButton.setEnabled(val);
            this.morecopyButton.setEnabled(val);
            this.moredeleteButton.setEnabled(val);
            this.shortListCheck.setEnabled(val);
            this.nicknameText.setEditable(val);
            this.emailText.setEditable(val);
            this.fullnameText.setEditable(val);
            this.alertChoice.setEnabled(val);
            this.notesText.setEditable(val);
            this.titleText.setEditable(val);
            this.orgText.setEditable(val);
            this.postaddrText.setEditable(val);
            this.phoneText.setEditable(val);
            this.faxText.setEditable(val);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setupMorePanel() {
        this.morePanel = new Panel();
        this.notebook.add((Component)this.morePanel, "Page 2");
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 10, 10, 10, 5, 10, 5, 10, 5, 10, 60, 5, 10, 15, 10, 5, 10, 5};
        int[] columnWidths = new int[]{5, 50, 5, 50, 5, 50, 5, 50, 5, 50, 1, 1, 1};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Nickname:", 2);
        this.morePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 1;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.nickmoreLabel = new Label();
        this.morePanel.add(this.nickmoreLabel);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        con.gridwidth = 7;
        grid.setConstraints(this.nickmoreLabel, con);
        label = new Label("Email address:", 2);
        this.morePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 2;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.emailmoreLabel = new Label();
        this.morePanel.add(this.emailmoreLabel);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        con.gridwidth = 7;
        grid.setConstraints(this.emailmoreLabel, con);
        label = new Label("Full name:", 2);
        this.morePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 3;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.namemoreLabel = new Label();
        this.morePanel.add(this.namemoreLabel);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        con.gridwidth = 7;
        grid.setConstraints(this.namemoreLabel, con);
        label = new Label("Title", 2);
        this.morePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 5;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.titleText = new TextField();
        this.morePanel.add(this.titleText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        con.gridwidth = 7;
        grid.setConstraints(this.titleText, con);
        label = new Label("Postal", 2);
        this.morePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 9;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.postaddrText = new JTextArea();
        this.postaddrText.setPreferredSize(80, 50);
        this.morePanel.add(this.postaddrText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 9;
        con.gridwidth = 7;
        con.gridheight = 2;
        grid.setConstraints(this.postaddrText, con);
        label = new Label("Phone / Fax", 2);
        this.morePanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 12;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.phoneText = new TextField();
        this.morePanel.add(this.phoneText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 12;
        con.gridwidth = 3;
        grid.setConstraints(this.phoneText, con);
        this.faxText = new TextField();
        this.morePanel.add(this.faxText);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 12;
        con.gridwidth = 3;
        grid.setConstraints(this.faxText, con);
        this.moreokButton = new Button("Save");
        this.moreokButton.addActionListener(this);
        this.morePanel.add(this.moreokButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 14;
        grid.setConstraints(this.moreokButton, con);
        this.moreundoButton = new Button("Undo");
        this.moreundoButton.addActionListener(this);
        this.morePanel.add(this.moreundoButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 14;
        grid.setConstraints(this.moreundoButton, con);
        this.morenewButton = new Button("New");
        this.morenewButton.addActionListener(this);
        this.morePanel.add(this.morenewButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 14;
        grid.setConstraints(this.morenewButton, con);
        this.morecopyButton = new Button("Copy");
        this.morecopyButton.addActionListener(this);
        this.morePanel.add(this.morecopyButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 14;
        grid.setConstraints(this.morecopyButton, con);
        this.moredeleteButton = new Button("Delete");
        this.moredeleteButton.addActionListener(this);
        this.morePanel.add(this.moredeleteButton);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 14;
        grid.setConstraints(this.moredeleteButton, con);
        this.moreeditCheck = new Checkbox("Allow changes");
        this.moreeditCheck.addItemListener(this);
        this.moreeditCheck.setState(true);
        this.moreeditCheck.setVisible(false);
        this.morePanel.add(this.moreeditCheck);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 16;
        con.gridwidth = 4;
        grid.setConstraints(this.moreeditCheck, con);
        this.morePanel.setLayout(grid);
    }

    public void setupGroupPanel() {
        this.groupPanel = new Panel();
        this.detPanel.add((Component)this.groupPanel, "grouppanel");
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 170, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 45, 5, 45, 5, 20, 5, 20, 5, 45, 5, 45, 5, 10, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Nickname", 2);
        this.groupPanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 1;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.nickgroupText = new TextField();
        this.groupPanel.add(this.nickgroupText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        con.gridwidth = 5;
        grid.setConstraints(this.nickgroupText, con);
        this.groupshortCheck = new Checkbox("Short list");
        this.groupPanel.add(this.groupshortCheck);
        jstreet.reset(con);
        con.gridx = 11;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(this.groupshortCheck, con);
        label = new Label("Full name", 2);
        this.groupPanel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 3;
        con.gridwidth = 4;
        grid.setConstraints(label, con);
        this.namegroupText = new TextField();
        this.groupPanel.add(this.namegroupText);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        con.gridwidth = 8;
        grid.setConstraints(this.namegroupText, con);
        label = new Label("Nicknames");
        this.groupPanel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        label = new Label("Group Members");
        this.groupPanel.add(label);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 5;
        con.gridwidth = 5;
        grid.setConstraints(label, con);
        this.nicklist = new JList(0, true);
        this.nicklist.setPreferredSize(30, 100);
        this.groupPanel.add(this.nicklist);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 6;
        con.gridwidth = 5;
        grid.setConstraints(this.nicklist, con);
        this.glist = new JList(0, true);
        this.glist.setPreferredSize(30, 100);
        this.groupPanel.add(this.glist);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 6;
        con.gridwidth = 5;
        grid.setConstraints(this.glist, con);
        this.groupAddButton = new Button("Add member");
        this.groupAddButton.addActionListener(this);
        this.groupPanel.add(this.groupAddButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 8;
        con.gridwidth = 3;
        grid.setConstraints(this.groupAddButton, con);
        this.groupRemoveButton = new Button("Remove member");
        this.groupRemoveButton.addActionListener(this);
        this.groupPanel.add(this.groupRemoveButton);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 8;
        con.gridwidth = 3;
        grid.setConstraints(this.groupRemoveButton, con);
        this.groupOkButton = new Button("Save");
        this.groupOkButton.addActionListener(this);
        this.groupPanel.add(this.groupOkButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 10;
        grid.setConstraints(this.groupOkButton, con);
        this.groupCancelButton = new Button("Undo");
        this.groupCancelButton.addActionListener(this);
        this.groupPanel.add(this.groupCancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 10;
        grid.setConstraints(this.groupCancelButton, con);
        this.groupNewButton = new Button("New");
        this.groupNewButton.addActionListener(this);
        this.groupPanel.add(this.groupNewButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 10;
        con.gridwidth = 3;
        grid.setConstraints(this.groupNewButton, con);
        this.groupCopyButton = new Button("Copy");
        this.groupCopyButton.addActionListener(this);
        this.groupPanel.add(this.groupCopyButton);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 10;
        grid.setConstraints(this.groupCopyButton, con);
        this.groupDelButton = new Button("Delete");
        this.groupDelButton.addActionListener(this);
        this.groupPanel.add(this.groupDelButton);
        jstreet.reset(con);
        con.gridx = 11;
        con.gridy = 10;
        grid.setConstraints(this.groupDelButton, con);
        this.groupPanel.setLayout(grid);
    }

    public void deSelectAll() {
        int[] index;
        if (this.mainList != null && (index = this.mainList.getSelectedIndexes()) != null) {
            for (int i = 0; i < index.length; ++i) {
                this.mainList.deselect(index[i]);
            }
        }
    }

    public void clearAddressBook() {
        this.addrbook = null;
        this.deSelectAll();
        this.clearNames();
        this.clearGroups();
        this.activeIndex = -1;
    }

    public void clearValues() {
        if (this.currentStyle == 4) {
            this.clearGroups();
        } else {
            this.clearNames();
        }
        this.activeIndex = -1;
    }

    public void clearGroups() {
        this.groupshortCheck.setState(false);
        ((TextComponent)this.nickgroupText).setText("");
        ((TextComponent)this.namegroupText).setText("");
        this.glist.removeAll();
    }

    public void clearNames() {
        this.shortListCheck.setState(false);
        ((TextComponent)this.nicknameText).setText("");
        ((TextComponent)this.emailText).setText("");
        ((TextComponent)this.fullnameText).setText("");
        this.alertChoice.removeAll();
        this.folderText.setText("");
        this.notesText.setText("");
        this.nickmoreLabel.setText("");
        this.emailmoreLabel.setText("");
        this.namemoreLabel.setText("");
        this.postaddrText.setText("");
        ((TextComponent)this.titleText).setText("");
        ((TextComponent)this.orgText).setText("");
        ((TextComponent)this.phoneText).setText("");
        ((TextComponent)this.faxText).setText("");
    }

    public void copyValues() {
        if (this.currentStyle == 4) {
            ((TextComponent)this.nickgroupText).setText("");
        } else {
            ((TextComponent)this.nicknameText).setText("");
        }
        this.activeIndex = -1;
    }

    public boolean deleteValue() {
        boolean ret_code = true;
        int listIndex = this.mainList.getSelectedIndex();
        if (this.activeIndex >= 0) {
            if (this.currentStyle == 4) {
                AddressGroup group = this.addrbook.getGroup(this.activeIndex);
                this.addrbook.removeGroup(group);
                this.indexVector.removeElementAt(listIndex);
                for (int i = listIndex; i < this.indexVector.size(); ++i) {
                    this.indexVector.setElementAt(new Integer((Integer)this.indexVector.elementAt(i) - 1), i);
                }
            } else {
                Address addr = this.addrbook.getAddress(this.activeIndex);
                for (int i = 0; i < this.addrbook.groupSize(); ++i) {
                    AddressGroup group = this.addrbook.getGroup(i);
                    group.remove(addr.nickname);
                }
                this.addrbook.removeAddress(addr);
                this.indexVector.removeElementAt(listIndex);
                for (int i = listIndex; i < this.indexVector.size(); ++i) {
                    this.indexVector.setElementAt(new Integer((Integer)this.indexVector.elementAt(i) - 1), i);
                }
            }
            this.mainList.delItem(listIndex);
            this.addrbook.save();
        }
        this.activeIndex = -1;
        if (this.mainList.getItemCount() == 0) {
            this.clearValues();
        } else {
            if (listIndex == this.mainList.getItemCount()) {
                --listIndex;
            }
            this.mainList.select(listIndex);
            this.loadAddress();
        }
        return ret_code;
    }

    public int getListIndex(int ind) {
        int index = -1;
        if (ind >= 0) {
            index = this.currentStyle == 4 ? this.addrbook.getGroup(this.activeIndex).getListIndex() : this.addrbook.getAddress((int)this.activeIndex).listindex;
        }
        return index;
    }

    public boolean saveValues(boolean override) {
        boolean ret_code = true;
        switch (this.currentStyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                ret_code = this.saveAddressValues(override);
                break;
            }
            case 4: {
                ret_code = this.saveGroupValues(override);
            }
        }
        return ret_code;
    }

    public boolean saveGroupValues(boolean override) {
        boolean ret_code = true;
        AddressGroup group = new AddressGroup();
        AddressGroup tgroup = null;
        if (this.readValues(group) && group.getNickname().length() > 0) {
            if (this.activeIndex >= 0) {
                tgroup = this.addrbook.getGroup(this.activeIndex);
                if (!tgroup.compareTo(group)) {
                    tgroup.copy(group);
                    this.addrbook.updateGroupNickname(this.activeIndex, tgroup.getNickname());
                    this.replaceValue(tgroup.getListIndex(), tgroup);
                    ret_code = this.addrbook.save();
                }
            } else {
                tgroup = this.getSelectedGroup();
                this.addrbook.addGroup(group);
                this.loadListBox(false);
                this.activeIndex = group.getGroupIndex();
                if (group.getListIndex() >= 0) {
                    this.mainList.select(group.getListIndex());
                }
                ret_code = this.addrbook.save();
            }
        }
        return ret_code;
    }

    public AddressGroup getSelectedGroup() {
        AddressGroup group = null;
        int ind = this.mainList.getSelectedIndex();
        if (ind >= 0) {
            ind = (Integer)this.indexVector.elementAt(ind);
            group = this.addrbook.getGroup(ind);
        }
        return group;
    }

    public boolean saveAddressValues(boolean override) {
        boolean ret_code = true;
        Address addr = new Address();
        Address taddr = null;
        int listIndex = this.mainList.getSelectedIndex();
        if ((this.editCheck.getState() || override) && this.readValues(addr) && addr.nickname.length() > 0) {
            if (this.activeIndex >= 0) {
                taddr = this.addrbook.getAddress(this.activeIndex);
                if (!taddr.compareTo(addr)) {
                    this.addrbook.updateNickname(taddr.nickname, addr.nickname);
                    if (!addr.nickname.equalsIgnoreCase(taddr.nickname)) {
                        MsgBox msg = new MsgBox((Container)this, "Would you like to update your address groups with the new nickname value?", 3);
                        if (msg.ret_code == 0) {
                            this.addrbook.changeGroupNickname(taddr.nickname, addr.nickname);
                        }
                    }
                    taddr.copy(addr);
                    if (taddr.listindex == listIndex) {
                        this.replaceValue(listIndex, taddr);
                    }
                    ret_code = this.addrbook.save();
                }
            } else {
                taddr = this.getSelectedAddr();
                this.addrbook.addAddress(addr);
                this.loadListBox(false);
                this.activeIndex = addr.index;
                listIndex = addr.listindex;
                if (taddr != null) {
                    this.mainList.select(taddr.listindex);
                } else if (addr.listindex >= 0) {
                    this.mainList.select(addr.listindex);
                }
                ret_code = this.addrbook.save();
            }
        } else if (this.editCheck.getState()) {
            ret_code = false;
        }
        return ret_code;
    }

    public boolean addAddress(String nick, String email, String name, String org, boolean shortlist) {
        boolean ret_code = true;
        Address addr = new Address();
        addr.nickname = new String(nick);
        addr.email = new String(email);
        addr.fullname = new String(name);
        addr.org = new String(org);
        addr.shortlist = shortlist;
        this.addrbook.addAddress(addr);
        this.loadListBox(false);
        this.activeIndex = -1;
        ret_code = this.addrbook.save();
        return ret_code;
    }

    public boolean addAddress(Address addr) {
        boolean ret_code = true;
        this.addrbook.addAddress(addr);
        this.loadListBox(false);
        this.activeIndex = -1;
        ret_code = this.addrbook.save();
        return ret_code;
    }

    public Address getSelectedAddr() {
        Address addr = null;
        int ind = this.mainList.getSelectedIndex();
        if (ind >= 0) {
            ind = (Integer)this.indexVector.elementAt(ind);
            addr = this.addrbook.getAddress(ind);
        }
        return addr;
    }

    public void replaceValue(int index, AddressGroup group) {
        boolean select = false;
        if (!this.shortCheck.getState() || group.getShortlist()) {
            if (index >= 0 && index < this.mainList.getItemCount()) {
                select = this.mainList.isIndexSelected(index);
                this.mainList.replaceItem(group.getName(), index);
                if (select) {
                    this.mainList.select(index);
                }
            } else {
                this.mainList.addItem(group.getName());
                index = this.mainList.getItemCount() - 1;
                this.mainList.select(index);
            }
        }
    }

    public void replaceValue(int index, Address addr) {
        boolean select = false;
        String str = null;
        if (!this.shortCheck.getState() || addr.shortlist) {
            select = this.mainList.isIndexSelected(index);
            switch (this.currentStyle) {
                case 0: {
                    str = addr.nickname;
                    break;
                }
                case 2: {
                    str = addr.email;
                    break;
                }
                case 1: {
                    str = addr.getFullnameText();
                    break;
                }
                case 3: {
                    str = addr.getOrgText();
                }
            }
            this.mainList.replaceItem(str, index);
            if (select) {
                this.mainList.select(index);
            }
        }
    }

    public boolean readValues(AddressGroup group) {
        boolean ret_code = true;
        AddressGroup tgroup = null;
        if (this.activeIndex >= 0) {
            tgroup = this.addrbook.getGroup(this.activeIndex);
        }
        if (this.addrbook.duplicateNickname(this.nickgroupText.getText()) && (tgroup == null || !tgroup.getNickname().equalsIgnoreCase(this.nickgroupText.getText().trim()))) {
            ret_code = false;
            MsgBox msgBox = new MsgBox(this, "This is a duplicate nickname.");
        } else {
            group.setShortlist(this.groupshortCheck.getState());
            group.setNickname(this.nickgroupText.getText());
            group.setName(this.namegroupText.getText());
            group.clear();
            String[] nicks = this.glist.getItems();
            for (int i = 0; i < nicks.length; ++i) {
                group.add(nicks[i]);
            }
        }
        return ret_code;
    }

    public boolean isBlankAddress() {
        boolean ret_code = true;
        if (this.nicknameText.getText().length() != 0 || this.emailText.getText().length() != 0 || this.fullnameText.getText().length() != 0 || this.orgText.getText().length() != 0) {
            ret_code = false;
        }
        return ret_code;
    }

    public boolean readValues(Address addr) {
        boolean ret_code;
        block2: {
            Address taddr;
            block5: {
                block4: {
                    block3: {
                        ret_code = true;
                        taddr = null;
                        if (this.activeIndex >= 0) {
                            taddr = this.addrbook.getAddress(this.activeIndex);
                        }
                        if (this.isBlankAddress()) break block2;
                        addr.shortlist = this.shortListCheck.getState();
                        addr.nickname = new String(this.nicknameText.getText());
                        addr.email = new String(this.emailText.getText());
                        addr.fullname = new String(this.fullnameText.getText());
                        if (this.alertChoice.getSelectedItem() != null) {
                            addr.alert = new String(this.alertChoice.getSelectedItem());
                        }
                        addr.folder = new String(this.folderText.getText());
                        addr.notes = new String(AddrBook.removeCarriageReturns(this.notesText.getText()));
                        addr.title = new String(this.titleText.getText());
                        addr.postal = new String(AddrBook.removeCarriageReturns(this.postaddrText.getText()));
                        addr.org = new String(this.orgText.getText());
                        addr.phone = new String(this.phoneText.getText());
                        addr.fax = new String(this.faxText.getText());
                        if (addr.nickname.length() != 0) break block3;
                        ret_code = false;
                        MsgBox msgbox = new MsgBox(this, "Please enter a nickname value.");
                        this.nicknameText.requestFocus();
                        break block2;
                    }
                    if (addr.email.length() != 0) break block4;
                    ret_code = false;
                    MsgBox msgbox = new MsgBox(this, "Please enter an email value.");
                    this.emailText.requestFocus();
                    break block2;
                }
                if (addr.fullname.length() != 0 || addr.org.length() != 0) break block5;
                ret_code = false;
                MsgBox msgbox = new MsgBox(this, "Please enter a value for the full name or the organization.");
                this.fullnameText.requestFocus();
                break block2;
            }
            if (!this.addrbook.duplicateNickname(addr.nickname) || taddr != null && taddr.nickname.equalsIgnoreCase(addr.nickname.trim())) break block2;
            ret_code = false;
            MsgBox msgbox = new MsgBox(this, "This is a duplicate nickname.");
            this.nicknameText.requestFocus();
        }
        return ret_code;
    }

    public static String strip(String text) {
        while (text.endsWith(" ")) {
            text = new String(text.substring(0, text.length() - 1));
        }
        while (text.startsWith(" ")) {
            text = new String(text.substring(1));
        }
        return text;
    }

    public void loadListBox(boolean select) {
        if (this.addrbookload != null) {
            this.addrbookload.stop();
        }
        if (select) {
            this.addrbookload = new AddrBookLoad(this);
            this.addrbookload.start();
        } else {
            this.loadTheListBox(select);
        }
    }

    public void loadTheListBox(boolean select) {
        this.mainList.setVisible(false);
        this.mainList.removeAll();
        this.indexVector.removeAllElements();
        if (this.currentStyle == 4) {
            this.nicklist.setVisible(false);
            this.nicklist.removeAll();
            if (this.addrbook != null) {
                this.addrbook.sortAddresses(0);
                for (int i = 0; i < this.addrbook.addressSize(); ++i) {
                    this.nicklist.addItem(this.addrbook.getNickname(i));
                }
            }
            this.nicklist.setVisible(true);
            if (this.addrbook != null) {
                this.addrbook.sortGroups();
                AddressGroup group = null;
                for (int i = 0; i < this.addrbook.groupSize(); ++i) {
                    group = this.addrbook.getGroup(i);
                    group.setGroupIndex(i);
                    if (!this.shortCheck.getState() || group.getShortlist()) {
                        this.mainList.addItem(group.getName());
                        this.indexVector.addElement(new Integer(i));
                        group.setListIndex(this.mainList.getItemCount() - 1);
                        continue;
                    }
                    group.setListIndex(-1);
                }
            }
            this.mainList.setVisible(true);
            if (select && this.mainList.getItemCount() > 0) {
                this.mainList.select(0);
                this.loadDetail();
            }
        } else {
            if (this.addrbook != null) {
                this.addrbook.sortAddresses(this.currentStyle);
                for (int i = 0; i < this.addrbook.addressSize(); ++i) {
                    this.addToListBox(this.addrbook.getAddress(i));
                }
            }
            this.mainList.setVisible(true);
            if (select && this.mainList.getItemCount() > 0) {
                this.mainList.select(0);
                this.loadAddress();
            }
        }
    }

    public void addToListBox(Address addr) {
        String str = null;
        if (!this.shortCheck.getState() || addr.shortlist) {
            switch (this.currentStyle) {
                case 0: {
                    str = addr.nickname;
                    break;
                }
                case 2: {
                    str = addr.email;
                    break;
                }
                case 1: {
                    str = addr.getFullnameText();
                    break;
                }
                case 3: {
                    str = addr.getOrgText();
                }
            }
            this.mainList.addItem(str);
            addr.index = this.addrbook.addressIndexOf(addr);
            this.indexVector.addElement(new Integer(addr.index));
            addr.listindex = this.mainList.getItemCount() - 1;
        } else {
            addr.listindex = -1;
        }
    }

    public AddressBook getAddressBook() {
        return this.addrbook;
    }

    public void readAddrBook() {
        this.setFrameTitle();
        this.addrbook.read();
        this.setEditEnabled(this.editCheck.getState());
    }

    public static String removeCarriageReturns(String ttext) {
        String text = new String(ttext);
        int spot = 0;
        do {
            if ((spot = text.indexOf("\r")) < 0) continue;
            text = new String(String.valueOf(text.substring(0, spot)).concat(String.valueOf(text.substring(spot + 1))));
        } while (spot >= 0);
        return text;
    }

    public void loadAddress() {
        block4: {
            Address addr = null;
            int listIndex = this.mainList.getSelectedIndex();
            if (this.activeIndex >= 0 && !this.saveValues(false)) break block4;
            this.clearValues();
            if (listIndex < this.indexVector.size()) {
                this.activeIndex = (Integer)this.indexVector.elementAt(listIndex);
                if (this.activeIndex >= 0) {
                    addr = this.addrbook.getAddress(this.activeIndex);
                    if (addr != null) {
                        this.loadValues(addr);
                    } else {
                        MsgBox msgBox = new MsgBox(this, String.valueOf(String.valueOf("No address was found in the address vector at index [").concat(String.valueOf(this.activeIndex))).concat(String.valueOf("]")));
                    }
                }
            }
        }
    }

    public void loadGroup() {
        block3: {
            AddressGroup group = null;
            if (this.activeIndex >= 0 && !this.saveValues(false)) break block3;
            int listIndex = this.mainList.getSelectedIndex();
            this.activeIndex = (Integer)this.indexVector.elementAt(listIndex);
            if (this.activeIndex >= 0) {
                group = this.addrbook.getGroup(this.activeIndex);
                if (group != null) {
                    this.loadValues(group);
                } else {
                    MsgBox msgBox = new MsgBox(this, String.valueOf(String.valueOf("No group was found in the group vector at index [").concat(String.valueOf(this.activeIndex))).concat(String.valueOf("]")));
                }
            }
        }
    }

    public void loadValues(AddressGroup group) {
        boolean spot = false;
        Object text = null;
        this.groupshortCheck.setState(group.getShortlist());
        ((TextComponent)this.nickgroupText).setText(group.getNickname());
        ((TextComponent)this.namegroupText).setText(group.getName());
        this.glist.setVisible(false);
        this.glist.removeAll();
        for (int i = 0; i < group.size(); ++i) {
            if (this.addrbook.resolveNickname(group.get(i)) == null) continue;
            this.glist.addItem(group.get(i));
        }
        this.glist.setVisible(true);
    }

    public void loadValues(Address addr) {
        int spot = 0;
        Object text = null;
        this.shortListCheck.setState(addr.shortlist);
        ((TextComponent)this.nicknameText).setText(addr.nickname);
        ((TextComponent)this.emailText).setText(addr.email);
        ((TextComponent)this.fullnameText).setText(addr.fullname);
        this.nickmoreLabel.setText(addr.nickname);
        this.emailmoreLabel.setText(addr.email);
        this.namemoreLabel.setText(addr.fullname);
        if (addr.alert.length() > 0) {
            spot = -1;
            for (int i = 0; i < this.alertChoice.getItemCount(); ++i) {
                if (addr.alert.compareTo(this.alertChoice.getItem(i)) != 0) continue;
                spot = i;
            }
            if (spot < 0) {
                this.alertChoice.add(addr.alert);
                spot = this.alertChoice.getItemCount() - 1;
            }
            this.alertChoice.select(spot);
        }
        this.folderText.setText(addr.folder);
        this.notesText.setText(addr.notes);
        ((TextComponent)this.titleText).setText(addr.title);
        this.postaddrText.setText(addr.postal);
        ((TextComponent)this.orgText).setText(addr.org);
        ((TextComponent)this.phoneText).setText(addr.phone);
        ((TextComponent)this.faxText).setText(addr.fax);
    }

    public void reloadValues() {
        if (this.activeIndex >= 0) {
            if (this.currentStyle == 4) {
                AddressGroup group = this.addrbook.getGroup(this.activeIndex);
                if (group != null) {
                    this.loadValues(group);
                }
            } else {
                Address addr = this.addrbook.getAddress(this.activeIndex);
                if (addr != null) {
                    this.loadValues(addr);
                }
            }
        } else {
            this.clearValues();
        }
    }

    public static int loadAddressBookVector(Vector bvector, jstreet Jstreet) {
        File dir = new File(Jstreet.getAccountDir());
        AddrBook.addAddressBooks(Jstreet, bvector, dir, false);
        dir = new File(Jstreet.getSystemDir());
        AddrBook.addAddressBooks(Jstreet, bvector, dir, true);
        return bvector.size();
    }

    private static void addAddressBooks(jstreet Jstreet, Vector bvector, File dir, boolean isPublic) {
        String[] filteredList = dir.list(new AddressBookFilter());
        File file = null;
        for (int i = 0; i < filteredList.length; ++i) {
            file = new File(dir, filteredList[i]);
            bvector.addElement(new AddressBook(Jstreet, file, isPublic));
        }
    }

    public void select(int val) {
        if (val >= 0 && val < this.mainList.getItemCount()) {
            this.mainList.select(val);
            this.loadAddress();
        }
    }
}

