/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AddrBook;
import innoval.mailer.AddressBook;
import innoval.mailer.Last15;
import innoval.mailer.MsgBox;
import innoval.mailer.Persona;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class AddrTool
extends Dialog
implements ActionListener {
    Frame parent;
    jstreet Jstreet;
    boolean active;
    String address;
    TextField addrText;
    TextComponent toField;
    List list;
    Label text;
    Button toButton;
    Button ccButton;
    Button bccButton;
    Button editButton;
    Button delButton;
    Button addrButton;
    Button distButton;
    Button okButton;
    Button cancelButton;

    AddrTool(Frame parent, jstreet Jstreet, TextComponent toField) {
        super(parent, "Address Tool", false);
        this.parent = parent;
        this.Jstreet = Jstreet;
        this.toField = toField;
        this.active = true;
        this.address = new String(toField.getText().replace('\r', ' ').replace('\n', ' '));
        this.initDialog();
        this.loadAddresses();
        this.enableEvents(64L);
        this.show();
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 20, 20, 5, 20, 20, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 200, 5, 40, 5, 17, 6, 17, 5, 40, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.addrText = new TextField();
        this.add(this.addrText);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.addrText, con);
        this.toButton = new Button("To:");
        this.toButton.addActionListener(this);
        this.add(this.toButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        grid.setConstraints(this.toButton, con);
        this.ccButton = new Button("Cc:");
        this.ccButton.addActionListener(this);
        this.add(this.ccButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(this.ccButton, con);
        this.bccButton = new Button("Bcc:");
        this.bccButton.addActionListener(this);
        this.add(this.bccButton);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 1;
        grid.setConstraints(this.bccButton, con);
        this.editButton = new Button("Edit Address");
        this.editButton.addActionListener(this);
        this.add(this.editButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        con.gridwidth = 7;
        grid.setConstraints(this.editButton, con);
        this.delButton = new Button("Remove Address");
        this.delButton.addActionListener(this);
        this.add(this.delButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        con.gridwidth = 7;
        grid.setConstraints(this.delButton, con);
        this.addrButton = new Button("Address Book");
        this.addrButton.addActionListener(this);
        this.add(this.addrButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        con.gridwidth = 7;
        grid.setConstraints(this.addrButton, con);
        this.distButton = new Button("Distribution List");
        this.distButton.addActionListener(this);
        this.add(this.distButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 9;
        con.gridwidth = 7;
        grid.setConstraints(this.distButton, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 11;
        con.gridwidth = 3;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 11;
        con.gridwidth = 3;
        grid.setConstraints(this.cancelButton, con);
        this.list = new List();
        this.list.addActionListener(this);
        this.list.setBackground(Color.white);
        this.add(this.list);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridheight = 9;
        grid.setConstraints(this.list, con);
        this.text = new Label("", 1);
        this.add(this.text);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 13;
        con.gridwidth = 9;
        grid.setConstraints(this.text, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.parent);
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.address = new String("");
            for (int i = 0; i < this.list.getItemCount(); ++i) {
                this.address = this.address.length() == 0 ? new String(this.list.getItem(i)) : new String(String.valueOf(String.valueOf(this.address).concat(String.valueOf(","))).concat(String.valueOf(this.list.getItem(i))));
            }
            this.toField.setText(this.address);
            this.Close();
        } else if (e.getSource() == this.cancelButton) {
            this.Close();
        } else if (e.getSource() == this.toButton || e.getSource() == this.ccButton || e.getSource() == this.bccButton) {
            String item = this.addrText.getText();
            String add = null;
            if (e.getSource() == this.toButton) {
                add = new String("To: ");
            } else if (e.getSource() == this.ccButton) {
                add = new String("cc: ");
            } else if (e.getSource() == this.bccButton) {
                add = new String("bcc: ");
            }
            if (item.length() > 6 && item.toLowerCase().startsWith("file:")) {
                this.loadDistfile(add, new File(item.substring(5).trim()));
            } else if (item.length() > 0) {
                if (item.indexOf(64) < 0) {
                    item = new String(AddressBook.lookupNickname((jstreet)this.Jstreet, (AddressBook)this.Jstreet.addrbook, (String)item).name);
                }
                item = Persona.formatAddress(item);
                add = new String(String.valueOf(add).concat(String.valueOf(item)));
                this.list.addItem(add);
            }
            ((TextComponent)this.addrText).setText("");
            this.addrText.requestFocus();
            this.listCount();
        } else if (e.getSource() == this.delButton) {
            int sel = this.list.getSelectedIndex();
            if (sel >= 0) {
                this.list.delItem(sel);
                if (this.list.getItemCount() > sel) {
                    this.list.select(sel);
                }
            }
            this.listCount();
        } else if (e.getSource() == this.editButton || e.getSource() == this.list) {
            int sel = this.list.getSelectedIndex();
            if (sel >= 0) {
                String item = this.list.getSelectedItem();
                int spot = item.indexOf(58);
                item = new String(item.substring(spot + 2));
                ((TextComponent)this.addrText).setText(item);
                this.list.delItem(sel);
            }
            this.addrText.requestFocus();
            this.listCount();
        } else if (e.getSource() == this.addrButton) {
            AddrBook addr = new AddrBook(this.parent, this.Jstreet, this.Jstreet.addrbook);
            if (addr.getAddressBook() != null) {
                addr.setRemoteList(this.list);
                addr.show();
                this.Jstreet.addrbook = addr.getAddressBook();
            }
            this.listCount();
        } else if (e.getSource() == this.distButton) {
            this.loadDistlist();
        }
    }

    public void Close() {
        this.toField.setEditable(true);
        this.active = false;
        this.dispose();
    }

    private void loadAddresses() {
        String addr = new String(this.address);
        String name = null;
        int spot = 0;
        Vector addrVector = Last15.parseAddresses(addr);
        for (int i = 0; i < addrVector.size(); ++i) {
            name = (String)addrVector.elementAt(i);
            spot = name.indexOf(58);
            if (spot < 0) {
                name = new String(String.valueOf("To: ").concat(String.valueOf(name)));
            }
            this.list.addItem(name);
        }
        this.listCount();
    }

    private void listCount() {
        int cc = 0;
        int bcc = 0;
        int to = 0;
        for (int i = 0; i < this.list.getItemCount(); ++i) {
            if (this.list.getItem(i).startsWith("To:")) {
                ++to;
                continue;
            }
            if (this.list.getItem(i).startsWith("bcc:")) {
                ++bcc;
                continue;
            }
            if (!this.list.getItem(i).startsWith("cc:")) continue;
            ++cc;
        }
        this.text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[To: ").concat(String.valueOf(to))).concat(String.valueOf("] [Cc: "))).concat(String.valueOf(cc))).concat(String.valueOf("] [Bcc: "))).concat(String.valueOf(bcc))).concat(String.valueOf("] [Total: "))).concat(String.valueOf(to + cc + bcc))).concat(String.valueOf("]")));
    }

    public void loadDistlist() {
        FileDialog filedialog = new FileDialog(this.parent, "Select a Distribution List File", 0);
        filedialog.show();
        String file = filedialog.getFile();
        if (file != null) {
            this.loadDistfile("To: ", new File(String.valueOf(filedialog.getDirectory()).concat(String.valueOf(file))));
        }
    }

    public void loadDistfile(String add, File file) {
        String text = null;
        try {
            if (file.exists() && !file.isDirectory()) {
                this.list.setVisible(false);
                BufferedReader in = new BufferedReader(new FileReader(file));
                do {
                    if ((text = in.readLine()) == null || text.startsWith("/*")) continue;
                    if (text.indexOf(58) < 0) {
                        text = new String(String.valueOf(add).concat(String.valueOf(text)));
                    }
                    this.list.addItem(text);
                } while (text != null);
                in.close();
                this.list.setVisible(true);
            } else {
                MsgBox msgBox = new MsgBox(this.parent, "The specified distribution list file was not found.");
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
        this.listCount();
    }

    public String getAddress() {
        return this.address;
    }
}

